/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.kv;

import com.couchbase.client.scala.codec.JsonDeserializer;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.codec.TranscoderWithSerializer;
import com.couchbase.client.scala.codec.TranscoderWithoutSerializer;
import com.couchbase.client.scala.json.JsonObject;
import com.couchbase.client.scala.kv.GetResult$;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Failure$;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success$;
import scala.util.Try;

public class GetResult
implements Product,
Serializable {
    private final String id;
    private final Either _content;
    private final int flags;
    private final long cas;
    private final Option expiryTime;
    private final Transcoder transcoder;

    public static GetResult apply(String string, Either<byte[], JsonObject> either, int n, long l, Option<Instant> option, Transcoder transcoder) {
        return GetResult$.MODULE$.apply(string, either, n, l, option, transcoder);
    }

    public static GetResult fromProduct(Product product) {
        return GetResult$.MODULE$.fromProduct(product);
    }

    public static GetResult unapply(GetResult getResult) {
        return GetResult$.MODULE$.unapply(getResult);
    }

    public GetResult(String id, Either<byte[], JsonObject> _content, int flags, long cas, Option<Instant> expiryTime, Transcoder transcoder) {
        this.id = id;
        this._content = _content;
        this.flags = flags;
        this.cas = cas;
        this.expiryTime = expiryTime;
        this.transcoder = transcoder;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.id()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this._content()));
        n = Statics.mix((int)n, (int)this.flags());
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.cas()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.expiryTime()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.transcoder()));
        return Statics.finalizeHash((int)n, (int)6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof GetResult)) return false;
        GetResult getResult = (GetResult)object;
        if (this.flags() != getResult.flags()) return false;
        if (this.cas() != getResult.cas()) return false;
        String string = this.id();
        String string2 = getResult.id();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Either<byte[], JsonObject> either = this._content();
        Either<byte[], JsonObject> either2 = getResult._content();
        if (either == null) {
            if (either2 != null) {
                return false;
            }
        } else if (!either.equals(either2)) return false;
        Option<Instant> option = this.expiryTime();
        Option<Instant> option2 = getResult.expiryTime();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Transcoder transcoder = this.transcoder();
        Transcoder transcoder2 = getResult.transcoder();
        if (transcoder == null) {
            if (transcoder2 != null) {
                return false;
            }
        } else if (!transcoder.equals(transcoder2)) return false;
        if (!getResult.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof GetResult;
    }

    public int productArity() {
        return 6;
    }

    public String productPrefix() {
        return "GetResult";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this._3());
            }
            case 3: {
                return BoxesRunTime.boxToLong((long)this._4());
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "id";
            }
            case 1: {
                return "_content";
            }
            case 2: {
                return "flags";
            }
            case 3: {
                return "cas";
            }
            case 4: {
                return "expiryTime";
            }
            case 5: {
                return "transcoder";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String id() {
        return this.id;
    }

    private Either<byte[], JsonObject> _content() {
        return this._content;
    }

    public int flags() {
        return this.flags;
    }

    public long cas() {
        return this.cas;
    }

    public Option<Instant> expiryTime() {
        return this.expiryTime;
    }

    public Transcoder transcoder() {
        return this.transcoder;
    }

    public Option<Duration> expiry() {
        return this.expiryTime().map((Function1 & Serializable)i -> Duration$.MODULE$.apply(i.getEpochSecond(), TimeUnit.SECONDS));
    }

    public <T> Try<T> contentAs(JsonDeserializer<T> deserializer, ClassTag<T> tag) {
        Either<byte[], JsonObject> either = this._content();
        if (either instanceof Left) {
            byte[] bytes = (byte[])((Left)either).value();
            Transcoder transcoder = this.transcoder();
            if (transcoder instanceof TranscoderWithSerializer) {
                TranscoderWithSerializer t = (TranscoderWithSerializer)transcoder;
                return t.decode(bytes, this.flags(), deserializer, tag);
            }
            if (transcoder instanceof TranscoderWithoutSerializer) {
                TranscoderWithoutSerializer t = (TranscoderWithoutSerializer)transcoder;
                return t.decode(bytes, this.flags(), tag);
            }
            throw new MatchError((Object)transcoder);
        }
        if (either instanceof Right) {
            JsonObject obj = (JsonObject)((Right)either).value();
            Option option = tag.unapply((Object)obj);
            if (option instanceof Some) {
                Object o = ((Some)option).value();
                return Success$.MODULE$.apply(o);
            }
            return Failure$.MODULE$.apply((Throwable)new IllegalArgumentException("Projection results can currently only be returned with contentAs[JsonObject]"));
        }
        throw new MatchError(either);
    }

    public GetResult copy(String id, Either<byte[], JsonObject> _content, int flags, long cas, Option<Instant> expiryTime, Transcoder transcoder) {
        return new GetResult(id, _content, flags, cas, expiryTime, transcoder);
    }

    public String copy$default$1() {
        return this.id();
    }

    public Either<byte[], JsonObject> copy$default$2() {
        return this._content();
    }

    public int copy$default$3() {
        return this.flags();
    }

    public long copy$default$4() {
        return this.cas();
    }

    public Option<Instant> copy$default$5() {
        return this.expiryTime();
    }

    public Transcoder copy$default$6() {
        return this.transcoder();
    }

    public String _1() {
        return this.id();
    }

    public Either<byte[], JsonObject> _2() {
        return this._content();
    }

    public int _3() {
        return this.flags();
    }

    public long _4() {
        return this.cas();
    }

    public Option<Instant> _5() {
        return this.expiryTime();
    }

    public Transcoder _6() {
        return this.transcoder();
    }
}

