/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.codec;

import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.scala.codec.EncodedValue;
import com.couchbase.client.scala.codec.EncodedValue$;
import com.couchbase.client.scala.codec.RawStringTranscoder$;
import com.couchbase.client.scala.codec.TranscoderWithoutSerializer;
import java.nio.charset.StandardCharsets;
import scala.reflect.ClassTag;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;

public class RawStringTranscoder
implements TranscoderWithoutSerializer {
    public static RawStringTranscoder Instance() {
        return RawStringTranscoder$.MODULE$.Instance();
    }

    @Override
    public <T> Try<EncodedValue> encode(T value) {
        T t = value;
        if (t instanceof String) {
            String x = (String)t;
            return Success$.MODULE$.apply((Object)EncodedValue$.MODULE$.apply(x.getBytes(StandardCharsets.UTF_8), CodecFlags.STRING_COMPAT_FLAGS));
        }
        return Failure$.MODULE$.apply((Throwable)new IllegalArgumentException("Only String is supported for the RawStringTranscoder!"));
    }

    @Override
    public <T> Try<T> decode(byte[] value, int flags, ClassTag<T> tag) {
        if (tag.runtimeClass().isAssignableFrom(String.class)) {
            return Success$.MODULE$.apply((Object)new String(value, StandardCharsets.UTF_8));
        }
        return Failure$.MODULE$.apply((Throwable)new DecodingFailureException("RawStringTranscoder can only decode into String!"));
    }
}

