/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.codec;

import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.scala.codec.EncodedValue;
import com.couchbase.client.scala.codec.EncodedValue$;
import com.couchbase.client.scala.codec.JsonDeserializer;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.JsonTranscoder$;
import com.couchbase.client.scala.codec.TranscoderWithSerializer;
import java.io.Serializable;
import scala.Function1;
import scala.reflect.ClassTag;
import scala.util.Failure$;
import scala.util.Try;

public class JsonTranscoder
implements TranscoderWithSerializer {
    public static JsonTranscoder Instance() {
        return JsonTranscoder$.MODULE$.Instance();
    }

    public <T> Try<EncodedValue> encode(T value, JsonSerializer<T> serializer) {
        T t = value;
        if (t instanceof byte[]) {
            byte[] x = (byte[])t;
            return Failure$.MODULE$.apply((Throwable)new InvalidArgumentException("byte[] input is not supported for the JsonTranscoder! If you want to store already encoded JSON, use the RawJsonTranscoder, otherwise store it with the RawBinaryTranscoder!", null, null));
        }
        return serializer.serialize(value).map((Function1 & Serializable)bytes -> EncodedValue$.MODULE$.apply((byte[])bytes, CodecFlags.JSON_COMPAT_FLAGS));
    }

    public <T> Try<T> decode(byte[] input, int flags, JsonDeserializer<T> serializer, ClassTag<T> tag) {
        if (tag.runtimeClass().isAssignableFrom(byte[].class)) {
            return Failure$.MODULE$.apply((Throwable)new InvalidArgumentException("Array[Byte] input is not supported for the JsonTranscoder!. If you want to read already encoded JSON, use the RawJsonTranscoder, otherwise read it with the RawBinaryTranscoder!", null, null));
        }
        return serializer.deserialize(input);
    }
}

