/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.kv.handlers;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.SubDocumentField;
import com.couchbase.client.core.msg.kv.SubdocCommandType;
import com.couchbase.client.core.msg.kv.SubdocGetRequest;
import com.couchbase.client.core.msg.kv.SubdocGetResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.HandlerParams;
import com.couchbase.client.scala.codec.DocumentFlags$;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionalGeneric$;
import com.couchbase.client.scala.json.JsonObject;
import com.couchbase.client.scala.json.JsonObject$;
import com.couchbase.client.scala.kv.Count;
import com.couchbase.client.scala.kv.DefaultErrors$;
import com.couchbase.client.scala.kv.Exists;
import com.couchbase.client.scala.kv.Get;
import com.couchbase.client.scala.kv.GetResult;
import com.couchbase.client.scala.kv.LookupInResult;
import com.couchbase.client.scala.kv.LookupInSpec;
import com.couchbase.client.scala.kv.LookupInSpec$;
import com.couchbase.client.scala.kv.ProjectionsApplier$;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.mutable.ArraySeq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005\rd!B\u0005\u000b\u000191\u0002\u0002\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\t\u000b\t\u0002A\u0011A\u0012\t\u000f\u001d\u0002!\u0019!C\u0005Q!1\u0011\u0007\u0001Q\u0001\n%BQA\r\u0001\u0005\u0002MBq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002\"\u0001!\t!a\t\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R\t)r)\u001a;Tk\n$unY;nK:$\b*\u00198eY\u0016\u0014(BA\u0006\r\u0003!A\u0017M\u001c3mKJ\u001c(BA\u0007\u000f\u0003\tYgO\u0003\u0002\u0010!\u0005)1oY1mC*\u0011\u0011CE\u0001\u0007G2LWM\u001c;\u000b\u0005M!\u0012!C2pk\u000eD'-Y:f\u0015\u0005)\u0012aA2p[N\u0011\u0001a\u0006\t\u00031ii\u0011!\u0007\u0006\u0002\u001f%\u00111$\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\u0005!\u00048\u0001\u0001\t\u0003?\u0001j\u0011AD\u0005\u0003C9\u0011Q\u0002S1oI2,'\u000fU1sC6\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0002%MA\u0011Q\u0005A\u0007\u0002\u0015!)AD\u0001a\u0001=\u00059Q\t\u001f9US6,W#A\u0015\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013\u0001\u00027b]\u001eT\u0011AL\u0001\u0005U\u00064\u0018-\u0003\u00021W\t11\u000b\u001e:j]\u001e\f\u0001\"\u0012=q)&lW\rI\u0001\be\u0016\fX/Z:u+\t!D\u0010F\u00046\tBc\u0016-[9\u0011\u0007YJ4(D\u00018\u0015\tA\u0014$\u0001\u0003vi&d\u0017B\u0001\u001e8\u0005\r!&/\u001f\t\u0003y\tk\u0011!\u0010\u0006\u0003\u001byR!a\u0010!\u0002\u00075\u001cxM\u0003\u0002B!\u0005!1m\u001c:f\u0013\t\u0019UH\u0001\tTk\n$wnY$fiJ+\u0017/^3ti\")Q)\u0002a\u0001\r\u0006\u0011\u0011\u000e\u001a\t\u0003\u000f:s!\u0001\u0013'\u0011\u0005%KR\"\u0001&\u000b\u0005-k\u0012A\u0002\u001fs_>$h(\u0003\u0002N3\u00051\u0001K]3eK\u001aL!\u0001M(\u000b\u00055K\u0002\"B)\u0006\u0001\u0004\u0011\u0016\u0001B:qK\u000e\u00042a\u0015,Y\u001b\u0005!&BA+\u001a\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003/R\u00131aU3r!\tI&,D\u0001\r\u0013\tYFB\u0001\u0007M_>\\W\u000f]%o'B,7\rC\u0003^\u000b\u0001\u0007a,\u0001\bxSRDW\t\u001f9je\u0006$\u0018n\u001c8\u0011\u0005ay\u0016B\u00011\u001a\u0005\u001d\u0011un\u001c7fC:DQAY\u0003A\u0002\r\fq\u0001^5nK>,H\u000f\u0005\u0002eO6\tQM\u0003\u0002g[\u0005!A/[7f\u0013\tAWM\u0001\u0005EkJ\fG/[8o\u0011\u0015QW\u00011\u0001l\u00035\u0011X\r\u001e:z'R\u0014\u0018\r^3hsB\u0011An\\\u0007\u0002[*\u0011a\u000eQ\u0001\u0006e\u0016$(/_\u0005\u0003a6\u0014QBU3uef\u001cFO]1uK\u001eL\b\"\u0002:\u0006\u0001\u0004\u0019\u0018A\u00039be\u0016tGo\u00159b]B\u0019\u0001\u0004\u001e<\n\u0005UL\"AB(qi&|g\u000e\u0005\u0002xu6\t\u0001P\u0003\u0002z\u0001\u0006\u00191M\\2\n\u0005mD(a\u0003*fcV,7\u000f^*qC:$Q!`\u0003C\u0002y\u0014\u0011\u0001V\t\u0004\u007f\u0006\u0015\u0001c\u0001\r\u0002\u0002%\u0019\u00111A\r\u0003\u000f9{G\u000f[5oOB\u0019\u0001$a\u0002\n\u0007\u0005%\u0011DA\u0002B]f\faB]3rk\u0016\u001cH\u000f\u0015:pU\u0016\u001cG/\u0006\u0003\u0002\u0010\u0005}AcC\u001b\u0002\u0012\u0005M\u0011\u0011DA\u000e\u0003;AQ!\u0012\u0004A\u0002\u0019Cq!!\u0006\u0007\u0001\u0004\t9\"A\u0004qe>TWm\u0019;\u0011\u0007M3f\tC\u0003c\r\u0001\u00071\rC\u0003k\r\u0001\u00071\u000eC\u0003s\r\u0001\u00071\u000fB\u0003~\r\t\u0007a0\u0001\u0005sKN\u0004xN\\:f)1\t)#a\u000b\u0002:\u0005m\u0012QHA !\rI\u0016qE\u0005\u0004\u0003Sa!A\u0004'p_.,\b/\u00138SKN,H\u000e\u001e\u0005\u0007e\u001d\u0001\r!!\f\u0011\u000bq\ny#a\r\n\u0007\u0005ERHA\bLKf4\u0016\r\\;f%\u0016\fX/Z:u!\ra\u0014QG\u0005\u0004\u0003oi$!E*vE\u0012|7mR3u%\u0016\u001c\bo\u001c8tK\")Qi\u0002a\u0001\r\"9\u0011\u0011E\u0004A\u0002\u0005M\u0002\"B/\b\u0001\u0004q\u0006bBA!\u000f\u0001\u0007\u00111I\u0001\u000biJ\fgn]2pI\u0016\u0014\b\u0003BA#\u0003\u0017j!!a\u0012\u000b\u0007\u0005%c\"A\u0003d_\u0012,7-\u0003\u0003\u0002N\u0005\u001d#A\u0003+sC:\u001c8m\u001c3fe\u0006y!/Z:q_:\u001cX\r\u0015:pU\u0016\u001cG\u000f\u0006\u0006\u0002T\u0005m\u0013QLA0\u0003C\u0002BAN\u001d\u0002VA\u0019\u0011,a\u0016\n\u0007\u0005eCBA\u0005HKR\u0014Vm];mi\"1!\u0007\u0003a\u0001\u0003[AQ!\u0012\u0005A\u0002\u0019Cq!!\t\t\u0001\u0004\t\u0019\u0004C\u0004\u0002B!\u0001\r!a\u0011")
public class GetSubDocumentHandler {
    private final HandlerParams hp;
    private final String ExpTime;

    private String ExpTime() {
        return this.ExpTime;
    }

    public <T> Try<SubdocGetRequest> request(String id, Seq<LookupInSpec> spec, boolean withExpiration, Duration timeout, RetryStrategy retryStrategy, Option<RequestSpan> parentSpan) {
        Try validations = Validate$.MODULE$.notNullOrEmpty(id, "id").flatMap((Function1 & Serializable)x$5 -> {
            String string = x$5;
            return Validate$.MODULE$.notNull(spec, "spec").flatMap((Function1 & Serializable)x$4 -> {
                Object object = x$4;
                return Validate$.MODULE$.notNull(timeout, "timeout").flatMap((Function1 & Serializable)x$3 -> {
                    Object object = x$3;
                    return Validate$.MODULE$.notNull(retryStrategy, "retryStrategy").flatMap((Function1 & Serializable)x$2 -> {
                        Object object = x$2;
                        return Validate$.MODULE$.notNull(parentSpan, "parentSpan").map((Function1 & Serializable)x$1 -> {
                            Object object = x$1;
                            return null;
                        });
                    });
                });
            });
        });
        if (validations.isFailure()) {
            return validations;
        }
        ArrayList<SubdocGetRequest.Command> commands = new ArrayList<SubdocGetRequest.Command>();
        Object object = withExpiration ? BoxesRunTime.boxToBoolean((boolean)commands.add(new SubdocGetRequest.Command(SubdocCommandType.GET, this.ExpTime(), true, spec.size()))) : BoxedUnit.UNIT;
        ((IterableOnceOps)((SeqOps)((IterableOps)spec.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                LookupInSpec x = (LookupInSpec)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if (x instanceof Get) {
                    Get get = (Get)x;
                    String string = get.path();
                    String string2 = "";
                    SubdocCommandType cmd = !(string != null ? !string.equals(string2) : string2 != null) ? SubdocCommandType.GET_DOC : SubdocCommandType.GET;
                    return new SubdocGetRequest.Command(cmd, get.path(), get._xattr(), idx);
                }
            }
            if (tuple2 != null) {
                LookupInSpec x = (LookupInSpec)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if (x instanceof Exists) {
                    Exists exists = (Exists)x;
                    return new SubdocGetRequest.Command(SubdocCommandType.EXISTS, exists.path(), exists._xattr(), idx);
                }
            }
            if (tuple2 != null) {
                LookupInSpec x = (LookupInSpec)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if (x instanceof Count) {
                    Count count = (Count)x;
                    return new SubdocGetRequest.Command(SubdocCommandType.COUNT, count.path(), count._xattr(), idx);
                }
            }
            throw new MatchError((Object)tuple2);
        })).sortBy((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)GetSubDocumentHandler.$anonfun$request$7(x$6)), (Ordering)Ordering.Boolean$.MODULE$)).foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)commands.add(x$1)));
        if (commands.isEmpty()) {
            return new Failure((Throwable)new IllegalArgumentException("No SubDocument commands provided"));
        }
        return new Success((Object)new SubdocGetRequest(timeout, this.hp.core().context(), this.hp.collectionIdentifier(), retryStrategy, id, 0, commands, this.hp.tracer().requestSpan("lookup_in", (RequestSpan)parentSpan.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
    }

    public <T> Try<SubdocGetRequest> requestProject(String id, Seq<String> project, Duration timeout, RetryStrategy retryStrategy, Option<RequestSpan> parentSpan) {
        Try validations = Validate$.MODULE$.notNullOrEmpty(project, "project").map((Function1 & Serializable)x$7 -> {
            Seq seq = x$7;
            return null;
        });
        if (validations.isFailure()) {
            return validations;
        }
        if (project.size() > 16) {
            return new Failure((Throwable)new IllegalArgumentException(new StringBuilder(57).append("A maximum of ").append(16).append(" projection fields are supported").toString()));
        }
        Seq spec = (Seq)project.map((Function1 & Serializable)v -> LookupInSpec$.MODULE$.get((String)v));
        return this.request(id, (Seq<LookupInSpec>)spec, false, timeout, retryStrategy, parentSpan);
    }

    public LookupInResult response(KeyValueRequest<SubdocGetResponse> request, String id, SubdocGetResponse response, boolean withExpiration, Transcoder transcoder) {
        ResponseStatus responseStatus = response.status();
        if (ResponseStatus.SUCCESS.equals(responseStatus)) {
            ArraySeq.ofRef values = Predef$.MODULE$.wrapRefArray((Object[])response.values());
            if (withExpiration) {
                ObjectRef exptime = ObjectRef.create((Object)None$.MODULE$);
                Seq removingExpTime = (Seq)values.filter((Function1 & Serializable)value -> BoxesRunTime.boxToBoolean((boolean)GetSubDocumentHandler.$anonfun$response$1(this, exptime, value)));
                return new LookupInResult(id, (Seq<SubDocumentField>)removingExpTime, DocumentFlags$.MODULE$.Json(), response.cas(), (Option<Instant>)((Option)exptime.elem), transcoder);
            }
            return new LookupInResult(id, (Seq<SubDocumentField>)values, DocumentFlags$.MODULE$.Json(), response.cas(), (Option<Instant>)None$.MODULE$, transcoder);
        }
        if (ResponseStatus.NOT_FOUND.equals(responseStatus)) {
            KeyValueErrorContext ctx = KeyValueErrorContext.completedRequest(request, (Response)response);
            throw new DocumentNotFoundException((ErrorContext)ctx);
        }
        if (ResponseStatus.SUBDOC_FAILURE.equals(responseStatus)) {
            Option option = OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.error()));
            if (option instanceof Some) {
                Some some = (Some)option;
                CouchbaseException err = (CouchbaseException)some.value();
                throw err;
            }
            throw new CouchbaseException("Unknown SubDocument failure occurred", (ErrorContext)ReducedKeyValueErrorContext.create((String)id));
        }
        throw DefaultErrors$.MODULE$.throwOnBadResult(request, (Response)response);
    }

    public Try<GetResult> responseProject(KeyValueRequest<SubdocGetResponse> request, String id, SubdocGetResponse response, Transcoder transcoder) {
        ResponseStatus responseStatus = response.status();
        if (ResponseStatus.SUCCESS.equals(responseStatus)) {
            ArraySeq.ofRef values = Predef$.MODULE$.wrapRefArray((Object[])response.values());
            JsonObject out = JsonObject$.MODULE$.create();
            ObjectRef parsed = ObjectRef.create((Object)new Success((Object)out));
            values.find((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)GetSubDocumentHandler.$anonfun$responseProject$1(parsed, out, v)));
            return ((Try)parsed.elem).map((Function1 & Serializable)x$8 -> new GetResult(id, (Either<byte[], JsonObject>)package$.MODULE$.Right().apply((Object)out), DocumentFlags$.MODULE$.Json(), response.cas(), (Option<Instant>)None$.MODULE$, transcoder));
        }
        if (ResponseStatus.NOT_FOUND.equals(responseStatus)) {
            KeyValueErrorContext ctx = KeyValueErrorContext.completedRequest(request, (Response)response);
            return new Failure((Throwable)new DocumentNotFoundException((ErrorContext)ctx));
        }
        if (ResponseStatus.SUBDOC_FAILURE.equals(responseStatus)) {
            Option option = OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.error()));
            if (option instanceof Some) {
                Some some = (Some)option;
                CouchbaseException err = (CouchbaseException)some.value();
                return new Failure((Throwable)err);
            }
            return new Failure((Throwable)new CouchbaseException("Unknown SubDocument failure occurred", (ErrorContext)ReducedKeyValueErrorContext.create((String)id)));
        }
        return new Failure((Throwable)DefaultErrors$.MODULE$.throwOnBadResult(request, (Response)response));
    }

    public static final /* synthetic */ boolean $anonfun$request$7(SubdocGetRequest.Command x$6) {
        return !x$6.xattr();
    }

    public static final /* synthetic */ boolean $anonfun$response$1(GetSubDocumentHandler $this, ObjectRef exptime$1, SubDocumentField value) {
        String string = value.path();
        String string2 = $this.ExpTime();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String str = new String(value.value(), CharsetUtil.UTF_8);
            exptime$1.elem = new Some((Object)Instant.ofEpochSecond(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(str))));
            return false;
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$responseProject$1(ObjectRef parsed$1, JsonObject out$1, SubDocumentField v) {
        parsed$1.elem = ProjectionsApplier$.MODULE$.parse(out$1, v.path(), v.value());
        return ((Try)parsed$1.elem).isFailure();
    }

    public GetSubDocumentHandler(HandlerParams hp) {
        this.hp = hp;
        this.ExpTime = "$document.exptime";
    }
}

