/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.datastructures;

import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.subdoc.PathExistsException;
import com.couchbase.client.core.error.subdoc.PathNotFoundException;
import com.couchbase.client.scala.Collection;
import com.couchbase.client.scala.codec.JsonDeserializer;
import com.couchbase.client.scala.codec.JsonDeserializer$IntConvert$;
import com.couchbase.client.scala.codec.JsonDeserializer$JsonArraySafeConvert$;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.JsonSerializer$JsonArraySafeConvert$;
import com.couchbase.client.scala.datastructures.CouchbaseCollectionOptions;
import com.couchbase.client.scala.datastructures.CouchbaseCollectionOptions$;
import com.couchbase.client.scala.datastructures.CouchbaseSet$;
import com.couchbase.client.scala.json.JsonArraySafe;
import com.couchbase.client.scala.json.JsonArraySafe$;
import com.couchbase.client.scala.kv.GetOptions;
import com.couchbase.client.scala.kv.GetOptions$;
import com.couchbase.client.scala.kv.GetResult;
import com.couchbase.client.scala.kv.InsertOptions;
import com.couchbase.client.scala.kv.InsertOptions$;
import com.couchbase.client.scala.kv.LookupInOptions;
import com.couchbase.client.scala.kv.LookupInOptions$;
import com.couchbase.client.scala.kv.LookupInResult;
import com.couchbase.client.scala.kv.LookupInSpec;
import com.couchbase.client.scala.kv.LookupInSpec$;
import com.couchbase.client.scala.kv.MutateInOptions;
import com.couchbase.client.scala.kv.MutateInOptions$;
import com.couchbase.client.scala.kv.MutateInResult;
import com.couchbase.client.scala.kv.MutateInSpec;
import com.couchbase.client.scala.kv.MutateInSpec$;
import com.couchbase.client.scala.kv.UpsertOptions;
import com.couchbase.client.scala.kv.UpsertOptions$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.AbstractSet;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005g\u0001B\u0011#\u00015B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\ti\u0001\u0011\t\u0011)A\u0005!\"AA\u000b\u0001B\u0001B\u0003%Q\u000b\u0003\u0005]\u0001\t\u0005\t\u0015a\u0003^\u0011!\u0019\u0007A!A!\u0002\u0017!\u0007\"B4\u0001\t\u0003A\u0007b\u00029\u0001\u0005\u0004%I!\u001d\u0005\u0007e\u0002\u0001\u000b\u0011\u0002-\t\u000fM\u0004!\u0019!C\u0005i\"11\u0010\u0001Q\u0001\nUDq\u0001 \u0001C\u0002\u0013%Q\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0011\u0002@\t\u0013\u0005\u0015\u0001A1A\u0005\n\u0005\u001d\u0001\u0002CA\b\u0001\u0001\u0006I!!\u0003\t\u0013\u0005E\u0001A1A\u0005\n\u0005M\u0001\u0002CA\u000e\u0001\u0001\u0006I!!\u0006\t\u0013\u0005u\u0001A1A\u0005\n\u0005}\u0001\u0002CA\u0014\u0001\u0001\u0006I!!\t\t\u000f\u0005%\u0002\u0001\"\u0011\u0002,!9\u0011q\u0007\u0001\u0005\n\u0005e\u0002bBA!\u0001\u0011\u0005\u0013\u0011\b\u0005\b\u0003\u0007\u0002A\u0011IA#\u0011\u001d\ti\u0005\u0001C\u0005\u0003\u001fBq!a\u0016\u0001\t\u0003\nI\u0006C\u0004\u0002n\u0001!\t%a\u001c\t\u000f\u0005\r\u0005\u0001\"\u0011\u0002\u0006\"9\u00111\u0012\u0001\u0005B\u00055\u0005bBAI\u0001\u0011\u0005\u00131S\u0004\n\u0003/\u0013\u0013\u0011!E\u0001\u000333\u0001\"\t\u0012\u0002\u0002#\u0005\u00111\u0014\u0005\u0007Oz!\t!a)\t\u0013\u0005\u0015f$%A\u0005\u0002\u0005\u001d&\u0001D\"pk\u000eD'-Y:f'\u0016$(BA\u0012%\u00039!\u0017\r^1tiJ,8\r^;sKNT!!\n\u0014\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005\u001dB\u0013AB2mS\u0016tGO\u0003\u0002*U\u0005I1m\\;dQ\n\f7/\u001a\u0006\u0002W\u0005\u00191m\\7\u0004\u0001U\u0011aFO\n\u0003\u0001=\u00022\u0001\r\u001c9\u001b\u0005\t$B\u0001\u001a4\u0003\u001diW\u000f^1cY\u0016T!\u0001N\u001b\u0002\u0015\r|G\u000e\\3di&|gNC\u0001&\u0013\t9\u0014GA\u0006BEN$(/Y2u'\u0016$\bCA\u001d;\u0019\u0001!Qa\u000f\u0001C\u0002q\u0012\u0011\u0001V\t\u0003{\u0005\u0003\"AP \u000e\u0003UJ!\u0001Q\u001b\u0003\u000f9{G\u000f[5oOB\u0011aHQ\u0005\u0003\u0007V\u00121!\u00118z\u0003\tIG\r\u0005\u0002G\u001b:\u0011qi\u0013\t\u0003\u0011Vj\u0011!\u0013\u0006\u0003\u00152\na\u0001\u0010:p_Rt\u0014B\u0001'6\u0003\u0019\u0001&/\u001a3fM&\u0011aj\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051+\u0004CA)S\u001b\u0005!\u0013BA*%\u0005)\u0019u\u000e\u001c7fGRLwN\\\u0001\b_B$\u0018n\u001c8t!\rqd\u000bW\u0005\u0003/V\u0012aa\u00149uS>t\u0007CA-[\u001b\u0005\u0011\u0013BA.#\u0005i\u0019u.^2iE\u0006\u001cXmQ8mY\u0016\u001cG/[8o\u001fB$\u0018n\u001c8t\u0003\u0019!WmY8eKB\u0019a,\u0019\u001d\u000e\u0003}S!\u0001\u0019\u0013\u0002\u000b\r|G-Z2\n\u0005\t|&\u0001\u0005&t_:$Um]3sS\u0006d\u0017N_3s\u0003\u0019)gnY8eKB\u0019a,\u001a\u001d\n\u0005\u0019|&A\u0004&t_:\u001cVM]5bY&TXM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t%lgn\u001c\u000b\u0004U.d\u0007cA-\u0001q!)AL\u0002a\u0002;\")1M\u0002a\u0002I\")AI\u0002a\u0001\u000b\")AG\u0002a\u0001!\"9AK\u0002I\u0001\u0002\u0004)\u0016\u0001B8qiN,\u0012\u0001W\u0001\u0006_B$8\u000fI\u0001\u0010Y>|7.\u001e9J]>\u0003H/[8ogV\tQ\u000f\u0005\u0002ws6\tqO\u0003\u0002yI\u0005\u00111N^\u0005\u0003u^\u0014q\u0002T8pWV\u0004\u0018J\\(qi&|gn]\u0001\u0011Y>|7.\u001e9J]>\u0003H/[8og\u0002\nq\"\\;uCR,\u0017J\\(qi&|gn]\u000b\u0002}B\u0011ao`\u0005\u0004\u0003\u00039(aD'vi\u0006$X-\u00138PaRLwN\\:\u0002!5,H/\u0019;f\u0013:|\u0005\u000f^5p]N\u0004\u0013AC4fi>\u0003H/[8ogV\u0011\u0011\u0011\u0002\t\u0004m\u0006-\u0011bAA\u0007o\nQq)\u001a;PaRLwN\\:\u0002\u0017\u001d,Go\u00149uS>t7\u000fI\u0001\u000eS:\u001cXM\u001d;PaRLwN\\:\u0016\u0005\u0005U\u0001c\u0001<\u0002\u0018%\u0019\u0011\u0011D<\u0003\u001b%s7/\u001a:u\u001fB$\u0018n\u001c8t\u00039Ign]3si>\u0003H/[8og\u0002\nQ\"\u001e9tKJ$x\n\u001d;j_:\u001cXCAA\u0011!\r1\u00181E\u0005\u0004\u0003K9(!D+qg\u0016\u0014Ho\u00149uS>t7/\u0001\bvaN,'\u000f^(qi&|gn\u001d\u0011\u0002\rI,Wn\u001c<f)\u0011\ti#a\r\u0011\u0007y\ny#C\u0002\u00022U\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004\u00026M\u0001\r\u0001O\u0001\u0005K2,W.\u0001\u0006j]&$\u0018.\u00197ju\u0016$\"!a\u000f\u0011\u0007y\ni$C\u0002\u0002@U\u0012A!\u00168ji\u0006)1\r\\3be\u0006!1/\u001b>f+\t\t9\u0005E\u0002?\u0003\u0013J1!a\u00136\u0005\rIe\u000e^\u0001\u0004C2dGCAA)!\u00111\u00151\u000b\u001d\n\u0007\u0005UsJA\u0002TKR\fqAZ8sK\u0006\u001c\u0007.\u0006\u0003\u0002\\\u0005%D\u0003BA\u001e\u0003;Bq!a\u0018\u0019\u0001\u0004\t\t'A\u0001g!\u0019q\u00141\r\u001d\u0002h%\u0019\u0011QM\u001b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA\u001d\u0002j\u00111\u00111\u000e\rC\u0002q\u0012\u0011!V\u0001\tSR,'/\u0019;peV\u0011\u0011\u0011\u000f\t\u0006\u0003g\ni\b\u000f\b\u0005\u0003k\nIHD\u0002I\u0003oJ\u0011!J\u0005\u0004\u0003w*\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003\u007f\n\tI\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\tY(N\u0001\u0007C\u0012$wJ\\3\u0015\t\u0005\u001d\u0015\u0011R\u0007\u0002\u0001!1\u0011Q\u0007\u000eA\u0002a\n1b];ciJ\f7\r^(oKR!\u0011qQAH\u0011\u0019\t)d\u0007a\u0001q\u0005A1m\u001c8uC&t7\u000f\u0006\u0003\u0002.\u0005U\u0005BBA\u001b9\u0001\u0007\u0001(\u0001\u0007D_V\u001c\u0007NY1tKN+G\u000f\u0005\u0002Z=M\u0019a$!(\u0011\u0007y\ny*C\u0002\u0002\"V\u0012a!\u00118z%\u00164GCAAM\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU!\u0011\u0011VA`+\t\tYKK\u0002V\u0003[[#!a,\u0011\t\u0005E\u00161X\u0007\u0003\u0003gSA!!.\u00028\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003s+\u0014AC1o]>$\u0018\r^5p]&!\u0011QXAZ\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0006w\u0001\u0012\r\u0001\u0010")
public class CouchbaseSet<T>
extends AbstractSet<T> {
    private final String id;
    private final Collection collection;
    private final JsonSerializer<T> encode;
    private final CouchbaseCollectionOptions opts;
    private final LookupInOptions lookupInOptions;
    private final MutateInOptions mutateInOptions;
    private final GetOptions getOptions;
    private final InsertOptions insertOptions;
    private final UpsertOptions upsertOptions;

    public static <T> Option<CouchbaseCollectionOptions> $lessinit$greater$default$3() {
        return CouchbaseSet$.MODULE$.$lessinit$greater$default$3();
    }

    private CouchbaseCollectionOptions opts() {
        return this.opts;
    }

    private LookupInOptions lookupInOptions() {
        return this.lookupInOptions;
    }

    private MutateInOptions mutateInOptions() {
        return this.mutateInOptions;
    }

    private GetOptions getOptions() {
        return this.getOptions;
    }

    private InsertOptions insertOptions() {
        return this.insertOptions;
    }

    private UpsertOptions upsertOptions() {
        return this.upsertOptions;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean remove(T elem) {
        Success success;
        scala.collection.immutable.Seq values;
        BooleanRef out = BooleanRef.create((boolean)false);
        Try<GetResult> op = this.collection.get(this.id, this.getOptions());
        Try result = op.flatMap((Function1 & Serializable)x$1 -> x$1.contentAs(JsonDeserializer$JsonArraySafeConvert$.MODULE$, ClassTag$.MODULE$.apply(JsonArraySafe.class))).map((Function1 & Serializable)array -> array.toSeq());
        boolean bl = false;
        Failure failure = null;
        Try try_ = result;
        if (try_ instanceof Success && (values = (scala.collection.immutable.Seq)(success = (Success)try_).value()) instanceof scala.collection.immutable.Seq) {
            scala.collection.immutable.Seq seq = values;
            scala.collection.immutable.Seq zipped = (scala.collection.immutable.Seq)seq.toSeq().zipWithIndex();
            zipped.foreach((Function1 & Serializable)eAndIndex -> {
                CouchbaseSet.$anonfun$remove$3(this, elem, op, out, eAndIndex);
                return BoxedUnit.UNIT;
            });
            return out.elem;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof DocumentNotFoundException) {
                BoxesRunTime.boxToBoolean((boolean)false);
                return out.elem;
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable err = failure.exception();
        throw err;
    }

    private void initialize() {
        this.collection.insert(this.id, JsonArraySafe$.MODULE$.create(), this.insertOptions(), JsonSerializer$JsonArraySafeConvert$.MODULE$).get();
    }

    public void clear() {
        this.collection.upsert(this.id, JsonArraySafe$.MODULE$.create(), this.upsertOptions(), JsonSerializer$JsonArraySafeConvert$.MODULE$).get();
    }

    public int size() {
        Try<LookupInResult> op = this.collection.lookupIn(this.id, (Seq<LookupInSpec>)new .colon.colon((Object)LookupInSpec$.MODULE$.count(""), (List)Nil$.MODULE$), this.lookupInOptions());
        Try result2 = op.flatMap((Function1 & Serializable)result -> result.contentAs(0, JsonDeserializer$IntConvert$.MODULE$, ClassTag$.MODULE$.Int()));
        boolean bl = false;
        Failure failure = null;
        Try try_ = result2;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            int count = BoxesRunTime.unboxToInt((Object)success.value());
            return count;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof DocumentNotFoundException) {
                return 0;
            }
        }
        if (bl) {
            Throwable err = failure.exception();
            throw err;
        }
        throw new MatchError((Object)try_);
    }

    private Set<T> all() {
        Success success;
        Set values;
        Try<GetResult> op = this.collection.get(this.id, this.getOptions());
        Try result = op.flatMap((Function1 & Serializable)x$2 -> x$2.contentAs(JsonDeserializer$JsonArraySafeConvert$.MODULE$, ClassTag$.MODULE$.apply(JsonArraySafe.class))).map((Function1 & Serializable)array -> array.toSeq().toSet());
        boolean bl = false;
        Failure failure = null;
        Try try_ = result;
        if (try_ instanceof Success && (values = (Set)(success = (Success)try_).value()) != null) {
            Set set = values;
            return set;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof DocumentNotFoundException) {
                return Predef$.MODULE$.Set().empty();
            }
        }
        if (bl) {
            Throwable err = failure.exception();
            throw err;
        }
        throw new MatchError((Object)try_);
    }

    public <U> void foreach(Function1<T, U> f) {
        this.all().foreach(f);
    }

    public Iterator<T> iterator() {
        return this.all().iterator();
    }

    public CouchbaseSet<T> addOne(T elem) {
        Try<MutateInResult> result = this.collection.mutateIn(this.id, (Seq<MutateInSpec>)new .colon.colon((Object)MutateInSpec$.MODULE$.arrayAddUnique("", elem, this.encode), (List)Nil$.MODULE$), this.mutateInOptions());
        boolean bl = false;
        Failure failure = null;
        Try<MutateInResult> try_ = result;
        if (try_ instanceof Success) {
            return this;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof DocumentNotFoundException) {
                this.initialize();
                return (CouchbaseSet)this.$plus$eq(elem);
            }
        }
        if (bl && failure.exception() instanceof PathExistsException) {
            return this;
        }
        if (bl) {
            Throwable err = failure.exception();
            throw err;
        }
        throw new MatchError(try_);
    }

    public CouchbaseSet<T> subtractOne(T elem) {
        this.remove(elem);
        return this;
    }

    public boolean contains(T elem) {
        return this.all().contains(elem);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$remove$3(CouchbaseSet $this, Object elem$1, Try op$1, BooleanRef out$1, Tuple2 eAndIndex) {
        block7: {
            block9: {
                block8: {
                    e = eAndIndex._1();
                    index = eAndIndex._2$mcI$sp();
                    if (!BoxesRunTime.equals((Object)e, (Object)elem$1)) break block7;
                    mutateResult = $this.collection.mutateIn($this.id, (Seq<MutateInSpec>)new .colon.colon((Object)MutateInSpec$.MODULE$.remove(new StringBuilder(2).append("[").append(index).append("]").toString()), (List)Nil$.MODULE$), $this.mutateInOptions().cas(((GetResult)op$1.get()).cas()));
                    var9_8 = false;
                    var10_9 = null;
                    var11_10 = mutateResult;
                    if (!(var11_10 instanceof Success)) break block8;
                    v0 = true;
                    break block9;
                }
                if (!(var11_10 instanceof Failure)) ** GOTO lbl-1000
                var9_8 = true;
                var10_9 = (Failure)var11_10;
                if (var10_9.exception() instanceof PathNotFoundException) {
                    v0 = false;
                } else if (var9_8 && (err = var10_9.exception()) instanceof CasMismatchException) {
                    v0 = $this.remove(elem$1);
                } else if (var9_8 && (err = var10_9.exception()) instanceof DocumentNotFoundException) {
                    v0 = false;
                } else {
                    if (var9_8) {
                        err = var10_9.exception();
                        throw err;
                    }
                    throw new MatchError(var11_10);
                }
            }
            out$1.elem = v0;
            return;
        }
    }

    public CouchbaseSet(String id, Collection collection, Option<CouchbaseCollectionOptions> options, JsonDeserializer<T> decode, JsonSerializer<T> encode) {
        CouchbaseCollectionOptions couchbaseCollectionOptions;
        this.id = id;
        this.collection = collection;
        this.encode = encode;
        Option<CouchbaseCollectionOptions> option = options;
        if (option instanceof Some) {
            CouchbaseCollectionOptions v;
            Some some = (Some)option;
            couchbaseCollectionOptions = v = (CouchbaseCollectionOptions)some.value();
        } else {
            couchbaseCollectionOptions = CouchbaseCollectionOptions$.MODULE$.apply(collection, CouchbaseCollectionOptions$.MODULE$.apply$default$2());
        }
        this.opts = couchbaseCollectionOptions;
        this.lookupInOptions = new LookupInOptions(LookupInOptions$.MODULE$.apply$default$1(), LookupInOptions$.MODULE$.apply$default$2(), LookupInOptions$.MODULE$.apply$default$3(), LookupInOptions$.MODULE$.apply$default$4(), LookupInOptions$.MODULE$.apply$default$5()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy());
        this.mutateInOptions = new MutateInOptions(MutateInOptions$.MODULE$.apply$default$1(), MutateInOptions$.MODULE$.apply$default$2(), MutateInOptions$.MODULE$.apply$default$3(), MutateInOptions$.MODULE$.apply$default$4(), MutateInOptions$.MODULE$.apply$default$5(), MutateInOptions$.MODULE$.apply$default$6(), MutateInOptions$.MODULE$.apply$default$7(), MutateInOptions$.MODULE$.apply$default$8(), MutateInOptions$.MODULE$.apply$default$9(), MutateInOptions$.MODULE$.apply$default$10(), MutateInOptions$.MODULE$.apply$default$11(), MutateInOptions$.MODULE$.apply$default$12()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy()).durability(this.opts().durability());
        this.getOptions = new GetOptions(GetOptions$.MODULE$.apply$default$1(), GetOptions$.MODULE$.apply$default$2(), GetOptions$.MODULE$.apply$default$3(), GetOptions$.MODULE$.apply$default$4(), GetOptions$.MODULE$.apply$default$5(), GetOptions$.MODULE$.apply$default$6()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy());
        this.insertOptions = new InsertOptions(InsertOptions$.MODULE$.apply$default$1(), InsertOptions$.MODULE$.apply$default$2(), InsertOptions$.MODULE$.apply$default$3(), InsertOptions$.MODULE$.apply$default$4(), InsertOptions$.MODULE$.apply$default$5(), InsertOptions$.MODULE$.apply$default$6(), InsertOptions$.MODULE$.apply$default$7()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy()).durability(this.opts().durability());
        this.upsertOptions = new UpsertOptions(UpsertOptions$.MODULE$.apply$default$1(), UpsertOptions$.MODULE$.apply$default$2(), UpsertOptions$.MODULE$.apply$default$3(), UpsertOptions$.MODULE$.apply$default$4(), UpsertOptions$.MODULE$.apply$default$5(), UpsertOptions$.MODULE$.apply$default$6(), UpsertOptions$.MODULE$.apply$default$7(), UpsertOptions$.MODULE$.apply$default$8()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy()).durability(this.opts().durability());
    }
}

