/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.datastructures;

import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.subdoc.PathNotFoundException;
import com.couchbase.client.scala.Collection;
import com.couchbase.client.scala.codec.JsonDeserializer;
import com.couchbase.client.scala.codec.JsonDeserializer$IntConvert$;
import com.couchbase.client.scala.codec.JsonDeserializer$JsonObjectSafeConvert$;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.JsonSerializer$JsonObjectSafeConvert$;
import com.couchbase.client.scala.datastructures.CouchbaseCollectionOptions;
import com.couchbase.client.scala.datastructures.CouchbaseCollectionOptions$;
import com.couchbase.client.scala.datastructures.CouchbaseMap$;
import com.couchbase.client.scala.json.JsonObjectSafe;
import com.couchbase.client.scala.json.JsonObjectSafe$;
import com.couchbase.client.scala.kv.GetOptions;
import com.couchbase.client.scala.kv.GetOptions$;
import com.couchbase.client.scala.kv.GetResult;
import com.couchbase.client.scala.kv.InsertOptions;
import com.couchbase.client.scala.kv.InsertOptions$;
import com.couchbase.client.scala.kv.LookupInOptions;
import com.couchbase.client.scala.kv.LookupInOptions$;
import com.couchbase.client.scala.kv.LookupInResult;
import com.couchbase.client.scala.kv.LookupInSpec;
import com.couchbase.client.scala.kv.LookupInSpec$;
import com.couchbase.client.scala.kv.MutateInOptions;
import com.couchbase.client.scala.kv.MutateInOptions$;
import com.couchbase.client.scala.kv.MutateInResult;
import com.couchbase.client.scala.kv.MutateInSpec;
import com.couchbase.client.scala.kv.MutateInSpec$;
import com.couchbase.client.scala.kv.RemoveOptions;
import com.couchbase.client.scala.kv.RemoveOptions$;
import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.AbstractMap;
import scala.collection.mutable.AnyRefMap;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\t=a\u0001\u0002\u0014(\u0001IB\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\ts\u0001\u0011\t\u0011)A\u0005+\"A\u0011\f\u0001B\u0001B\u0003%!\f\u0003\u0005b\u0001\t\u0005\t\u0015a\u0003c\u0011!A\u0007A!A!\u0002\u0017I\u0007\u0002\u00037\u0001\u0005\u0003\u0005\u000b1B7\t\u000bM\u0004A\u0011\u0001;\t\u000fu\u0004!\u0019!C\u0005}\"9\u0011Q\u0002\u0001!\u0002\u0013y\b\"CA\b\u0001\t\u0007I\u0011BA\t\u0011\u001d\t\u0019\u0002\u0001Q\u0001\nuC\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0006\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u00033A\u0011\"a\n\u0001\u0005\u0004%I!!\u000b\t\u0011\u0005E\u0002\u0001)A\u0005\u0003WA\u0011\"a\r\u0001\u0005\u0004%I!!\u000e\t\u0011\u0005u\u0002\u0001)A\u0005\u0003oA\u0011\"a\u0010\u0001\u0005\u0004%I!!\u0011\t\u0011\u0005%\u0003\u0001)A\u0005\u0003\u0007B\u0011\"a\u0013\u0001\u0005\u0004%I!!\u0014\t\u0011\u0005U\u0003\u0001)A\u0005\u0003\u001fBq!a\u0016\u0001\t\u0003\tI\u0006C\u0004\u0002n\u0001!\t%a\u001c\t\u000f\u0005M\u0004\u0001\"\u0011\u0002v!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m\u0004bBAC\u0001\u0011\u0005\u0013q\u0011\u0005\b\u0003\u0017\u0003A\u0011BAG\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003KCq!a*\u0001\t\u0003\nI\u000bC\u0004\u00022\u0002!I!a-\t\u000f\u0005m\u0006\u0001\"\u0011\u0002>\"9\u0011\u0011\u001a\u0001\u0005B\u0005-\u0007bBAh\u0001\u0011\u0005\u0013\u0011[\u0004\n\u0003K<\u0013\u0011!E\u0001\u0003O4\u0001BJ\u0014\u0002\u0002#\u0005\u0011\u0011\u001e\u0005\u0007g\u000e\"\t!!=\t\u0013\u0005M8%%A\u0005\u0002\u0005U(\u0001D\"pk\u000eD'-Y:f\u001b\u0006\u0004(B\u0001\u0015*\u00039!\u0017\r^1tiJ,8\r^;sKNT!AK\u0016\u0002\u000bM\u001c\u0017\r\\1\u000b\u00051j\u0013AB2mS\u0016tGO\u0003\u0002/_\u0005I1m\\;dQ\n\f7/\u001a\u0006\u0002a\u0005\u00191m\\7\u0004\u0001U\u00111GS\n\u0003\u0001Q\u0002B!N\u001e>\u00116\taG\u0003\u00028q\u00059Q.\u001e;bE2,'BA\u001d;\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002U%\u0011AH\u000e\u0002\f\u0003\n\u001cHO]1di6\u000b\u0007\u000f\u0005\u0002?\u000b:\u0011qh\u0011\t\u0003\u0001jj\u0011!\u0011\u0006\u0003\u0005F\na\u0001\u0010:p_Rt\u0014B\u0001#;\u0003\u0019\u0001&/\u001a3fM&\u0011ai\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0011S\u0004CA%K\u0019\u0001!Qa\u0013\u0001C\u00021\u0013\u0011\u0001V\t\u0003\u001bF\u0003\"AT(\u000e\u0003iJ!\u0001\u0015\u001e\u0003\u000f9{G\u000f[5oOB\u0011aJU\u0005\u0003'j\u00121!\u00118z\u0003\tIG\r\u0005\u0002W/6\t\u0011&\u0003\u0002YS\tQ1i\u001c7mK\u000e$\u0018n\u001c8\u0002\u000f=\u0004H/[8ogB\u0019ajW/\n\u0005qS$AB(qi&|g\u000e\u0005\u0002_?6\tq%\u0003\u0002aO\tQ2i\\;dQ\n\f7/Z\"pY2,7\r^5p]>\u0003H/[8og\u00061A-Z2pI\u0016\u00042a\u00194I\u001b\u0005!'BA3*\u0003\u0015\u0019w\u000eZ3d\u0013\t9GM\u0001\tKg>tG)Z:fe&\fG.\u001b>fe\u00061QM\\2pI\u0016\u00042a\u00196I\u0013\tYGM\u0001\bKg>t7+\u001a:jC2L'0\u001a:\u0002\u0007Q\fw\rE\u0002oc\"k\u0011a\u001c\u0006\u0003aj\nqA]3gY\u0016\u001cG/\u0003\u0002s_\nA1\t\\1tgR\u000bw-\u0001\u0004=S:LGO\u0010\u000b\u0005kj\\H\u0010\u0006\u0003wobL\bc\u00010\u0001\u0011\")\u0011m\u0002a\u0002E\")\u0001n\u0002a\u0002S\")An\u0002a\u0002[\")Ak\u0002a\u0001{!)\u0011h\u0002a\u0001+\"9\u0011l\u0002I\u0001\u0002\u0004Q\u0016A\u0002,bYV,7/F\u0001\u0000!\u0011\t\t!a\u0003\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\tA\u0001\\1oO*\u0011\u0011\u0011B\u0001\u0005U\u00064\u0018-C\u0002G\u0003\u0007\tqAV1mk\u0016\u001c\b%\u0001\u0003paR\u001cX#A/\u0002\u000b=\u0004Ho\u001d\u0011\u0002\u001f1|wn[;q\u0013:|\u0005\u000f^5p]N,\"!!\u0007\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b*\u0003\tYg/\u0003\u0003\u0002$\u0005u!a\u0004'p_.,\b/\u00138PaRLwN\\:\u0002!1|wn[;q\u0013:|\u0005\u000f^5p]N\u0004\u0013aD7vi\u0006$X-\u00138PaRLwN\\:\u0016\u0005\u0005-\u0002\u0003BA\u000e\u0003[IA!a\f\u0002\u001e\tyQ*\u001e;bi\u0016Len\u00149uS>t7/\u0001\tnkR\fG/Z%o\u001fB$\u0018n\u001c8tA\u0005Qq-\u001a;PaRLwN\\:\u0016\u0005\u0005]\u0002\u0003BA\u000e\u0003sIA!a\u000f\u0002\u001e\tQq)\u001a;PaRLwN\\:\u0002\u0017\u001d,Go\u00149uS>t7\u000fI\u0001\u000eS:\u001cXM\u001d;PaRLwN\\:\u0016\u0005\u0005\r\u0003\u0003BA\u000e\u0003\u000bJA!a\u0012\u0002\u001e\ti\u0011J\\:feR|\u0005\u000f^5p]N\fa\"\u001b8tKJ$x\n\u001d;j_:\u001c\b%A\u0007sK6|g/Z(qi&|gn]\u000b\u0003\u0003\u001f\u0002B!a\u0007\u0002R%!\u00111KA\u000f\u00055\u0011V-\\8wK>\u0003H/[8og\u0006q!/Z7pm\u0016|\u0005\u000f^5p]N\u0004\u0013aC4fi&sG/\u001a:oC2$B!a\u0017\u0002jA1\u0011QLA2\u0003Oj!!a\u0018\u000b\u0007\u0005\u0005$(\u0001\u0003vi&d\u0017\u0002BA3\u0003?\u00121\u0001\u0016:z!\rq5\f\u0013\u0005\u0007\u0003W2\u0002\u0019A\u001f\u0002\u0007-,\u00170A\u0002hKR$B!a\u001a\u0002r!1\u00111N\fA\u0002u\nQ!\u00199qYf$2\u0001SA<\u0011\u0019\tY\u0007\u0007a\u0001{\u0005A!/Z7pm\u0016\fE\u000f\u0006\u0003\u0002~\u0005\r\u0005c\u0001(\u0002\u0000%\u0019\u0011\u0011\u0011\u001e\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003WJ\u0002\u0019A\u001f\u0002\rI,Wn\u001c<f)\u0011\t9'!#\t\r\u0005-$\u00041\u0001>\u0003Y\u0011X\r\u001e:z\u0013\u001a$un\u0019#pKNtu\u000e^#ySN$H\u0003BA?\u0003\u001fCq!!%\u001c\u0001\u0004\t\u0019*A\u0001g!\u0015q\u0015QSAM\u0013\r\t9J\u000f\u0002\n\rVt7\r^5p]B\u0002D!a'\u0002 B1\u0011QLA2\u0003;\u00032!SAP\t-\t\t+a$\u0002\u0002\u0003\u0005)\u0011\u0001'\u0003\u0007}#\u0013'\u0001\u0006j]&$\u0018.\u00197ju\u0016$\"!! \u0002\tML'0Z\u000b\u0003\u0003W\u00032ATAW\u0013\r\tyK\u000f\u0002\u0004\u0013:$\u0018aA1mYR\u0011\u0011Q\u0017\t\u0006}\u0005]V\bS\u0005\u0004\u0003s;%aA'ba\u00061\u0011\r\u001a3P]\u0016$B!a0\u0002B6\t\u0001\u0001C\u0004\u0002 }\u0001\r!a1\u0011\u000b9\u000b)-\u0010%\n\u0007\u0005\u001d'H\u0001\u0004UkBdWMM\u0001\fgV\u0014GO]1di>sW\r\u0006\u0003\u0002@\u00065\u0007BBA6A\u0001\u0007Q(\u0001\u0005ji\u0016\u0014\u0018\r^8s+\t\t\u0019\u000e\u0005\u0004\u0002V\u0006}\u00171\u0019\b\u0005\u0003/\fYND\u0002A\u00033L\u0011AK\u0005\u0004\u0003;T\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003C\f\u0019O\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\tiNO\u0001\r\u0007>,8\r\u001b2bg\u0016l\u0015\r\u001d\t\u0003=\u000e\u001a2aIAv!\rq\u0015Q^\u0005\u0004\u0003_T$AB!osJ+g\r\u0006\u0002\u0002h\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*B!a>\u0003\u000eU\u0011\u0011\u0011 \u0016\u00045\u0006m8FAA\u007f!\u0011\tyP!\u0003\u000e\u0005\t\u0005!\u0002\u0002B\u0002\u0005\u000b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u001d!(\u0001\u0006b]:|G/\u0019;j_:LAAa\u0003\u0003\u0002\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000b-+#\u0019\u0001'")
public class CouchbaseMap<T>
extends AbstractMap<String, T> {
    private final String id;
    private final Collection collection;
    private final JsonDeserializer<T> decode;
    private final JsonSerializer<T> encode;
    private final ClassTag<T> tag;
    private final String Values;
    private final CouchbaseCollectionOptions opts;
    private final LookupInOptions lookupInOptions;
    private final MutateInOptions mutateInOptions;
    private final GetOptions getOptions;
    private final InsertOptions insertOptions;
    private final RemoveOptions removeOptions;

    public static <T> Option<CouchbaseCollectionOptions> $lessinit$greater$default$3() {
        return CouchbaseMap$.MODULE$.$lessinit$greater$default$3();
    }

    private String Values() {
        return this.Values;
    }

    private CouchbaseCollectionOptions opts() {
        return this.opts;
    }

    private LookupInOptions lookupInOptions() {
        return this.lookupInOptions;
    }

    private MutateInOptions mutateInOptions() {
        return this.mutateInOptions;
    }

    private GetOptions getOptions() {
        return this.getOptions;
    }

    private InsertOptions insertOptions() {
        return this.insertOptions;
    }

    private RemoveOptions removeOptions() {
        return this.removeOptions;
    }

    public Try<Option<T>> getInternal(String key) {
        Try<LookupInResult> op = this.collection.lookupIn(this.id, (Seq<LookupInSpec>)new .colon.colon((Object)LookupInSpec$.MODULE$.get(key), (List)Nil$.MODULE$), this.lookupInOptions());
        Try result2 = op.map((Function1 & Serializable)result -> {
            if (!result.exists(0)) {
                return None$.MODULE$;
            }
            return new Some(result.contentAs(0, $this.decode, $this.tag).get());
        });
        return result2;
    }

    public Option<T> get(String key) {
        Throwable err;
        Try<Option<T>> result = this.getInternal(key);
        boolean bl = false;
        Failure failure = null;
        Try<Option<T>> try_ = result;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Option value = (Option)success.value();
            return value;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable err2 = failure.exception();
            if (err2 instanceof PathNotFoundException) {
                return None$.MODULE$;
            }
        }
        if (bl && (err = failure.exception()) instanceof DocumentNotFoundException) {
            return None$.MODULE$;
        }
        if (bl) {
            Throwable err3 = failure.exception();
            throw err3;
        }
        throw new MatchError(try_);
    }

    public T apply(String key) {
        Failure failure;
        Failure failure2;
        Success success;
        Option option;
        Success success2;
        Option option2;
        Try<Option<T>> result = this.getInternal(key);
        Try<Option<T>> try_ = result;
        if (try_ instanceof Success && (option2 = (Option)(success2 = (Success)try_).value()) instanceof Some) {
            Some some = (Some)option2;
            Object value = some.value();
            return (T)value;
        }
        if (try_ instanceof Success && None$.MODULE$.equals(option = (Option)(success = (Success)try_).value()) ? true : (try_ instanceof Failure && (failure2 = (Failure)try_).exception() instanceof DocumentNotFoundException ? true : try_ instanceof Failure && (failure = (Failure)try_).exception() instanceof PathNotFoundException)) {
            throw new NoSuchElementException(new StringBuilder(14).append("Key ").append(key).append(" not found").toString());
        }
        if (try_ instanceof Failure) {
            Failure failure3 = (Failure)try_;
            Throwable err = failure3.exception();
            throw err;
        }
        throw new MatchError(try_);
    }

    public void removeAt(String key) {
        Throwable err;
        boolean bl = false;
        Failure failure = null;
        Try<MutateInResult> try_ = this.collection.mutateIn(this.id, (Seq<MutateInSpec>)new .colon.colon((Object)MutateInSpec$.MODULE$.remove(key), (List)Nil$.MODULE$), this.mutateInOptions());
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable err2 = failure.exception();
            if (err2 instanceof DocumentNotFoundException) {
                return;
            }
        }
        if (bl && (err = failure.exception()) instanceof PathNotFoundException) {
            return;
        }
        if (bl) {
            Throwable err3 = failure.exception();
            throw err3;
        }
        throw new MatchError(try_);
    }

    public Option<T> remove(String key) {
        Throwable err;
        Try<LookupInResult> op = this.collection.lookupIn(this.id, (Seq<LookupInSpec>)new .colon.colon((Object)LookupInSpec$.MODULE$.get(key), (List)Nil$.MODULE$), this.lookupInOptions());
        Try result2 = op.flatMap((Function1 & Serializable)result -> result.contentAs(0, $this.decode, $this.tag));
        boolean bl = false;
        Failure failure = null;
        Try try_ = result2;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object value = success.value();
            Try<MutateInResult> mutateResult = this.collection.mutateIn(this.id, (Seq<MutateInSpec>)new .colon.colon((Object)MutateInSpec$.MODULE$.remove(key), (List)Nil$.MODULE$), this.mutateInOptions().cas(((LookupInResult)op.get()).cas()));
            boolean bl2 = false;
            Failure failure2 = null;
            Try<MutateInResult> try_2 = mutateResult;
            if (try_2 instanceof Success) {
                return new Some(value);
            }
            if (try_2 instanceof Failure) {
                bl2 = true;
                failure2 = (Failure)try_2;
                Throwable err2 = failure2.exception();
                if (err2 instanceof CasMismatchException) {
                    return this.remove(key);
                }
            }
            if (bl2) {
                Throwable err3 = failure2.exception();
                throw err3;
            }
            throw new MatchError(try_2);
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable err4 = failure.exception();
            if (err4 instanceof DocumentNotFoundException) {
                return None$.MODULE$;
            }
        }
        if (bl && (err = failure.exception()) instanceof PathNotFoundException) {
            return None$.MODULE$;
        }
        if (bl) {
            Throwable err5 = failure.exception();
            throw err5;
        }
        throw new MatchError((Object)try_);
    }

    private void retryIfDocDoesNotExist(Function0<Try<?>> f) {
        block2: {
            Try try_;
            Failure failure;
            boolean bl;
            while (true) {
                Try result = (Try)f.apply();
                bl = false;
                failure = null;
                try_ = result;
                if (try_ instanceof Success) break block2;
                if (!(try_ instanceof Failure)) break;
                bl = true;
                failure = (Failure)try_;
                if (!(failure.exception() instanceof DocumentNotFoundException)) break;
                this.initialize();
            }
            if (bl) {
                Throwable err = failure.exception();
                throw err;
            }
            throw new MatchError((Object)try_);
        }
    }

    private void initialize() {
        this.collection.insert(this.id, JsonObjectSafe$.MODULE$.create(), this.collection.insert$default$3(), this.collection.insert$default$4(), JsonSerializer$JsonObjectSafeConvert$.MODULE$).get();
    }

    public int size() {
        Try<LookupInResult> op = this.collection.lookupIn(this.id, (Seq<LookupInSpec>)new .colon.colon((Object)LookupInSpec$.MODULE$.count(""), (List)Nil$.MODULE$), this.lookupInOptions());
        Try result2 = op.flatMap((Function1 & Serializable)result -> result.contentAs(0, JsonDeserializer$IntConvert$.MODULE$, ClassTag$.MODULE$.Int()));
        boolean bl = false;
        Failure failure = null;
        Try try_ = result2;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            int count = BoxesRunTime.unboxToInt((Object)success.value());
            return count;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof DocumentNotFoundException) {
                return 0;
            }
        }
        if (bl) {
            Throwable err = failure.exception();
            throw err;
        }
        throw new MatchError((Object)try_);
    }

    private Map<String, T> all() {
        Success success;
        AnyRefMap values;
        Try<GetResult> op = this.collection.get(this.id, this.getOptions());
        Try result = op.flatMap((Function1 & Serializable)x$1 -> x$1.contentAs(JsonDeserializer$JsonObjectSafeConvert$.MODULE$, ClassTag$.MODULE$.apply(JsonObjectSafe.class))).map((Function1 & Serializable)obj -> (AnyRefMap)obj.toMap());
        boolean bl = false;
        Failure failure = null;
        Try try_ = result;
        if (try_ instanceof Success && (values = (AnyRefMap)(success = (Success)try_).value()) != null) {
            AnyRefMap anyRefMap = values;
            return anyRefMap.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof DocumentNotFoundException) {
                return Predef$.MODULE$.Map().empty();
            }
        }
        if (bl) {
            Throwable err = failure.exception();
            throw err;
        }
        throw new MatchError((Object)try_);
    }

    public CouchbaseMap<T> addOne(Tuple2<String, T> kv) {
        Function0 & Serializable f = (Function0 & Serializable)() -> $this.collection.mutateIn($this.id, (Seq<MutateInSpec>)new .colon.colon((Object)MutateInSpec$.MODULE$.upsert((String)kv._1(), kv._2(), $this.encode), (List)Nil$.MODULE$), this.mutateInOptions());
        this.retryIfDocDoesNotExist(f);
        return this;
    }

    public CouchbaseMap<T> subtractOne(String key) {
        Try<MutateInResult> result = this.collection.mutateIn(this.id, (Seq<MutateInSpec>)new .colon.colon((Object)MutateInSpec$.MODULE$.remove(key), (List)Nil$.MODULE$), this.mutateInOptions());
        boolean bl = false;
        Failure failure = null;
        Try<MutateInResult> try_ = result;
        if (try_ instanceof Success) {
            return this;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof PathNotFoundException) {
                return this;
            }
        }
        if (bl && failure.exception() instanceof DocumentNotFoundException) {
            return this;
        }
        if (bl) {
            Throwable err = failure.exception();
            throw err;
        }
        throw new MatchError(try_);
    }

    public Iterator<Tuple2<String, T>> iterator() {
        return this.all().iterator();
    }

    public CouchbaseMap(String id, Collection collection, Option<CouchbaseCollectionOptions> options, JsonDeserializer<T> decode, JsonSerializer<T> encode, ClassTag<T> tag) {
        CouchbaseCollectionOptions couchbaseCollectionOptions;
        this.id = id;
        this.collection = collection;
        this.decode = decode;
        this.encode = encode;
        this.tag = tag;
        this.Values = "values.";
        Option<CouchbaseCollectionOptions> option = options;
        if (option instanceof Some) {
            CouchbaseCollectionOptions v;
            Some some = (Some)option;
            couchbaseCollectionOptions = v = (CouchbaseCollectionOptions)some.value();
        } else {
            couchbaseCollectionOptions = CouchbaseCollectionOptions$.MODULE$.apply(collection, CouchbaseCollectionOptions$.MODULE$.apply$default$2());
        }
        this.opts = couchbaseCollectionOptions;
        this.lookupInOptions = new LookupInOptions(LookupInOptions$.MODULE$.apply$default$1(), LookupInOptions$.MODULE$.apply$default$2(), LookupInOptions$.MODULE$.apply$default$3(), LookupInOptions$.MODULE$.apply$default$4(), LookupInOptions$.MODULE$.apply$default$5()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy());
        this.mutateInOptions = new MutateInOptions(MutateInOptions$.MODULE$.apply$default$1(), MutateInOptions$.MODULE$.apply$default$2(), MutateInOptions$.MODULE$.apply$default$3(), MutateInOptions$.MODULE$.apply$default$4(), MutateInOptions$.MODULE$.apply$default$5(), MutateInOptions$.MODULE$.apply$default$6(), MutateInOptions$.MODULE$.apply$default$7(), MutateInOptions$.MODULE$.apply$default$8(), MutateInOptions$.MODULE$.apply$default$9(), MutateInOptions$.MODULE$.apply$default$10(), MutateInOptions$.MODULE$.apply$default$11(), MutateInOptions$.MODULE$.apply$default$12()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy()).durability(this.opts().durability());
        this.getOptions = new GetOptions(GetOptions$.MODULE$.apply$default$1(), GetOptions$.MODULE$.apply$default$2(), GetOptions$.MODULE$.apply$default$3(), GetOptions$.MODULE$.apply$default$4(), GetOptions$.MODULE$.apply$default$5(), GetOptions$.MODULE$.apply$default$6()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy());
        this.insertOptions = new InsertOptions(InsertOptions$.MODULE$.apply$default$1(), InsertOptions$.MODULE$.apply$default$2(), InsertOptions$.MODULE$.apply$default$3(), InsertOptions$.MODULE$.apply$default$4(), InsertOptions$.MODULE$.apply$default$5(), InsertOptions$.MODULE$.apply$default$6(), InsertOptions$.MODULE$.apply$default$7()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy()).durability(this.opts().durability());
        this.removeOptions = new RemoveOptions(RemoveOptions$.MODULE$.apply$default$1(), RemoveOptions$.MODULE$.apply$default$2(), RemoveOptions$.MODULE$.apply$default$3(), RemoveOptions$.MODULE$.apply$default$4(), RemoveOptions$.MODULE$.apply$default$5()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy()).durability(this.opts().durability());
    }
}

