/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.codec;

import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.scala.codec.EncodedValue;
import com.couchbase.client.scala.codec.RawStringTranscoder$;
import com.couchbase.client.scala.codec.TranscoderWithoutSerializer;
import java.nio.charset.StandardCharsets;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u000594AAC\u0006\u0001-!)\u0001\u0005\u0001C\u0001C!)1\u0005\u0001C!I!)A\b\u0001C!{\u001d)qk\u0003E\u00011\u001a)!b\u0003E\u00013\")\u0001%\u0002C\u0001E\"91-\u0002b\u0001\n\u0003!\u0007BB3\u0006A\u0003%!\u0005C\u0004g\u000b\u0005\u0005I\u0011B4\u0003'I\u000bwo\u0015;sS:<GK]1og\u000e|G-\u001a:\u000b\u00051i\u0011!B2pI\u0016\u001c'B\u0001\b\u0010\u0003\u0015\u00198-\u00197b\u0015\t\u0001\u0012#\u0001\u0004dY&,g\u000e\u001e\u0006\u0003%M\t\u0011bY8vG\"\u0014\u0017m]3\u000b\u0003Q\t1aY8n\u0007\u0001\u00192\u0001A\f\u001d!\tA\"$D\u0001\u001a\u0015\u0005q\u0011BA\u000e\u001a\u0005\u0019\te.\u001f*fMB\u0011QDH\u0007\u0002\u0017%\u0011qd\u0003\u0002\u001c)J\fgn]2pI\u0016\u0014x+\u001b;i_V$8+\u001a:jC2L'0\u001a:\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u000f\u0001\u0003\u0019)gnY8eKV\u0011Qe\r\u000b\u0003M=\u00022a\n\u0016-\u001b\u0005A#BA\u0015\u001a\u0003\u0011)H/\u001b7\n\u0005-B#a\u0001+ssB\u0011Q$L\u0005\u0003]-\u0011A\"\u00128d_\u0012,GMV1mk\u0016DQ\u0001\r\u0002A\u0002E\nQA^1mk\u0016\u0004\"AM\u001a\r\u0001\u0011)AG\u0001b\u0001k\t\tA+\u0005\u00027sA\u0011\u0001dN\u0005\u0003qe\u0011qAT8uQ&tw\r\u0005\u0002\u0019u%\u00111(\u0007\u0002\u0004\u0003:L\u0018A\u00023fG>$W-\u0006\u0002?\u0005R\u0019qh\u0013*\u0015\u0005\u0001\u001b\u0005cA\u0014+\u0003B\u0011!G\u0011\u0003\u0006i\r\u0011\r!\u000e\u0005\u0006\t\u000e\u0001\u001d!R\u0001\u0004i\u0006<\u0007c\u0001$J\u00036\tqI\u0003\u0002I3\u00059!/\u001a4mK\u000e$\u0018B\u0001&H\u0005!\u0019E.Y:t)\u0006<\u0007\"\u0002\u0019\u0004\u0001\u0004a\u0005c\u0001\rN\u001f&\u0011a*\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00031AK!!U\r\u0003\t\tKH/\u001a\u0005\u0006'\u000e\u0001\r\u0001V\u0001\u0006M2\fwm\u001d\t\u00031UK!AV\r\u0003\u0007%sG/A\nSC^\u001cFO]5oOR\u0013\u0018M\\:d_\u0012,'\u000f\u0005\u0002\u001e\u000bM\u0019Qa\u0006.\u0011\u0005m\u0003W\"\u0001/\u000b\u0005us\u0016AA5p\u0015\u0005y\u0016\u0001\u00026bm\u0006L!!\u0019/\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0003a\u000b\u0001\"\u00138ti\u0006t7-Z\u000b\u0002E\u0005I\u0011J\\:uC:\u001cW\rI\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0002QB\u0011\u0011\u000e\\\u0007\u0002U*\u00111NX\u0001\u0005Y\u0006tw-\u0003\u0002nU\n1qJ\u00196fGR\u0004")
public class RawStringTranscoder
implements TranscoderWithoutSerializer {
    public static RawStringTranscoder Instance() {
        return RawStringTranscoder$.MODULE$.Instance();
    }

    @Override
    public <T> Try<EncodedValue> encode(T value) {
        T t = value;
        if (t instanceof String) {
            String string = (String)t;
            return new Success((Object)new EncodedValue(string.getBytes(StandardCharsets.UTF_8), CodecFlags.STRING_COMPAT_FLAGS));
        }
        return new Failure((Throwable)new IllegalArgumentException("Only String is supported for the RawStringTranscoder!"));
    }

    @Override
    public <T> Try<T> decode(byte[] value, int flags, ClassTag<T> tag) {
        if (tag.runtimeClass().isAssignableFrom(String.class)) {
            return new Success((Object)new String(value, StandardCharsets.UTF_8));
        }
        return new Failure((Throwable)new DecodingFailureException("RawStringTranscoder can only decode into String!"));
    }
}

