/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.search;

import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.api.search.queries.CoreBooleanFieldQuery;
import com.couchbase.client.core.api.search.queries.CoreBooleanQuery;
import com.couchbase.client.core.api.search.queries.CoreConjunctionQuery;
import com.couchbase.client.core.api.search.queries.CoreCustomQuery;
import com.couchbase.client.core.api.search.queries.CoreDateRangeQuery;
import com.couchbase.client.core.api.search.queries.CoreDisjunctionQuery;
import com.couchbase.client.core.api.search.queries.CoreDocIdQuery;
import com.couchbase.client.core.api.search.queries.CoreGeoBoundingBoxQuery;
import com.couchbase.client.core.api.search.queries.CoreGeoDistanceQuery;
import com.couchbase.client.core.api.search.queries.CoreGeoPolygonQuery;
import com.couchbase.client.core.api.search.queries.CoreMatchAllQuery;
import com.couchbase.client.core.api.search.queries.CoreMatchNoneQuery;
import com.couchbase.client.core.api.search.queries.CoreMatchOperator;
import com.couchbase.client.core.api.search.queries.CoreMatchPhraseQuery;
import com.couchbase.client.core.api.search.queries.CoreMatchQuery;
import com.couchbase.client.core.api.search.queries.CoreNumericRangeQuery;
import com.couchbase.client.core.api.search.queries.CorePhraseQuery;
import com.couchbase.client.core.api.search.queries.CorePrefixQuery;
import com.couchbase.client.core.api.search.queries.CoreQueryStringQuery;
import com.couchbase.client.core.api.search.queries.CoreRegexpQuery;
import com.couchbase.client.core.api.search.queries.CoreSearchRequest;
import com.couchbase.client.core.api.search.queries.CoreTermQuery;
import com.couchbase.client.core.api.search.queries.CoreTermRangeQuery;
import com.couchbase.client.core.api.search.queries.CoreWildcardQuery;
import com.couchbase.client.kotlin.search.ConjunctionQuery;
import com.couchbase.client.kotlin.search.DisjunctionQuery;
import com.couchbase.client.kotlin.search.GeoCircle;
import com.couchbase.client.kotlin.search.GeoDistance;
import com.couchbase.client.kotlin.search.GeoPoint;
import com.couchbase.client.kotlin.search.GeoPolygon;
import com.couchbase.client.kotlin.search.GeoRectangle;
import com.couchbase.client.kotlin.search.GeoShape;
import com.couchbase.client.kotlin.search.SearchSpec;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0019\u0010\u000f\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\u0010H \u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0014\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'\u00a8\u0006("}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery;", "Lcom/couchbase/client/kotlin/search/SearchSpec;", "()V", "core", "Lcom/couchbase/client/core/api/search/CoreSearchQuery;", "getCore$kotlin_client", "()Lcom/couchbase/client/core/api/search/CoreSearchQuery;", "coreRequest", "Lcom/couchbase/client/core/api/search/queries/CoreSearchRequest;", "getCoreRequest$kotlin_client", "()Lcom/couchbase/client/core/api/search/queries/CoreSearchRequest;", "boost", "", "toString", "", "withBoost", "", "withBoost$kotlin_client", "(Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery;", "Companion", "Lcom/couchbase/client/kotlin/search/ConjunctionQuery;", "Lcom/couchbase/client/kotlin/search/DisjunctionQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$BooleanFieldQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$BooleanQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$CustomQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$DateRangeQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$DocumentIdQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$GeoShapeQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchAllQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchNoneQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchPhraseQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$NumericRangeQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$PhraseQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$PrefixQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$QueryStringQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$RegexpQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$TermQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$TermRangeQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$WildcardQuery;", "kotlin-client"})
public abstract class SearchQuery
extends SearchSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private SearchQuery() {
        super(null);
    }

    @NotNull
    public abstract CoreSearchQuery getCore$kotlin_client();

    @NotNull
    public abstract SearchQuery withBoost$kotlin_client(@Nullable Double var1);

    @Override
    @NotNull
    public CoreSearchRequest getCoreRequest$kotlin_client() {
        return new CoreSearchRequest(this.getCore$kotlin_client(), null);
    }

    @NotNull
    public final SearchQuery boost(@NotNull Number boost) {
        Intrinsics.checkNotNullParameter((Object)boost, (String)"boost");
        return this.withBoost$kotlin_client(boost.doubleValue());
    }

    @NotNull
    public String toString() {
        String string = this.getCore$kotlin_client().export().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public /* synthetic */ SearchQuery(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0004\n\u0002\b\u001f\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0013KLMNOPQRSTUVWXYZ[\\]B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bJ\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ'\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00042\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0012\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u000f\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015J-\u0010\u0016\u001a\u00020\u00042%\u0010\u0017\u001a!\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u00a2\u0006\u0002\b\u001bJ<\u0010\u001c\u001a\u00020\u00042\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u001e2\b\b\u0002\u0010!\u001a\u00020\fJ1\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u00042\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0012\"\u00020\u00042\b\b\u0002\u0010%\u001a\u00020&\u00a2\u0006\u0002\u0010'J\u001e\u0010\"\u001a\u00020\b2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\b\b\u0002\u0010%\u001a\u00020&J\u0014\u0010)\u001a\u00020\u00042\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015J \u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0018\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u0002022\b\b\u0002\u0010\r\u001a\u00020\u000eJB\u00103\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u000e2\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u00105\u001a\u0002062\b\b\u0002\u00107\u001a\u00020&2\b\b\u0002\u00108\u001a\u00020&J\u0006\u00109\u001a\u00020\u0004J\u0006\u0010:\u001a\u00020\u0004J$\u0010;\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u000e2\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0004J<\u0010>\u001a\u00020\u00042\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010?2\b\b\u0002\u0010@\u001a\u00020\f2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010?2\b\b\u0002\u0010B\u001a\u00020\fJ\u001e\u0010C\u001a\u00020\u00042\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0018\u0010E\u001a\u00020\u00042\u0006\u0010E\u001a\u00020\u000e2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u000e\u0010F\u001a\u00020\u00042\u0006\u0010F\u001a\u00020\u000eJ\u0018\u0010G\u001a\u00020\u00042\u0006\u0010G\u001a\u00020\u000e2\b\b\u0002\u0010\r\u001a\u00020\u000eJ,\u0010H\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u000e2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u00107\u001a\u00020&2\b\b\u0002\u00108\u001a\u00020&J<\u0010I\u001a\u00020\u00042\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010@\u001a\u00020\f2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010B\u001a\u00020\fJ\u0018\u0010J\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u000e2\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a8\u0006^"}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion;", "", "()V", "boolean", "Lcom/couchbase/client/kotlin/search/SearchQuery;", "must", "Lcom/couchbase/client/kotlin/search/ConjunctionQuery;", "should", "Lcom/couchbase/client/kotlin/search/DisjunctionQuery;", "mustNot", "booleanField", "bool", "", "field", "", "conjunction", "firstConjunct", "remainingConjuncts", "", "(Lcom/couchbase/client/kotlin/search/SearchQuery;[Lcom/couchbase/client/kotlin/search/SearchQuery;)Lcom/couchbase/client/kotlin/search/ConjunctionQuery;", "conjuncts", "", "custom", "customizer", "Lkotlin/Function1;", "", "", "Lkotlin/ExtensionFunctionType;", "dateRange", "start", "Ljava/time/Instant;", "inclusiveStart", "end", "inclusiveEnd", "disjunction", "firstDisjunct", "remainingDisjuncts", "min", "", "(Lcom/couchbase/client/kotlin/search/SearchQuery;[Lcom/couchbase/client/kotlin/search/SearchQuery;I)Lcom/couchbase/client/kotlin/search/DisjunctionQuery;", "disjuncts", "documentId", "ids", "geoDistance", "location", "Lcom/couchbase/client/kotlin/search/GeoPoint;", "distance", "Lcom/couchbase/client/kotlin/search/GeoDistance;", "geoShape", "shape", "Lcom/couchbase/client/kotlin/search/GeoShape;", "match", "analyzer", "operator", "Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchOperator;", "fuzziness", "prefixLength", "matchAll", "matchNone", "matchPhrase", "negation", "query", "numericRange", "", "inclusiveMin", "max", "inclusiveMax", "phrase", "terms", "prefix", "queryString", "regexp", "term", "termRange", "wildcard", "BooleanFieldQuery", "BooleanQuery", "CustomQuery", "DateRangeQuery", "DocumentIdQuery", "GeoShapeQuery", "MatchAllQuery", "MatchNoneQuery", "MatchOperator", "MatchPhraseQuery", "MatchQuery", "NumericRangeQuery", "PhraseQuery", "PrefixQuery", "QueryStringQuery", "RegexpQuery", "TermQuery", "TermRangeQuery", "WildcardQuery", "kotlin-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SearchQuery match(@NotNull String match, @NotNull String field, @Nullable String analyzer, @NotNull MatchOperator operator, int fuzziness, int prefixLength) {
            Intrinsics.checkNotNullParameter((Object)match, (String)"match");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
            return new MatchQuery(match, field, analyzer, operator, fuzziness, prefixLength, null, 64, null);
        }

        public static /* synthetic */ SearchQuery match$default(Companion companion, String string, String string2, String string3, MatchOperator matchOperator, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                string2 = "_all";
            }
            if ((n3 & 4) != 0) {
                string3 = null;
            }
            if ((n3 & 8) != 0) {
                matchOperator = MatchOperator.OR;
            }
            if ((n3 & 0x10) != 0) {
                n = 0;
            }
            if ((n3 & 0x20) != 0) {
                n2 = 0;
            }
            return companion.match(string, string2, string3, matchOperator, n, n2);
        }

        @NotNull
        public final SearchQuery matchPhrase(@NotNull String matchPhrase, @NotNull String field, @Nullable String analyzer) {
            Intrinsics.checkNotNullParameter((Object)matchPhrase, (String)"matchPhrase");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new MatchPhraseQuery(matchPhrase, field, analyzer, null, 8, null);
        }

        public static /* synthetic */ SearchQuery matchPhrase$default(Companion companion, String string, String string2, String string3, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "_all";
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            return companion.matchPhrase(string, string2, string3);
        }

        @NotNull
        public final SearchQuery term(@NotNull String term, @NotNull String field, int fuzziness, int prefixLength) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new TermQuery(term, field, fuzziness, prefixLength, null, 16, null);
        }

        public static /* synthetic */ SearchQuery term$default(Companion companion, String string, String string2, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                string2 = "_all";
            }
            if ((n3 & 4) != 0) {
                n = 0;
            }
            if ((n3 & 8) != 0) {
                n2 = 0;
            }
            return companion.term(string, string2, n, n2);
        }

        @NotNull
        public final SearchQuery phrase(@NotNull List<String> terms, @NotNull String field) {
            Intrinsics.checkNotNullParameter(terms, (String)"terms");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new PhraseQuery(terms, field, null, 4, null);
        }

        public static /* synthetic */ SearchQuery phrase$default(Companion companion, List list, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = "_all";
            }
            return companion.phrase(list, string);
        }

        @NotNull
        public final SearchQuery prefix(@NotNull String prefix, @NotNull String field) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new PrefixQuery(prefix, field, null, 4, null);
        }

        public static /* synthetic */ SearchQuery prefix$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "_all";
            }
            return companion.prefix(string, string2);
        }

        @NotNull
        public final SearchQuery regexp(@NotNull String regexp, @NotNull String field) {
            Intrinsics.checkNotNullParameter((Object)regexp, (String)"regexp");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new RegexpQuery(regexp, field, null, 4, null);
        }

        public static /* synthetic */ SearchQuery regexp$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "_all";
            }
            return companion.regexp(string, string2);
        }

        @NotNull
        public final SearchQuery wildcard(@NotNull String term, @NotNull String field) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new WildcardQuery(term, field, null, 4, null);
        }

        public static /* synthetic */ SearchQuery wildcard$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "_all";
            }
            return companion.wildcard(string, string2);
        }

        @NotNull
        public final SearchQuery queryString(@NotNull String queryString) {
            Intrinsics.checkNotNullParameter((Object)queryString, (String)"queryString");
            return new QueryStringQuery(queryString, null, 2, null);
        }

        @NotNull
        public final SearchQuery booleanField(boolean bool, @NotNull String field) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new BooleanFieldQuery(bool, field, null, 4, null);
        }

        @NotNull
        public final SearchQuery documentId(@NotNull List<String> ids) {
            Intrinsics.checkNotNullParameter(ids, (String)"ids");
            return new DocumentIdQuery(ids, null, 2, null);
        }

        @NotNull
        public final SearchQuery termRange(@NotNull String field, @Nullable String min, boolean inclusiveMin, @Nullable String max, boolean inclusiveMax) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new TermRangeQuery(field, min, inclusiveMin, max, inclusiveMax, null, 32, null);
        }

        public static /* synthetic */ SearchQuery termRange$default(Companion companion, String string, String string2, boolean bl, String string3, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                string = "_all";
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            return companion.termRange(string, string2, bl, string3, bl2);
        }

        @NotNull
        public final SearchQuery numericRange(@NotNull String field, @Nullable Number min, boolean inclusiveMin, @Nullable Number max, boolean inclusiveMax) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new NumericRangeQuery(field, min, inclusiveMin, max, inclusiveMax, null, 32, null);
        }

        public static /* synthetic */ SearchQuery numericRange$default(Companion companion, String string, Number number, boolean bl, Number number2, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                string = "_all";
            }
            if ((n & 2) != 0) {
                number = null;
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                number2 = null;
            }
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            return companion.numericRange(string, number, bl, number2, bl2);
        }

        @NotNull
        public final SearchQuery dateRange(@NotNull String field, @Nullable Instant start, boolean inclusiveStart, @Nullable Instant end, boolean inclusiveEnd) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new DateRangeQuery(field, start, inclusiveStart, end, inclusiveEnd, null, 32, null);
        }

        public static /* synthetic */ SearchQuery dateRange$default(Companion companion, String string, Instant instant, boolean bl, Instant instant2, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                string = "_all";
            }
            if ((n & 2) != 0) {
                instant = null;
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                instant2 = null;
            }
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            return companion.dateRange(string, instant, bl, instant2, bl2);
        }

        @NotNull
        public final SearchQuery geoDistance(@NotNull GeoPoint location, @NotNull GeoDistance distance, @NotNull String field) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)distance, (String)"distance");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return this.geoShape(GeoShape.Companion.circle(location, distance), field);
        }

        public static /* synthetic */ SearchQuery geoDistance$default(Companion companion, GeoPoint geoPoint, GeoDistance geoDistance, String string, int n, Object object) {
            if ((n & 4) != 0) {
                string = "_all";
            }
            return companion.geoDistance(geoPoint, geoDistance, string);
        }

        @NotNull
        public final SearchQuery geoShape(@NotNull GeoShape shape, @NotNull String field) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new GeoShapeQuery(shape, field, null, 4, null);
        }

        public static /* synthetic */ SearchQuery geoShape$default(Companion companion, GeoShape geoShape, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = "_all";
            }
            return companion.geoShape(geoShape, string);
        }

        @NotNull
        public final SearchQuery negation(@NotNull SearchQuery query2) {
            Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
            return com.couchbase.client.kotlin.search.SearchQuery$Companion.boolean$default(this, null, null, com.couchbase.client.kotlin.search.SearchQuery$Companion.disjunction$default(this, query2, new SearchQuery[0], 0, 4, null), 3, null);
        }

        @NotNull
        public final ConjunctionQuery conjunction(@NotNull SearchQuery firstConjunct, SearchQuery ... remainingConjuncts) {
            Intrinsics.checkNotNullParameter((Object)firstConjunct, (String)"firstConjunct");
            Intrinsics.checkNotNullParameter((Object)remainingConjuncts, (String)"remainingConjuncts");
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)firstConjunct);
            spreadBuilder.addSpread((Object)remainingConjuncts);
            return this.conjunction(CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new SearchQuery[spreadBuilder.size()])));
        }

        @NotNull
        public final ConjunctionQuery conjunction(@NotNull List<? extends SearchQuery> conjuncts) {
            Intrinsics.checkNotNullParameter(conjuncts, (String)"conjuncts");
            return new ConjunctionQuery(conjuncts, null, 2, null);
        }

        @NotNull
        public final DisjunctionQuery disjunction(@NotNull SearchQuery firstDisjunct, @NotNull SearchQuery[] remainingDisjuncts, int min) {
            Intrinsics.checkNotNullParameter((Object)firstDisjunct, (String)"firstDisjunct");
            Intrinsics.checkNotNullParameter((Object)remainingDisjuncts, (String)"remainingDisjuncts");
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)firstDisjunct);
            spreadBuilder.addSpread((Object)remainingDisjuncts);
            return this.disjunction(CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new SearchQuery[spreadBuilder.size()])), min);
        }

        public static /* synthetic */ DisjunctionQuery disjunction$default(Companion companion, SearchQuery searchQuery, SearchQuery[] searchQueryArray, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 1;
            }
            return companion.disjunction(searchQuery, searchQueryArray, n);
        }

        @NotNull
        public final DisjunctionQuery disjunction(@NotNull List<? extends SearchQuery> disjuncts, int min) {
            Intrinsics.checkNotNullParameter(disjuncts, (String)"disjuncts");
            return new DisjunctionQuery(disjuncts, min, null, 4, null);
        }

        public static /* synthetic */ DisjunctionQuery disjunction$default(Companion companion, List list, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 1;
            }
            return companion.disjunction(list, n);
        }

        @NotNull
        public final SearchQuery boolean(@Nullable ConjunctionQuery must, @Nullable DisjunctionQuery should, @Nullable DisjunctionQuery mustNot) {
            return new BooleanQuery(must, should, mustNot, null, 8, null);
        }

        public static /* synthetic */ SearchQuery boolean$default(Companion companion, ConjunctionQuery conjunctionQuery, DisjunctionQuery disjunctionQuery, DisjunctionQuery disjunctionQuery2, int n, Object object) {
            if ((n & 1) != 0) {
                conjunctionQuery = null;
            }
            if ((n & 2) != 0) {
                disjunctionQuery = null;
            }
            if ((n & 4) != 0) {
                disjunctionQuery2 = null;
            }
            return companion.boolean(conjunctionQuery, disjunctionQuery, disjunctionQuery2);
        }

        @NotNull
        public final SearchQuery matchAll() {
            return new MatchAllQuery(null, 1, null);
        }

        @NotNull
        public final SearchQuery matchNone() {
            return new MatchNoneQuery(null, 1, null);
        }

        @NotNull
        public final SearchQuery custom(@NotNull Function1<? super Map<String, Object>, Unit> customizer) {
            Intrinsics.checkNotNullParameter(customizer, (String)"customizer");
            Map params = new LinkedHashMap();
            customizer.invoke((Object)params);
            return new CustomQuery(params, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0080\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ.\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001J\u0019\u0010\u001f\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0010\u00a2\u0006\u0004\b \u0010!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000fX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$BooleanFieldQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery;", "bool", "", "field", "", "boost", "", "(ZLjava/lang/String;Ljava/lang/Double;)V", "getBool", "()Z", "getBoost", "()Ljava/lang/Double;", "Ljava/lang/Double;", "core", "Lcom/couchbase/client/core/api/search/queries/CoreBooleanFieldQuery;", "getCore$kotlin_client", "()Lcom/couchbase/client/core/api/search/queries/CoreBooleanFieldQuery;", "getField", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "(ZLjava/lang/String;Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$BooleanFieldQuery;", "equals", "other", "", "hashCode", "", "toString", "withBoost", "withBoost$kotlin_client", "(Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$BooleanFieldQuery;", "kotlin-client"})
        public static final class BooleanFieldQuery
        extends SearchQuery {
            private final boolean bool;
            @NotNull
            private final String field;
            @Nullable
            private final Double boost;
            @NotNull
            private final CoreBooleanFieldQuery core;

            public BooleanFieldQuery(boolean bool, @NotNull String field, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                super(null);
                this.bool = bool;
                this.field = field;
                this.boost = boost;
                this.core = new CoreBooleanFieldQuery(this.bool, this.field, this.boost);
            }

            public /* synthetic */ BooleanFieldQuery(boolean bl, String string, Double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    d = null;
                }
                this(bl, string, d);
            }

            public final boolean getBool() {
                return this.bool;
            }

            @NotNull
            public final String getField() {
                return this.field;
            }

            @Nullable
            public final Double getBoost() {
                return this.boost;
            }

            @NotNull
            public CoreBooleanFieldQuery getCore$kotlin_client() {
                return this.core;
            }

            @Override
            @NotNull
            public BooleanFieldQuery withBoost$kotlin_client(@Nullable Double boost) {
                return BooleanFieldQuery.copy$default(this, false, null, boost, 3, null);
            }

            public final boolean component1() {
                return this.bool;
            }

            @NotNull
            public final String component2() {
                return this.field;
            }

            @Nullable
            public final Double component3() {
                return this.boost;
            }

            @NotNull
            public final BooleanFieldQuery copy(boolean bool, @NotNull String field, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                return new BooleanFieldQuery(bool, field, boost);
            }

            public static /* synthetic */ BooleanFieldQuery copy$default(BooleanFieldQuery booleanFieldQuery, boolean bl, String string, Double d, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = booleanFieldQuery.bool;
                }
                if ((n & 2) != 0) {
                    string = booleanFieldQuery.field;
                }
                if ((n & 4) != 0) {
                    d = booleanFieldQuery.boost;
                }
                return booleanFieldQuery.copy(bl, string, d);
            }

            @Override
            @NotNull
            public String toString() {
                return "BooleanFieldQuery(bool=" + this.bool + ", field=" + this.field + ", boost=" + this.boost + ')';
            }

            public int hashCode() {
                int result2 = Boolean.hashCode(this.bool);
                result2 = result2 * 31 + this.field.hashCode();
                result2 = result2 * 31 + (this.boost == null ? 0 : ((Object)this.boost).hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof BooleanFieldQuery)) {
                    return false;
                }
                BooleanFieldQuery booleanFieldQuery = (BooleanFieldQuery)other;
                if (this.bool != booleanFieldQuery.bool) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.field, (Object)booleanFieldQuery.field)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.boost, (Object)booleanFieldQuery.boost);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0080\b\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ>\u0010\u001a\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\u0019\u0010$\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0010\u00a2\u0006\u0004\b%\u0010&R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\r\u001a\u00020\u000eX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006'"}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$BooleanQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery;", "must", "Lcom/couchbase/client/kotlin/search/ConjunctionQuery;", "should", "Lcom/couchbase/client/kotlin/search/DisjunctionQuery;", "mustNot", "boost", "", "(Lcom/couchbase/client/kotlin/search/ConjunctionQuery;Lcom/couchbase/client/kotlin/search/DisjunctionQuery;Lcom/couchbase/client/kotlin/search/DisjunctionQuery;Ljava/lang/Double;)V", "getBoost", "()Ljava/lang/Double;", "Ljava/lang/Double;", "core", "Lcom/couchbase/client/core/api/search/queries/CoreBooleanQuery;", "getCore$kotlin_client", "()Lcom/couchbase/client/core/api/search/queries/CoreBooleanQuery;", "getMust", "()Lcom/couchbase/client/kotlin/search/ConjunctionQuery;", "getMustNot", "()Lcom/couchbase/client/kotlin/search/DisjunctionQuery;", "getShould", "component1", "component2", "component3", "component4", "copy", "(Lcom/couchbase/client/kotlin/search/ConjunctionQuery;Lcom/couchbase/client/kotlin/search/DisjunctionQuery;Lcom/couchbase/client/kotlin/search/DisjunctionQuery;Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$BooleanQuery;", "equals", "", "other", "", "hashCode", "", "toString", "", "withBoost", "withBoost$kotlin_client", "(Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$BooleanQuery;", "kotlin-client"})
        public static final class BooleanQuery
        extends SearchQuery {
            @Nullable
            private final ConjunctionQuery must;
            @Nullable
            private final DisjunctionQuery should;
            @Nullable
            private final DisjunctionQuery mustNot;
            @Nullable
            private final Double boost;
            @NotNull
            private final CoreBooleanQuery core;

            public BooleanQuery(@Nullable ConjunctionQuery must, @Nullable DisjunctionQuery should, @Nullable DisjunctionQuery mustNot, @Nullable Double boost) {
                super(null);
                this.must = must;
                this.should = should;
                this.mustNot = mustNot;
                this.boost = boost;
                ConjunctionQuery conjunctionQuery = this.must;
                DisjunctionQuery disjunctionQuery = this.mustNot;
                DisjunctionQuery disjunctionQuery2 = this.should;
                this.core = new CoreBooleanQuery((CoreConjunctionQuery)(conjunctionQuery != null ? conjunctionQuery.getCore$kotlin_client() : null), (CoreDisjunctionQuery)(disjunctionQuery != null ? disjunctionQuery.getCore$kotlin_client() : null), (CoreDisjunctionQuery)(disjunctionQuery2 != null ? disjunctionQuery2.getCore$kotlin_client() : null), this.boost);
            }

            public /* synthetic */ BooleanQuery(ConjunctionQuery conjunctionQuery, DisjunctionQuery disjunctionQuery, DisjunctionQuery disjunctionQuery2, Double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 8) != 0) {
                    d = null;
                }
                this(conjunctionQuery, disjunctionQuery, disjunctionQuery2, d);
            }

            @Nullable
            public final ConjunctionQuery getMust() {
                return this.must;
            }

            @Nullable
            public final DisjunctionQuery getShould() {
                return this.should;
            }

            @Nullable
            public final DisjunctionQuery getMustNot() {
                return this.mustNot;
            }

            @Nullable
            public final Double getBoost() {
                return this.boost;
            }

            @NotNull
            public CoreBooleanQuery getCore$kotlin_client() {
                return this.core;
            }

            @Override
            @NotNull
            public BooleanQuery withBoost$kotlin_client(@Nullable Double boost) {
                return BooleanQuery.copy$default(this, null, null, null, boost, 7, null);
            }

            @Nullable
            public final ConjunctionQuery component1() {
                return this.must;
            }

            @Nullable
            public final DisjunctionQuery component2() {
                return this.should;
            }

            @Nullable
            public final DisjunctionQuery component3() {
                return this.mustNot;
            }

            @Nullable
            public final Double component4() {
                return this.boost;
            }

            @NotNull
            public final BooleanQuery copy(@Nullable ConjunctionQuery must, @Nullable DisjunctionQuery should, @Nullable DisjunctionQuery mustNot, @Nullable Double boost) {
                return new BooleanQuery(must, should, mustNot, boost);
            }

            public static /* synthetic */ BooleanQuery copy$default(BooleanQuery booleanQuery, ConjunctionQuery conjunctionQuery, DisjunctionQuery disjunctionQuery, DisjunctionQuery disjunctionQuery2, Double d, int n, Object object) {
                if ((n & 1) != 0) {
                    conjunctionQuery = booleanQuery.must;
                }
                if ((n & 2) != 0) {
                    disjunctionQuery = booleanQuery.should;
                }
                if ((n & 4) != 0) {
                    disjunctionQuery2 = booleanQuery.mustNot;
                }
                if ((n & 8) != 0) {
                    d = booleanQuery.boost;
                }
                return booleanQuery.copy(conjunctionQuery, disjunctionQuery, disjunctionQuery2, d);
            }

            @Override
            @NotNull
            public String toString() {
                return "BooleanQuery(must=" + this.must + ", should=" + this.should + ", mustNot=" + this.mustNot + ", boost=" + this.boost + ')';
            }

            public int hashCode() {
                int result2 = this.must == null ? 0 : this.must.hashCode();
                result2 = result2 * 31 + (this.should == null ? 0 : this.should.hashCode());
                result2 = result2 * 31 + (this.mustNot == null ? 0 : this.mustNot.hashCode());
                result2 = result2 * 31 + (this.boost == null ? 0 : ((Object)this.boost).hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof BooleanQuery)) {
                    return false;
                }
                BooleanQuery booleanQuery = (BooleanQuery)other;
                if (!Intrinsics.areEqual((Object)this.must, (Object)booleanQuery.must)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.should, (Object)booleanQuery.should)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.mustNot, (Object)booleanQuery.mustNot)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.boost, (Object)booleanQuery.boost);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0080\b\u0018\u00002\u00020\u0001B'\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003H\u00c6\u0003J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ2\u0010\u0014\u001a\u00020\u00002\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u001c\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0010\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\rX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$CustomQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery;", "params", "", "", "", "boost", "", "(Ljava/util/Map;Ljava/lang/Double;)V", "getBoost", "()Ljava/lang/Double;", "Ljava/lang/Double;", "core", "Lcom/couchbase/client/core/api/search/queries/CoreCustomQuery;", "getCore$kotlin_client", "()Lcom/couchbase/client/core/api/search/queries/CoreCustomQuery;", "getParams", "()Ljava/util/Map;", "component1", "component2", "copy", "(Ljava/util/Map;Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$CustomQuery;", "equals", "", "other", "hashCode", "", "toString", "withBoost", "withBoost$kotlin_client", "(Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$CustomQuery;", "kotlin-client"})
        public static final class CustomQuery
        extends SearchQuery {
            @NotNull
            private final Map<String, Object> params;
            @Nullable
            private final Double boost;
            @NotNull
            private final CoreCustomQuery core;

            public CustomQuery(@NotNull Map<String, ? extends Object> params, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter(params, (String)"params");
                super(null);
                this.params = params;
                this.boost = boost;
                this.core = new CoreCustomQuery(this.params, this.boost);
            }

            public /* synthetic */ CustomQuery(Map map2, Double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    d = null;
                }
                this(map2, d);
            }

            @NotNull
            public final Map<String, Object> getParams() {
                return this.params;
            }

            @Nullable
            public final Double getBoost() {
                return this.boost;
            }

            @NotNull
            public CoreCustomQuery getCore$kotlin_client() {
                return this.core;
            }

            @Override
            @NotNull
            public CustomQuery withBoost$kotlin_client(@Nullable Double boost) {
                return CustomQuery.copy$default(this, null, boost, 1, null);
            }

            @NotNull
            public final Map<String, Object> component1() {
                return this.params;
            }

            @Nullable
            public final Double component2() {
                return this.boost;
            }

            @NotNull
            public final CustomQuery copy(@NotNull Map<String, ? extends Object> params, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter(params, (String)"params");
                return new CustomQuery(params, boost);
            }

            public static /* synthetic */ CustomQuery copy$default(CustomQuery customQuery, Map map2, Double d, int n, Object object) {
                if ((n & 1) != 0) {
                    map2 = customQuery.params;
                }
                if ((n & 2) != 0) {
                    d = customQuery.boost;
                }
                return customQuery.copy(map2, d);
            }

            @Override
            @NotNull
            public String toString() {
                return "CustomQuery(params=" + this.params + ", boost=" + this.boost + ')';
            }

            public int hashCode() {
                int result2 = ((Object)this.params).hashCode();
                result2 = result2 * 31 + (this.boost == null ? 0 : ((Object)this.boost).hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CustomQuery)) {
                    return false;
                }
                CustomQuery customQuery = (CustomQuery)other;
                if (!Intrinsics.areEqual(this.params, customQuery.params)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.boost, (Object)customQuery.boost);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0080\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\u0010\u0010!\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJP\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\t\u001a\u00020\u00072\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001\u00a2\u0006\u0002\u0010#J\u0013\u0010$\u001a\u00020\u00072\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010*\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0010\u00a2\u0006\u0004\b+\u0010,R\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u0011X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015\u00a8\u0006-"}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$DateRangeQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery;", "field", "", "start", "Ljava/time/Instant;", "inclusiveStart", "", "end", "inclusiveEnd", "boost", "", "(Ljava/lang/String;Ljava/time/Instant;ZLjava/time/Instant;ZLjava/lang/Double;)V", "getBoost", "()Ljava/lang/Double;", "Ljava/lang/Double;", "core", "Lcom/couchbase/client/core/api/search/queries/CoreDateRangeQuery;", "getCore$kotlin_client", "()Lcom/couchbase/client/core/api/search/queries/CoreDateRangeQuery;", "getEnd", "()Ljava/time/Instant;", "getField", "()Ljava/lang/String;", "getInclusiveEnd", "()Z", "getInclusiveStart", "getStart", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Ljava/lang/String;Ljava/time/Instant;ZLjava/time/Instant;ZLjava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$DateRangeQuery;", "equals", "other", "", "hashCode", "", "toString", "withBoost", "withBoost$kotlin_client", "(Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$DateRangeQuery;", "kotlin-client"})
        public static final class DateRangeQuery
        extends SearchQuery {
            @NotNull
            private final String field;
            @Nullable
            private final Instant start;
            private final boolean inclusiveStart;
            @Nullable
            private final Instant end;
            private final boolean inclusiveEnd;
            @Nullable
            private final Double boost;
            @NotNull
            private final CoreDateRangeQuery core;

            public DateRangeQuery(@NotNull String field, @Nullable Instant start, boolean inclusiveStart, @Nullable Instant end, boolean inclusiveEnd, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                super(null);
                this.field = field;
                this.start = start;
                this.inclusiveStart = inclusiveStart;
                this.end = end;
                this.inclusiveEnd = inclusiveEnd;
                this.boost = boost;
                Instant instant = this.start;
                Instant instant2 = this.end;
                this.core = new CoreDateRangeQuery(instant != null ? instant.toString() : null, instant2 != null ? instant2.toString() : null, Boolean.valueOf(this.inclusiveStart), Boolean.valueOf(this.inclusiveEnd), null, this.field, this.boost);
            }

            public /* synthetic */ DateRangeQuery(String string, Instant instant, boolean bl, Instant instant2, boolean bl2, Double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 0x20) != 0) {
                    d = null;
                }
                this(string, instant, bl, instant2, bl2, d);
            }

            @NotNull
            public final String getField() {
                return this.field;
            }

            @Nullable
            public final Instant getStart() {
                return this.start;
            }

            public final boolean getInclusiveStart() {
                return this.inclusiveStart;
            }

            @Nullable
            public final Instant getEnd() {
                return this.end;
            }

            public final boolean getInclusiveEnd() {
                return this.inclusiveEnd;
            }

            @Nullable
            public final Double getBoost() {
                return this.boost;
            }

            @NotNull
            public CoreDateRangeQuery getCore$kotlin_client() {
                return this.core;
            }

            @Override
            @NotNull
            public DateRangeQuery withBoost$kotlin_client(@Nullable Double boost) {
                return DateRangeQuery.copy$default(this, null, null, false, null, false, boost, 31, null);
            }

            @NotNull
            public final String component1() {
                return this.field;
            }

            @Nullable
            public final Instant component2() {
                return this.start;
            }

            public final boolean component3() {
                return this.inclusiveStart;
            }

            @Nullable
            public final Instant component4() {
                return this.end;
            }

            public final boolean component5() {
                return this.inclusiveEnd;
            }

            @Nullable
            public final Double component6() {
                return this.boost;
            }

            @NotNull
            public final DateRangeQuery copy(@NotNull String field, @Nullable Instant start, boolean inclusiveStart, @Nullable Instant end, boolean inclusiveEnd, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                return new DateRangeQuery(field, start, inclusiveStart, end, inclusiveEnd, boost);
            }

            public static /* synthetic */ DateRangeQuery copy$default(DateRangeQuery dateRangeQuery, String string, Instant instant, boolean bl, Instant instant2, boolean bl2, Double d, int n, Object object) {
                if ((n & 1) != 0) {
                    string = dateRangeQuery.field;
                }
                if ((n & 2) != 0) {
                    instant = dateRangeQuery.start;
                }
                if ((n & 4) != 0) {
                    bl = dateRangeQuery.inclusiveStart;
                }
                if ((n & 8) != 0) {
                    instant2 = dateRangeQuery.end;
                }
                if ((n & 0x10) != 0) {
                    bl2 = dateRangeQuery.inclusiveEnd;
                }
                if ((n & 0x20) != 0) {
                    d = dateRangeQuery.boost;
                }
                return dateRangeQuery.copy(string, instant, bl, instant2, bl2, d);
            }

            @Override
            @NotNull
            public String toString() {
                return "DateRangeQuery(field=" + this.field + ", start=" + this.start + ", inclusiveStart=" + this.inclusiveStart + ", end=" + this.end + ", inclusiveEnd=" + this.inclusiveEnd + ", boost=" + this.boost + ')';
            }

            public int hashCode() {
                int result2 = this.field.hashCode();
                result2 = result2 * 31 + (this.start == null ? 0 : this.start.hashCode());
                result2 = result2 * 31 + Boolean.hashCode(this.inclusiveStart);
                result2 = result2 * 31 + (this.end == null ? 0 : this.end.hashCode());
                result2 = result2 * 31 + Boolean.hashCode(this.inclusiveEnd);
                result2 = result2 * 31 + (this.boost == null ? 0 : ((Object)this.boost).hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DateRangeQuery)) {
                    return false;
                }
                DateRangeQuery dateRangeQuery = (DateRangeQuery)other;
                if (!Intrinsics.areEqual((Object)this.field, (Object)dateRangeQuery.field)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.start, (Object)dateRangeQuery.start)) {
                    return false;
                }
                if (this.inclusiveStart != dateRangeQuery.inclusiveStart) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.end, (Object)dateRangeQuery.end)) {
                    return false;
                }
                if (this.inclusiveEnd != dateRangeQuery.inclusiveEnd) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.boost, (Object)dateRangeQuery.boost);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0080\b\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ*\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010\u001c\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0010\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\fX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$DocumentIdQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery;", "ids", "", "", "boost", "", "(Ljava/util/List;Ljava/lang/Double;)V", "getBoost", "()Ljava/lang/Double;", "Ljava/lang/Double;", "core", "Lcom/couchbase/client/core/api/search/queries/CoreDocIdQuery;", "getCore$kotlin_client", "()Lcom/couchbase/client/core/api/search/queries/CoreDocIdQuery;", "getIds", "()Ljava/util/List;", "component1", "component2", "copy", "(Ljava/util/List;Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$DocumentIdQuery;", "equals", "", "other", "", "hashCode", "", "toString", "withBoost", "withBoost$kotlin_client", "(Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$DocumentIdQuery;", "kotlin-client"})
        public static final class DocumentIdQuery
        extends SearchQuery {
            @NotNull
            private final List<String> ids;
            @Nullable
            private final Double boost;
            @NotNull
            private final CoreDocIdQuery core;

            public DocumentIdQuery(@NotNull List<String> ids, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter(ids, (String)"ids");
                super(null);
                this.ids = ids;
                this.boost = boost;
                this.core = new CoreDocIdQuery(this.boost, this.ids);
            }

            public /* synthetic */ DocumentIdQuery(List list, Double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    d = null;
                }
                this(list, d);
            }

            @NotNull
            public final List<String> getIds() {
                return this.ids;
            }

            @Nullable
            public final Double getBoost() {
                return this.boost;
            }

            @NotNull
            public CoreDocIdQuery getCore$kotlin_client() {
                return this.core;
            }

            @Override
            @NotNull
            public DocumentIdQuery withBoost$kotlin_client(@Nullable Double boost) {
                return DocumentIdQuery.copy$default(this, null, boost, 1, null);
            }

            @NotNull
            public final List<String> component1() {
                return this.ids;
            }

            @Nullable
            public final Double component2() {
                return this.boost;
            }

            @NotNull
            public final DocumentIdQuery copy(@NotNull List<String> ids, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter(ids, (String)"ids");
                return new DocumentIdQuery(ids, boost);
            }

            public static /* synthetic */ DocumentIdQuery copy$default(DocumentIdQuery documentIdQuery, List list, Double d, int n, Object object) {
                if ((n & 1) != 0) {
                    list = documentIdQuery.ids;
                }
                if ((n & 2) != 0) {
                    d = documentIdQuery.boost;
                }
                return documentIdQuery.copy(list, d);
            }

            @Override
            @NotNull
            public String toString() {
                return "DocumentIdQuery(ids=" + this.ids + ", boost=" + this.boost + ')';
            }

            public int hashCode() {
                int result2 = ((Object)this.ids).hashCode();
                result2 = result2 * 31 + (this.boost == null ? 0 : ((Object)this.boost).hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DocumentIdQuery)) {
                    return false;
                }
                DocumentIdQuery documentIdQuery = (DocumentIdQuery)other;
                if (!Intrinsics.areEqual(this.ids, documentIdQuery.ids)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.boost, (Object)documentIdQuery.boost);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0080\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ.\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001J\u0019\u0010 \u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0010\u00a2\u0006\u0004\b!\u0010\"R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\rX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$GeoShapeQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery;", "shape", "Lcom/couchbase/client/kotlin/search/GeoShape;", "field", "", "boost", "", "(Lcom/couchbase/client/kotlin/search/GeoShape;Ljava/lang/String;Ljava/lang/Double;)V", "getBoost", "()Ljava/lang/Double;", "Ljava/lang/Double;", "core", "Lcom/couchbase/client/core/api/search/CoreSearchQuery;", "getCore$kotlin_client", "()Lcom/couchbase/client/core/api/search/CoreSearchQuery;", "getField", "()Ljava/lang/String;", "getShape", "()Lcom/couchbase/client/kotlin/search/GeoShape;", "component1", "component2", "component3", "copy", "(Lcom/couchbase/client/kotlin/search/GeoShape;Ljava/lang/String;Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$GeoShapeQuery;", "equals", "", "other", "", "hashCode", "", "toString", "withBoost", "withBoost$kotlin_client", "(Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$GeoShapeQuery;", "kotlin-client"})
        @SourceDebugExtension(value={"SMAP\nSearchQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchQuery.kt\ncom/couchbase/client/kotlin/search/SearchQuery$Companion$GeoShapeQuery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,642:1\n1549#2:643\n1620#2,3:644\n*S KotlinDebug\n*F\n+ 1 SearchQuery.kt\ncom/couchbase/client/kotlin/search/SearchQuery$Companion$GeoShapeQuery\n*L\n480#1:643\n480#1:644,3\n*E\n"})
        public static final class GeoShapeQuery
        extends SearchQuery {
            @NotNull
            private final GeoShape shape;
            @NotNull
            private final String field;
            @Nullable
            private final Double boost;
            @NotNull
            private final CoreSearchQuery core;

            /*
             * WARNING - void declaration
             */
            public GeoShapeQuery(@NotNull GeoShape shape, @NotNull String field, @Nullable Double boost) {
                CoreSearchQuery coreSearchQuery;
                Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                super(null);
                this.shape = shape;
                this.field = field;
                this.boost = boost;
                GeoShapeQuery geoShapeQuery = this;
                GeoShape geoShape = this.shape;
                if (geoShape instanceof GeoCircle) {
                    coreSearchQuery = (CoreSearchQuery)new CoreGeoDistanceQuery(((GeoCircle)this.shape).getCenter().getCore$kotlin_client(), ((GeoCircle)this.shape).getRadius().serialize$kotlin_client(), this.field, this.boost);
                } else if (geoShape instanceof GeoPolygon) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = ((GeoPolygon)this.shape).getVertices();
                    GeoShapeQuery geoShapeQuery2 = geoShapeQuery;
                    boolean $i$f$map = false;
                    void var7_8 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        GeoPoint geoPoint = (GeoPoint)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl = false;
                        collection2.add(it.getCore$kotlin_client());
                    }
                    geoShapeQuery = geoShapeQuery2;
                    Double d = this.boost;
                    String string = this.field;
                    List list = (List)destination$iv$iv;
                    coreSearchQuery = (CoreSearchQuery)new CoreGeoPolygonQuery(list, string, d);
                } else if (geoShape instanceof GeoRectangle) {
                    coreSearchQuery = (CoreSearchQuery)new CoreGeoBoundingBoxQuery(((GeoRectangle)this.shape).getTopLeft().getCore$kotlin_client(), ((GeoRectangle)this.shape).getBottomRight().getCore$kotlin_client(), this.field, this.boost);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                geoShapeQuery.core = coreSearchQuery;
            }

            public /* synthetic */ GeoShapeQuery(GeoShape geoShape, String string, Double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    d = null;
                }
                this(geoShape, string, d);
            }

            @NotNull
            public final GeoShape getShape() {
                return this.shape;
            }

            @NotNull
            public final String getField() {
                return this.field;
            }

            @Nullable
            public final Double getBoost() {
                return this.boost;
            }

            @Override
            @NotNull
            public CoreSearchQuery getCore$kotlin_client() {
                return this.core;
            }

            @Override
            @NotNull
            public GeoShapeQuery withBoost$kotlin_client(@Nullable Double boost) {
                return GeoShapeQuery.copy$default(this, null, null, boost, 3, null);
            }

            @NotNull
            public final GeoShape component1() {
                return this.shape;
            }

            @NotNull
            public final String component2() {
                return this.field;
            }

            @Nullable
            public final Double component3() {
                return this.boost;
            }

            @NotNull
            public final GeoShapeQuery copy(@NotNull GeoShape shape, @NotNull String field, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                return new GeoShapeQuery(shape, field, boost);
            }

            public static /* synthetic */ GeoShapeQuery copy$default(GeoShapeQuery geoShapeQuery, GeoShape geoShape, String string, Double d, int n, Object object) {
                if ((n & 1) != 0) {
                    geoShape = geoShapeQuery.shape;
                }
                if ((n & 2) != 0) {
                    string = geoShapeQuery.field;
                }
                if ((n & 4) != 0) {
                    d = geoShapeQuery.boost;
                }
                return geoShapeQuery.copy(geoShape, string, d);
            }

            @Override
            @NotNull
            public String toString() {
                return "GeoShapeQuery(shape=" + this.shape + ", field=" + this.field + ", boost=" + this.boost + ')';
            }

            public int hashCode() {
                int result2 = this.shape.hashCode();
                result2 = result2 * 31 + this.field.hashCode();
                result2 = result2 * 31 + (this.boost == null ? 0 : ((Object)this.boost).hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof GeoShapeQuery)) {
                    return false;
                }
                GeoShapeQuery geoShapeQuery = (GeoShapeQuery)other;
                if (!Intrinsics.areEqual((Object)this.shape, (Object)geoShapeQuery.shape)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.field, (Object)geoShapeQuery.field)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.boost, (Object)geoShapeQuery.boost);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0019\u0010\u0017\u001a\u00020\u00002\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0010\u00a2\u0006\u0004\b\u0018\u0010\u000eR\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\tX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchAllQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery;", "boost", "", "(Ljava/lang/Double;)V", "getBoost", "()Ljava/lang/Double;", "Ljava/lang/Double;", "core", "Lcom/couchbase/client/core/api/search/queries/CoreMatchAllQuery;", "getCore$kotlin_client", "()Lcom/couchbase/client/core/api/search/queries/CoreMatchAllQuery;", "component1", "copy", "(Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchAllQuery;", "equals", "", "other", "", "hashCode", "", "toString", "", "withBoost", "withBoost$kotlin_client", "kotlin-client"})
        public static final class MatchAllQuery
        extends SearchQuery {
            @Nullable
            private final Double boost;
            @NotNull
            private final CoreMatchAllQuery core;

            public MatchAllQuery(@Nullable Double boost) {
                super(null);
                this.boost = boost;
                this.core = new CoreMatchAllQuery(this.boost);
            }

            public /* synthetic */ MatchAllQuery(Double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    d = null;
                }
                this(d);
            }

            @Nullable
            public final Double getBoost() {
                return this.boost;
            }

            @NotNull
            public CoreMatchAllQuery getCore$kotlin_client() {
                return this.core;
            }

            @Override
            @NotNull
            public MatchAllQuery withBoost$kotlin_client(@Nullable Double boost) {
                return this.copy(boost);
            }

            @Nullable
            public final Double component1() {
                return this.boost;
            }

            @NotNull
            public final MatchAllQuery copy(@Nullable Double boost) {
                return new MatchAllQuery(boost);
            }

            public static /* synthetic */ MatchAllQuery copy$default(MatchAllQuery matchAllQuery, Double d, int n, Object object) {
                if ((n & 1) != 0) {
                    d = matchAllQuery.boost;
                }
                return matchAllQuery.copy(d);
            }

            @Override
            @NotNull
            public String toString() {
                return "MatchAllQuery(boost=" + this.boost + ')';
            }

            public int hashCode() {
                return this.boost == null ? 0 : ((Object)this.boost).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MatchAllQuery)) {
                    return false;
                }
                MatchAllQuery matchAllQuery = (MatchAllQuery)other;
                return Intrinsics.areEqual((Object)this.boost, (Object)matchAllQuery.boost);
            }

            public MatchAllQuery() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0019\u0010\u0017\u001a\u00020\u00002\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0010\u00a2\u0006\u0004\b\u0018\u0010\u000eR\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\tX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchNoneQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery;", "boost", "", "(Ljava/lang/Double;)V", "getBoost", "()Ljava/lang/Double;", "Ljava/lang/Double;", "core", "Lcom/couchbase/client/core/api/search/queries/CoreMatchNoneQuery;", "getCore$kotlin_client", "()Lcom/couchbase/client/core/api/search/queries/CoreMatchNoneQuery;", "component1", "copy", "(Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchNoneQuery;", "equals", "", "other", "", "hashCode", "", "toString", "", "withBoost", "withBoost$kotlin_client", "kotlin-client"})
        public static final class MatchNoneQuery
        extends SearchQuery {
            @Nullable
            private final Double boost;
            @NotNull
            private final CoreMatchNoneQuery core;

            public MatchNoneQuery(@Nullable Double boost) {
                super(null);
                this.boost = boost;
                this.core = new CoreMatchNoneQuery(this.boost);
            }

            public /* synthetic */ MatchNoneQuery(Double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    d = null;
                }
                this(d);
            }

            @Nullable
            public final Double getBoost() {
                return this.boost;
            }

            @NotNull
            public CoreMatchNoneQuery getCore$kotlin_client() {
                return this.core;
            }

            @Override
            @NotNull
            public MatchNoneQuery withBoost$kotlin_client(@Nullable Double boost) {
                return this.copy(boost);
            }

            @Nullable
            public final Double component1() {
                return this.boost;
            }

            @NotNull
            public final MatchNoneQuery copy(@Nullable Double boost) {
                return new MatchNoneQuery(boost);
            }

            public static /* synthetic */ MatchNoneQuery copy$default(MatchNoneQuery matchNoneQuery, Double d, int n, Object object) {
                if ((n & 1) != 0) {
                    d = matchNoneQuery.boost;
                }
                return matchNoneQuery.copy(d);
            }

            @Override
            @NotNull
            public String toString() {
                return "MatchNoneQuery(boost=" + this.boost + ')';
            }

            public int hashCode() {
                return this.boost == null ? 0 : ((Object)this.boost).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MatchNoneQuery)) {
                    return false;
                }
                MatchNoneQuery matchNoneQuery = (MatchNoneQuery)other;
                return Intrinsics.areEqual((Object)this.boost, (Object)matchNoneQuery.boost);
            }

            public MatchNoneQuery() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchOperator;", "", "core", "Lcom/couchbase/client/core/api/search/queries/CoreMatchOperator;", "(Ljava/lang/String;ILcom/couchbase/client/core/api/search/queries/CoreMatchOperator;)V", "getCore$kotlin_client", "()Lcom/couchbase/client/core/api/search/queries/CoreMatchOperator;", "AND", "OR", "kotlin-client"})
        public static final class MatchOperator
        extends Enum<MatchOperator> {
            @NotNull
            private final CoreMatchOperator core;
            public static final /* enum */ MatchOperator AND = new MatchOperator(CoreMatchOperator.AND);
            public static final /* enum */ MatchOperator OR = new MatchOperator(CoreMatchOperator.OR);
            private static final /* synthetic */ MatchOperator[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private MatchOperator(CoreMatchOperator core) {
                this.core = core;
            }

            @NotNull
            public final CoreMatchOperator getCore$kotlin_client() {
                return this.core;
            }

            public static MatchOperator[] values() {
                return (MatchOperator[])$VALUES.clone();
            }

            public static MatchOperator valueOf(String value2) {
                return Enum.valueOf(MatchOperator.class, value2);
            }

            @NotNull
            public static EnumEntries<MatchOperator> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = matchOperatorArray = new MatchOperator[]{MatchOperator.AND, MatchOperator.OR};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0080\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ:\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010!\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0010\u00a2\u0006\u0004\b\"\u0010#R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000fX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\n\u00a8\u0006$"}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchPhraseQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery;", "matchPhrase", "", "field", "analyzer", "boost", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Double;)V", "getAnalyzer", "()Ljava/lang/String;", "getBoost", "()Ljava/lang/Double;", "Ljava/lang/Double;", "core", "Lcom/couchbase/client/core/api/search/queries/CoreMatchPhraseQuery;", "getCore$kotlin_client", "()Lcom/couchbase/client/core/api/search/queries/CoreMatchPhraseQuery;", "getField", "getMatchPhrase", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchPhraseQuery;", "equals", "", "other", "", "hashCode", "", "toString", "withBoost", "withBoost$kotlin_client", "(Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchPhraseQuery;", "kotlin-client"})
        public static final class MatchPhraseQuery
        extends SearchQuery {
            @NotNull
            private final String matchPhrase;
            @NotNull
            private final String field;
            @Nullable
            private final String analyzer;
            @Nullable
            private final Double boost;
            @NotNull
            private final CoreMatchPhraseQuery core;

            public MatchPhraseQuery(@NotNull String matchPhrase, @NotNull String field, @Nullable String analyzer, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)matchPhrase, (String)"matchPhrase");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                super(null);
                this.matchPhrase = matchPhrase;
                this.field = field;
                this.analyzer = analyzer;
                this.boost = boost;
                this.core = new CoreMatchPhraseQuery(this.matchPhrase, this.field, this.analyzer, this.boost);
            }

            public /* synthetic */ MatchPhraseQuery(String string, String string2, String string3, Double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    string2 = "_all";
                }
                if ((n & 4) != 0) {
                    string3 = null;
                }
                if ((n & 8) != 0) {
                    d = null;
                }
                this(string, string2, string3, d);
            }

            @NotNull
            public final String getMatchPhrase() {
                return this.matchPhrase;
            }

            @NotNull
            public final String getField() {
                return this.field;
            }

            @Nullable
            public final String getAnalyzer() {
                return this.analyzer;
            }

            @Nullable
            public final Double getBoost() {
                return this.boost;
            }

            @NotNull
            public CoreMatchPhraseQuery getCore$kotlin_client() {
                return this.core;
            }

            @Override
            @NotNull
            public MatchPhraseQuery withBoost$kotlin_client(@Nullable Double boost) {
                return MatchPhraseQuery.copy$default(this, null, null, null, boost, 7, null);
            }

            @NotNull
            public final String component1() {
                return this.matchPhrase;
            }

            @NotNull
            public final String component2() {
                return this.field;
            }

            @Nullable
            public final String component3() {
                return this.analyzer;
            }

            @Nullable
            public final Double component4() {
                return this.boost;
            }

            @NotNull
            public final MatchPhraseQuery copy(@NotNull String matchPhrase, @NotNull String field, @Nullable String analyzer, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)matchPhrase, (String)"matchPhrase");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                return new MatchPhraseQuery(matchPhrase, field, analyzer, boost);
            }

            public static /* synthetic */ MatchPhraseQuery copy$default(MatchPhraseQuery matchPhraseQuery, String string, String string2, String string3, Double d, int n, Object object) {
                if ((n & 1) != 0) {
                    string = matchPhraseQuery.matchPhrase;
                }
                if ((n & 2) != 0) {
                    string2 = matchPhraseQuery.field;
                }
                if ((n & 4) != 0) {
                    string3 = matchPhraseQuery.analyzer;
                }
                if ((n & 8) != 0) {
                    d = matchPhraseQuery.boost;
                }
                return matchPhraseQuery.copy(string, string2, string3, d);
            }

            @Override
            @NotNull
            public String toString() {
                return "MatchPhraseQuery(matchPhrase=" + this.matchPhrase + ", field=" + this.field + ", analyzer=" + this.analyzer + ", boost=" + this.boost + ')';
            }

            public int hashCode() {
                int result2 = this.matchPhrase.hashCode();
                result2 = result2 * 31 + this.field.hashCode();
                result2 = result2 * 31 + (this.analyzer == null ? 0 : this.analyzer.hashCode());
                result2 = result2 * 31 + (this.boost == null ? 0 : ((Object)this.boost).hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MatchPhraseQuery)) {
                    return false;
                }
                MatchPhraseQuery matchPhraseQuery = (MatchPhraseQuery)other;
                if (!Intrinsics.areEqual((Object)this.matchPhrase, (Object)matchPhraseQuery.matchPhrase)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.field, (Object)matchPhraseQuery.field)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.analyzer, (Object)matchPhraseQuery.analyzer)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.boost, (Object)matchPhraseQuery.boost);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0080\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J\t\u0010#\u001a\u00020\tH\u00c6\u0003J\u0010\u0010$\u001a\u0004\u0018\u00010\fH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0011JX\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00c6\u0001\u00a2\u0006\u0002\u0010&J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020\tH\u00d6\u0001J\t\u0010,\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010-\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0010\u00a2\u0006\u0004\b.\u0010/R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u0014X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019\u00a8\u00060"}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery;", "match", "", "field", "analyzer", "operator", "Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchOperator;", "fuzziness", "", "prefixLength", "boost", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchOperator;IILjava/lang/Double;)V", "getAnalyzer", "()Ljava/lang/String;", "getBoost", "()Ljava/lang/Double;", "Ljava/lang/Double;", "core", "Lcom/couchbase/client/core/api/search/queries/CoreMatchQuery;", "getCore$kotlin_client", "()Lcom/couchbase/client/core/api/search/queries/CoreMatchQuery;", "getField", "getFuzziness", "()I", "getMatch", "getOperator", "()Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchOperator;", "getPrefixLength", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchOperator;IILjava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchQuery;", "equals", "", "other", "", "hashCode", "toString", "withBoost", "withBoost$kotlin_client", "(Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchQuery;", "kotlin-client"})
        public static final class MatchQuery
        extends SearchQuery {
            @NotNull
            private final String match;
            @NotNull
            private final String field;
            @Nullable
            private final String analyzer;
            @NotNull
            private final MatchOperator operator;
            private final int fuzziness;
            private final int prefixLength;
            @Nullable
            private final Double boost;
            @NotNull
            private final CoreMatchQuery core;

            public MatchQuery(@NotNull String match, @NotNull String field, @Nullable String analyzer, @NotNull MatchOperator operator, int fuzziness, int prefixLength, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)match, (String)"match");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
                super(null);
                this.match = match;
                this.field = field;
                this.analyzer = analyzer;
                this.operator = operator;
                this.fuzziness = fuzziness;
                this.prefixLength = prefixLength;
                this.boost = boost;
                this.core = new CoreMatchQuery(this.match, this.field, this.analyzer, Integer.valueOf(this.prefixLength), Integer.valueOf(this.fuzziness), this.operator.getCore$kotlin_client(), this.boost);
            }

            public /* synthetic */ MatchQuery(String string, String string2, String string3, MatchOperator matchOperator, int n, int n2, Double d, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 0x40) != 0) {
                    d = null;
                }
                this(string, string2, string3, matchOperator, n, n2, d);
            }

            @NotNull
            public final String getMatch() {
                return this.match;
            }

            @NotNull
            public final String getField() {
                return this.field;
            }

            @Nullable
            public final String getAnalyzer() {
                return this.analyzer;
            }

            @NotNull
            public final MatchOperator getOperator() {
                return this.operator;
            }

            public final int getFuzziness() {
                return this.fuzziness;
            }

            public final int getPrefixLength() {
                return this.prefixLength;
            }

            @Nullable
            public final Double getBoost() {
                return this.boost;
            }

            @NotNull
            public CoreMatchQuery getCore$kotlin_client() {
                return this.core;
            }

            @Override
            @NotNull
            public MatchQuery withBoost$kotlin_client(@Nullable Double boost) {
                return MatchQuery.copy$default(this, null, null, null, null, 0, 0, boost, 63, null);
            }

            @NotNull
            public final String component1() {
                return this.match;
            }

            @NotNull
            public final String component2() {
                return this.field;
            }

            @Nullable
            public final String component3() {
                return this.analyzer;
            }

            @NotNull
            public final MatchOperator component4() {
                return this.operator;
            }

            public final int component5() {
                return this.fuzziness;
            }

            public final int component6() {
                return this.prefixLength;
            }

            @Nullable
            public final Double component7() {
                return this.boost;
            }

            @NotNull
            public final MatchQuery copy(@NotNull String match, @NotNull String field, @Nullable String analyzer, @NotNull MatchOperator operator, int fuzziness, int prefixLength, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)match, (String)"match");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
                return new MatchQuery(match, field, analyzer, operator, fuzziness, prefixLength, boost);
            }

            public static /* synthetic */ MatchQuery copy$default(MatchQuery matchQuery, String string, String string2, String string3, MatchOperator matchOperator, int n, int n2, Double d, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    string = matchQuery.match;
                }
                if ((n3 & 2) != 0) {
                    string2 = matchQuery.field;
                }
                if ((n3 & 4) != 0) {
                    string3 = matchQuery.analyzer;
                }
                if ((n3 & 8) != 0) {
                    matchOperator = matchQuery.operator;
                }
                if ((n3 & 0x10) != 0) {
                    n = matchQuery.fuzziness;
                }
                if ((n3 & 0x20) != 0) {
                    n2 = matchQuery.prefixLength;
                }
                if ((n3 & 0x40) != 0) {
                    d = matchQuery.boost;
                }
                return matchQuery.copy(string, string2, string3, matchOperator, n, n2, d);
            }

            @Override
            @NotNull
            public String toString() {
                return "MatchQuery(match=" + this.match + ", field=" + this.field + ", analyzer=" + this.analyzer + ", operator=" + (Object)((Object)this.operator) + ", fuzziness=" + this.fuzziness + ", prefixLength=" + this.prefixLength + ", boost=" + this.boost + ')';
            }

            public int hashCode() {
                int result2 = this.match.hashCode();
                result2 = result2 * 31 + this.field.hashCode();
                result2 = result2 * 31 + (this.analyzer == null ? 0 : this.analyzer.hashCode());
                result2 = result2 * 31 + this.operator.hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.fuzziness);
                result2 = result2 * 31 + Integer.hashCode(this.prefixLength);
                result2 = result2 * 31 + (this.boost == null ? 0 : ((Object)this.boost).hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MatchQuery)) {
                    return false;
                }
                MatchQuery matchQuery = (MatchQuery)other;
                if (!Intrinsics.areEqual((Object)this.match, (Object)matchQuery.match)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.field, (Object)matchQuery.field)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.analyzer, (Object)matchQuery.analyzer)) {
                    return false;
                }
                if (this.operator != matchQuery.operator) {
                    return false;
                }
                if (this.fuzziness != matchQuery.fuzziness) {
                    return false;
                }
                if (this.prefixLength != matchQuery.prefixLength) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.boost, (Object)matchQuery.boost);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0080\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\u0010\u0010!\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJP\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\t\u001a\u00020\u00072\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001\u00a2\u0006\u0002\u0010#J\u0013\u0010$\u001a\u00020\u00072\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010*\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0010\u00a2\u0006\u0004\b+\u0010,R\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u0011X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001a\u00a8\u0006-"}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$NumericRangeQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery;", "field", "", "min", "", "inclusiveMin", "", "max", "inclusiveMax", "boost", "", "(Ljava/lang/String;Ljava/lang/Number;ZLjava/lang/Number;ZLjava/lang/Double;)V", "getBoost", "()Ljava/lang/Double;", "Ljava/lang/Double;", "core", "Lcom/couchbase/client/core/api/search/queries/CoreNumericRangeQuery;", "getCore$kotlin_client", "()Lcom/couchbase/client/core/api/search/queries/CoreNumericRangeQuery;", "getField", "()Ljava/lang/String;", "getInclusiveMax", "()Z", "getInclusiveMin", "getMax", "()Ljava/lang/Number;", "getMin", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Ljava/lang/String;Ljava/lang/Number;ZLjava/lang/Number;ZLjava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$NumericRangeQuery;", "equals", "other", "", "hashCode", "", "toString", "withBoost", "withBoost$kotlin_client", "(Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$NumericRangeQuery;", "kotlin-client"})
        public static final class NumericRangeQuery
        extends SearchQuery {
            @NotNull
            private final String field;
            @Nullable
            private final Number min;
            private final boolean inclusiveMin;
            @Nullable
            private final Number max;
            private final boolean inclusiveMax;
            @Nullable
            private final Double boost;
            @NotNull
            private final CoreNumericRangeQuery core;

            public NumericRangeQuery(@NotNull String field, @Nullable Number min, boolean inclusiveMin, @Nullable Number max, boolean inclusiveMax, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                super(null);
                this.field = field;
                this.min = min;
                this.inclusiveMin = inclusiveMin;
                this.max = max;
                this.inclusiveMax = inclusiveMax;
                this.boost = boost;
                Number number = this.min;
                Number number2 = this.max;
                this.core = new CoreNumericRangeQuery(number != null ? Double.valueOf(number.doubleValue()) : null, number2 != null ? Double.valueOf(number2.doubleValue()) : null, Boolean.valueOf(this.inclusiveMin), Boolean.valueOf(this.inclusiveMax), this.field, this.boost);
            }

            public /* synthetic */ NumericRangeQuery(String string, Number number, boolean bl, Number number2, boolean bl2, Double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 0x20) != 0) {
                    d = null;
                }
                this(string, number, bl, number2, bl2, d);
            }

            @NotNull
            public final String getField() {
                return this.field;
            }

            @Nullable
            public final Number getMin() {
                return this.min;
            }

            public final boolean getInclusiveMin() {
                return this.inclusiveMin;
            }

            @Nullable
            public final Number getMax() {
                return this.max;
            }

            public final boolean getInclusiveMax() {
                return this.inclusiveMax;
            }

            @Nullable
            public final Double getBoost() {
                return this.boost;
            }

            @NotNull
            public CoreNumericRangeQuery getCore$kotlin_client() {
                return this.core;
            }

            @Override
            @NotNull
            public NumericRangeQuery withBoost$kotlin_client(@Nullable Double boost) {
                return NumericRangeQuery.copy$default(this, null, null, false, null, false, boost, 31, null);
            }

            @NotNull
            public final String component1() {
                return this.field;
            }

            @Nullable
            public final Number component2() {
                return this.min;
            }

            public final boolean component3() {
                return this.inclusiveMin;
            }

            @Nullable
            public final Number component4() {
                return this.max;
            }

            public final boolean component5() {
                return this.inclusiveMax;
            }

            @Nullable
            public final Double component6() {
                return this.boost;
            }

            @NotNull
            public final NumericRangeQuery copy(@NotNull String field, @Nullable Number min, boolean inclusiveMin, @Nullable Number max, boolean inclusiveMax, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                return new NumericRangeQuery(field, min, inclusiveMin, max, inclusiveMax, boost);
            }

            public static /* synthetic */ NumericRangeQuery copy$default(NumericRangeQuery numericRangeQuery, String string, Number number, boolean bl, Number number2, boolean bl2, Double d, int n, Object object) {
                if ((n & 1) != 0) {
                    string = numericRangeQuery.field;
                }
                if ((n & 2) != 0) {
                    number = numericRangeQuery.min;
                }
                if ((n & 4) != 0) {
                    bl = numericRangeQuery.inclusiveMin;
                }
                if ((n & 8) != 0) {
                    number2 = numericRangeQuery.max;
                }
                if ((n & 0x10) != 0) {
                    bl2 = numericRangeQuery.inclusiveMax;
                }
                if ((n & 0x20) != 0) {
                    d = numericRangeQuery.boost;
                }
                return numericRangeQuery.copy(string, number, bl, number2, bl2, d);
            }

            @Override
            @NotNull
            public String toString() {
                return "NumericRangeQuery(field=" + this.field + ", min=" + this.min + ", inclusiveMin=" + this.inclusiveMin + ", max=" + this.max + ", inclusiveMax=" + this.inclusiveMax + ", boost=" + this.boost + ')';
            }

            public int hashCode() {
                int result2 = this.field.hashCode();
                result2 = result2 * 31 + (this.min == null ? 0 : this.min.hashCode());
                result2 = result2 * 31 + Boolean.hashCode(this.inclusiveMin);
                result2 = result2 * 31 + (this.max == null ? 0 : this.max.hashCode());
                result2 = result2 * 31 + Boolean.hashCode(this.inclusiveMax);
                result2 = result2 * 31 + (this.boost == null ? 0 : ((Object)this.boost).hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NumericRangeQuery)) {
                    return false;
                }
                NumericRangeQuery numericRangeQuery = (NumericRangeQuery)other;
                if (!Intrinsics.areEqual((Object)this.field, (Object)numericRangeQuery.field)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.min, (Object)numericRangeQuery.min)) {
                    return false;
                }
                if (this.inclusiveMin != numericRangeQuery.inclusiveMin) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.max, (Object)numericRangeQuery.max)) {
                    return false;
                }
                if (this.inclusiveMax != numericRangeQuery.inclusiveMax) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.boost, (Object)numericRangeQuery.boost);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0080\b\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0004H\u00c6\u0003J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ4\u0010\u0017\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0004H\u00d6\u0001J\u0019\u0010 \u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0010\u00a2\u0006\u0004\b!\u0010\"R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\rX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$PhraseQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery;", "terms", "", "", "field", "boost", "", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/Double;)V", "getBoost", "()Ljava/lang/Double;", "Ljava/lang/Double;", "core", "Lcom/couchbase/client/core/api/search/queries/CorePhraseQuery;", "getCore$kotlin_client", "()Lcom/couchbase/client/core/api/search/queries/CorePhraseQuery;", "getField", "()Ljava/lang/String;", "getTerms", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$PhraseQuery;", "equals", "", "other", "", "hashCode", "", "toString", "withBoost", "withBoost$kotlin_client", "(Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$PhraseQuery;", "kotlin-client"})
        public static final class PhraseQuery
        extends SearchQuery {
            @NotNull
            private final List<String> terms;
            @NotNull
            private final String field;
            @Nullable
            private final Double boost;
            @NotNull
            private final CorePhraseQuery core;

            public PhraseQuery(@NotNull List<String> terms, @NotNull String field, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter(terms, (String)"terms");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                super(null);
                this.terms = terms;
                this.field = field;
                this.boost = boost;
                this.core = new CorePhraseQuery(this.terms, this.field, this.boost);
            }

            public /* synthetic */ PhraseQuery(List list, String string, Double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    d = null;
                }
                this(list, string, d);
            }

            @NotNull
            public final List<String> getTerms() {
                return this.terms;
            }

            @NotNull
            public final String getField() {
                return this.field;
            }

            @Nullable
            public final Double getBoost() {
                return this.boost;
            }

            @NotNull
            public CorePhraseQuery getCore$kotlin_client() {
                return this.core;
            }

            @Override
            @NotNull
            public PhraseQuery withBoost$kotlin_client(@Nullable Double boost) {
                return PhraseQuery.copy$default(this, null, null, boost, 3, null);
            }

            @NotNull
            public final List<String> component1() {
                return this.terms;
            }

            @NotNull
            public final String component2() {
                return this.field;
            }

            @Nullable
            public final Double component3() {
                return this.boost;
            }

            @NotNull
            public final PhraseQuery copy(@NotNull List<String> terms, @NotNull String field, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter(terms, (String)"terms");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                return new PhraseQuery(terms, field, boost);
            }

            public static /* synthetic */ PhraseQuery copy$default(PhraseQuery phraseQuery, List list, String string, Double d, int n, Object object) {
                if ((n & 1) != 0) {
                    list = phraseQuery.terms;
                }
                if ((n & 2) != 0) {
                    string = phraseQuery.field;
                }
                if ((n & 4) != 0) {
                    d = phraseQuery.boost;
                }
                return phraseQuery.copy(list, string, d);
            }

            @Override
            @NotNull
            public String toString() {
                return "PhraseQuery(terms=" + this.terms + ", field=" + this.field + ", boost=" + this.boost + ')';
            }

            public int hashCode() {
                int result2 = ((Object)this.terms).hashCode();
                result2 = result2 * 31 + this.field.hashCode();
                result2 = result2 * 31 + (this.boost == null ? 0 : ((Object)this.boost).hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PhraseQuery)) {
                    return false;
                }
                PhraseQuery phraseQuery = (PhraseQuery)other;
                if (!Intrinsics.areEqual(this.terms, phraseQuery.terms)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.field, (Object)phraseQuery.field)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.boost, (Object)phraseQuery.boost);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0080\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ.\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u001e\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0010\u00a2\u0006\u0004\b\u001f\u0010 R\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\fX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$PrefixQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery;", "prefix", "", "field", "boost", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Double;)V", "getBoost", "()Ljava/lang/Double;", "Ljava/lang/Double;", "core", "Lcom/couchbase/client/core/api/search/queries/CorePrefixQuery;", "getCore$kotlin_client", "()Lcom/couchbase/client/core/api/search/queries/CorePrefixQuery;", "getField", "()Ljava/lang/String;", "getPrefix", "component1", "component2", "component3", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$PrefixQuery;", "equals", "", "other", "", "hashCode", "", "toString", "withBoost", "withBoost$kotlin_client", "(Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$PrefixQuery;", "kotlin-client"})
        public static final class PrefixQuery
        extends SearchQuery {
            @NotNull
            private final String prefix;
            @NotNull
            private final String field;
            @Nullable
            private final Double boost;
            @NotNull
            private final CorePrefixQuery core;

            public PrefixQuery(@NotNull String prefix, @NotNull String field, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                super(null);
                this.prefix = prefix;
                this.field = field;
                this.boost = boost;
                this.core = new CorePrefixQuery(this.prefix, this.field, this.boost);
            }

            public /* synthetic */ PrefixQuery(String string, String string2, Double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    d = null;
                }
                this(string, string2, d);
            }

            @NotNull
            public final String getPrefix() {
                return this.prefix;
            }

            @NotNull
            public final String getField() {
                return this.field;
            }

            @Nullable
            public final Double getBoost() {
                return this.boost;
            }

            @NotNull
            public CorePrefixQuery getCore$kotlin_client() {
                return this.core;
            }

            @Override
            @NotNull
            public PrefixQuery withBoost$kotlin_client(@Nullable Double boost) {
                return PrefixQuery.copy$default(this, null, null, boost, 3, null);
            }

            @NotNull
            public final String component1() {
                return this.prefix;
            }

            @NotNull
            public final String component2() {
                return this.field;
            }

            @Nullable
            public final Double component3() {
                return this.boost;
            }

            @NotNull
            public final PrefixQuery copy(@NotNull String prefix, @NotNull String field, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                return new PrefixQuery(prefix, field, boost);
            }

            public static /* synthetic */ PrefixQuery copy$default(PrefixQuery prefixQuery, String string, String string2, Double d, int n, Object object) {
                if ((n & 1) != 0) {
                    string = prefixQuery.prefix;
                }
                if ((n & 2) != 0) {
                    string2 = prefixQuery.field;
                }
                if ((n & 4) != 0) {
                    d = prefixQuery.boost;
                }
                return prefixQuery.copy(string, string2, d);
            }

            @Override
            @NotNull
            public String toString() {
                return "PrefixQuery(prefix=" + this.prefix + ", field=" + this.field + ", boost=" + this.boost + ')';
            }

            public int hashCode() {
                int result2 = this.prefix.hashCode();
                result2 = result2 * 31 + this.field.hashCode();
                result2 = result2 * 31 + (this.boost == null ? 0 : ((Object)this.boost).hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PrefixQuery)) {
                    return false;
                }
                PrefixQuery prefixQuery = (PrefixQuery)other;
                if (!Intrinsics.areEqual((Object)this.prefix, (Object)prefixQuery.prefix)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.field, (Object)prefixQuery.field)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.boost, (Object)prefixQuery.boost);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0080\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ$\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u001b\u001a\u00020\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0010\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\u000bX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$QueryStringQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery;", "queryString", "", "boost", "", "(Ljava/lang/String;Ljava/lang/Double;)V", "getBoost", "()Ljava/lang/Double;", "Ljava/lang/Double;", "core", "Lcom/couchbase/client/core/api/search/queries/CoreQueryStringQuery;", "getCore$kotlin_client", "()Lcom/couchbase/client/core/api/search/queries/CoreQueryStringQuery;", "getQueryString", "()Ljava/lang/String;", "component1", "component2", "copy", "(Ljava/lang/String;Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$QueryStringQuery;", "equals", "", "other", "", "hashCode", "", "toString", "withBoost", "withBoost$kotlin_client", "(Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$QueryStringQuery;", "kotlin-client"})
        public static final class QueryStringQuery
        extends SearchQuery {
            @NotNull
            private final String queryString;
            @Nullable
            private final Double boost;
            @NotNull
            private final CoreQueryStringQuery core;

            public QueryStringQuery(@NotNull String queryString, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)queryString, (String)"queryString");
                super(null);
                this.queryString = queryString;
                this.boost = boost;
                this.core = new CoreQueryStringQuery(this.queryString, this.boost);
            }

            public /* synthetic */ QueryStringQuery(String string, Double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    d = null;
                }
                this(string, d);
            }

            @NotNull
            public final String getQueryString() {
                return this.queryString;
            }

            @Nullable
            public final Double getBoost() {
                return this.boost;
            }

            @NotNull
            public CoreQueryStringQuery getCore$kotlin_client() {
                return this.core;
            }

            @Override
            @NotNull
            public QueryStringQuery withBoost$kotlin_client(@Nullable Double boost) {
                return QueryStringQuery.copy$default(this, null, boost, 1, null);
            }

            @NotNull
            public final String component1() {
                return this.queryString;
            }

            @Nullable
            public final Double component2() {
                return this.boost;
            }

            @NotNull
            public final QueryStringQuery copy(@NotNull String queryString, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)queryString, (String)"queryString");
                return new QueryStringQuery(queryString, boost);
            }

            public static /* synthetic */ QueryStringQuery copy$default(QueryStringQuery queryStringQuery, String string, Double d, int n, Object object) {
                if ((n & 1) != 0) {
                    string = queryStringQuery.queryString;
                }
                if ((n & 2) != 0) {
                    d = queryStringQuery.boost;
                }
                return queryStringQuery.copy(string, d);
            }

            @Override
            @NotNull
            public String toString() {
                return "QueryStringQuery(queryString=" + this.queryString + ", boost=" + this.boost + ')';
            }

            public int hashCode() {
                int result2 = this.queryString.hashCode();
                result2 = result2 * 31 + (this.boost == null ? 0 : ((Object)this.boost).hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof QueryStringQuery)) {
                    return false;
                }
                QueryStringQuery queryStringQuery = (QueryStringQuery)other;
                if (!Intrinsics.areEqual((Object)this.queryString, (Object)queryStringQuery.queryString)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.boost, (Object)queryStringQuery.boost);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0080\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ.\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u001e\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0010\u00a2\u0006\u0004\b\u001f\u0010 R\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\fX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$RegexpQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery;", "regexp", "", "field", "boost", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Double;)V", "getBoost", "()Ljava/lang/Double;", "Ljava/lang/Double;", "core", "Lcom/couchbase/client/core/api/search/queries/CoreRegexpQuery;", "getCore$kotlin_client", "()Lcom/couchbase/client/core/api/search/queries/CoreRegexpQuery;", "getField", "()Ljava/lang/String;", "getRegexp", "component1", "component2", "component3", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$RegexpQuery;", "equals", "", "other", "", "hashCode", "", "toString", "withBoost", "withBoost$kotlin_client", "(Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$RegexpQuery;", "kotlin-client"})
        public static final class RegexpQuery
        extends SearchQuery {
            @NotNull
            private final String regexp;
            @NotNull
            private final String field;
            @Nullable
            private final Double boost;
            @NotNull
            private final CoreRegexpQuery core;

            public RegexpQuery(@NotNull String regexp, @NotNull String field, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)regexp, (String)"regexp");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                super(null);
                this.regexp = regexp;
                this.field = field;
                this.boost = boost;
                this.core = new CoreRegexpQuery(this.regexp, this.field, this.boost);
            }

            public /* synthetic */ RegexpQuery(String string, String string2, Double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    d = null;
                }
                this(string, string2, d);
            }

            @NotNull
            public final String getRegexp() {
                return this.regexp;
            }

            @NotNull
            public final String getField() {
                return this.field;
            }

            @Nullable
            public final Double getBoost() {
                return this.boost;
            }

            @NotNull
            public CoreRegexpQuery getCore$kotlin_client() {
                return this.core;
            }

            @Override
            @NotNull
            public RegexpQuery withBoost$kotlin_client(@Nullable Double boost) {
                return RegexpQuery.copy$default(this, null, null, boost, 3, null);
            }

            @NotNull
            public final String component1() {
                return this.regexp;
            }

            @NotNull
            public final String component2() {
                return this.field;
            }

            @Nullable
            public final Double component3() {
                return this.boost;
            }

            @NotNull
            public final RegexpQuery copy(@NotNull String regexp, @NotNull String field, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)regexp, (String)"regexp");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                return new RegexpQuery(regexp, field, boost);
            }

            public static /* synthetic */ RegexpQuery copy$default(RegexpQuery regexpQuery, String string, String string2, Double d, int n, Object object) {
                if ((n & 1) != 0) {
                    string = regexpQuery.regexp;
                }
                if ((n & 2) != 0) {
                    string2 = regexpQuery.field;
                }
                if ((n & 4) != 0) {
                    d = regexpQuery.boost;
                }
                return regexpQuery.copy(string, string2, d);
            }

            @Override
            @NotNull
            public String toString() {
                return "RegexpQuery(regexp=" + this.regexp + ", field=" + this.field + ", boost=" + this.boost + ')';
            }

            public int hashCode() {
                int result2 = this.regexp.hashCode();
                result2 = result2 * 31 + this.field.hashCode();
                result2 = result2 * 31 + (this.boost == null ? 0 : ((Object)this.boost).hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RegexpQuery)) {
                    return false;
                }
                RegexpQuery regexpQuery = (RegexpQuery)other;
                if (!Intrinsics.areEqual((Object)this.regexp, (Object)regexpQuery.regexp)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.field, (Object)regexpQuery.field)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.boost, (Object)regexpQuery.boost);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0080\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0002\u0010\fJB\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020\u0006H\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010%\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0010\u00a2\u0006\u0004\b&\u0010'R\u0015\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000fX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013\u00a8\u0006("}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$TermQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery;", "term", "", "field", "fuzziness", "", "prefixLength", "boost", "", "(Ljava/lang/String;Ljava/lang/String;IILjava/lang/Double;)V", "getBoost", "()Ljava/lang/Double;", "Ljava/lang/Double;", "core", "Lcom/couchbase/client/core/api/search/queries/CoreTermQuery;", "getCore$kotlin_client", "()Lcom/couchbase/client/core/api/search/queries/CoreTermQuery;", "getField", "()Ljava/lang/String;", "getFuzziness", "()I", "getPrefixLength", "getTerm", "component1", "component2", "component3", "component4", "component5", "copy", "(Ljava/lang/String;Ljava/lang/String;IILjava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$TermQuery;", "equals", "", "other", "", "hashCode", "toString", "withBoost", "withBoost$kotlin_client", "(Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$TermQuery;", "kotlin-client"})
        public static final class TermQuery
        extends SearchQuery {
            @NotNull
            private final String term;
            @NotNull
            private final String field;
            private final int fuzziness;
            private final int prefixLength;
            @Nullable
            private final Double boost;
            @NotNull
            private final CoreTermQuery core;

            public TermQuery(@NotNull String term, @NotNull String field, int fuzziness, int prefixLength, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)term, (String)"term");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                super(null);
                this.term = term;
                this.field = field;
                this.fuzziness = fuzziness;
                this.prefixLength = prefixLength;
                this.boost = boost;
                this.core = new CoreTermQuery(this.term, this.field, Integer.valueOf(this.fuzziness), Integer.valueOf(this.prefixLength), this.boost);
            }

            public /* synthetic */ TermQuery(String string, String string2, int n, int n2, Double d, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 0x10) != 0) {
                    d = null;
                }
                this(string, string2, n, n2, d);
            }

            @NotNull
            public final String getTerm() {
                return this.term;
            }

            @NotNull
            public final String getField() {
                return this.field;
            }

            public final int getFuzziness() {
                return this.fuzziness;
            }

            public final int getPrefixLength() {
                return this.prefixLength;
            }

            @Nullable
            public final Double getBoost() {
                return this.boost;
            }

            @NotNull
            public CoreTermQuery getCore$kotlin_client() {
                return this.core;
            }

            @Override
            @NotNull
            public TermQuery withBoost$kotlin_client(@Nullable Double boost) {
                return TermQuery.copy$default(this, null, null, 0, 0, boost, 15, null);
            }

            @NotNull
            public final String component1() {
                return this.term;
            }

            @NotNull
            public final String component2() {
                return this.field;
            }

            public final int component3() {
                return this.fuzziness;
            }

            public final int component4() {
                return this.prefixLength;
            }

            @Nullable
            public final Double component5() {
                return this.boost;
            }

            @NotNull
            public final TermQuery copy(@NotNull String term, @NotNull String field, int fuzziness, int prefixLength, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)term, (String)"term");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                return new TermQuery(term, field, fuzziness, prefixLength, boost);
            }

            public static /* synthetic */ TermQuery copy$default(TermQuery termQuery, String string, String string2, int n, int n2, Double d, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    string = termQuery.term;
                }
                if ((n3 & 2) != 0) {
                    string2 = termQuery.field;
                }
                if ((n3 & 4) != 0) {
                    n = termQuery.fuzziness;
                }
                if ((n3 & 8) != 0) {
                    n2 = termQuery.prefixLength;
                }
                if ((n3 & 0x10) != 0) {
                    d = termQuery.boost;
                }
                return termQuery.copy(string, string2, n, n2, d);
            }

            @Override
            @NotNull
            public String toString() {
                return "TermQuery(term=" + this.term + ", field=" + this.field + ", fuzziness=" + this.fuzziness + ", prefixLength=" + this.prefixLength + ", boost=" + this.boost + ')';
            }

            public int hashCode() {
                int result2 = this.term.hashCode();
                result2 = result2 * 31 + this.field.hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.fuzziness);
                result2 = result2 * 31 + Integer.hashCode(this.prefixLength);
                result2 = result2 * 31 + (this.boost == null ? 0 : ((Object)this.boost).hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TermQuery)) {
                    return false;
                }
                TermQuery termQuery = (TermQuery)other;
                if (!Intrinsics.areEqual((Object)this.term, (Object)termQuery.term)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.field, (Object)termQuery.field)) {
                    return false;
                }
                if (this.fuzziness != termQuery.fuzziness) {
                    return false;
                }
                if (this.prefixLength != termQuery.prefixLength) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.boost, (Object)termQuery.boost);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0080\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00c6\u0003J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\nH\u00c6\u0003\u00a2\u0006\u0002\u0010\rJP\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\b\u001a\u00020\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001\u00a2\u0006\u0002\u0010!J\u0013\u0010\"\u001a\u00020\u00062\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010(\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0010\u00a2\u0006\u0004\b)\u0010*R\u0015\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u0010X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014\u00a8\u0006+"}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$TermRangeQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery;", "field", "", "min", "inclusiveMin", "", "max", "inclusiveMax", "boost", "", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;ZLjava/lang/Double;)V", "getBoost", "()Ljava/lang/Double;", "Ljava/lang/Double;", "core", "Lcom/couchbase/client/core/api/search/queries/CoreTermRangeQuery;", "getCore$kotlin_client", "()Lcom/couchbase/client/core/api/search/queries/CoreTermRangeQuery;", "getField", "()Ljava/lang/String;", "getInclusiveMax", "()Z", "getInclusiveMin", "getMax", "getMin", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;ZLjava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$TermRangeQuery;", "equals", "other", "", "hashCode", "", "toString", "withBoost", "withBoost$kotlin_client", "(Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$TermRangeQuery;", "kotlin-client"})
        public static final class TermRangeQuery
        extends SearchQuery {
            @NotNull
            private final String field;
            @Nullable
            private final String min;
            private final boolean inclusiveMin;
            @Nullable
            private final String max;
            private final boolean inclusiveMax;
            @Nullable
            private final Double boost;
            @NotNull
            private final CoreTermRangeQuery core;

            public TermRangeQuery(@NotNull String field, @Nullable String min, boolean inclusiveMin, @Nullable String max, boolean inclusiveMax, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                super(null);
                this.field = field;
                this.min = min;
                this.inclusiveMin = inclusiveMin;
                this.max = max;
                this.inclusiveMax = inclusiveMax;
                this.boost = boost;
                this.core = new CoreTermRangeQuery(this.min, this.max, Boolean.valueOf(this.inclusiveMin), Boolean.valueOf(this.inclusiveMax), this.field, this.boost);
            }

            public /* synthetic */ TermRangeQuery(String string, String string2, boolean bl, String string3, boolean bl2, Double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 0x20) != 0) {
                    d = null;
                }
                this(string, string2, bl, string3, bl2, d);
            }

            @NotNull
            public final String getField() {
                return this.field;
            }

            @Nullable
            public final String getMin() {
                return this.min;
            }

            public final boolean getInclusiveMin() {
                return this.inclusiveMin;
            }

            @Nullable
            public final String getMax() {
                return this.max;
            }

            public final boolean getInclusiveMax() {
                return this.inclusiveMax;
            }

            @Nullable
            public final Double getBoost() {
                return this.boost;
            }

            @NotNull
            public CoreTermRangeQuery getCore$kotlin_client() {
                return this.core;
            }

            @Override
            @NotNull
            public TermRangeQuery withBoost$kotlin_client(@Nullable Double boost) {
                return TermRangeQuery.copy$default(this, null, null, false, null, false, boost, 31, null);
            }

            @NotNull
            public final String component1() {
                return this.field;
            }

            @Nullable
            public final String component2() {
                return this.min;
            }

            public final boolean component3() {
                return this.inclusiveMin;
            }

            @Nullable
            public final String component4() {
                return this.max;
            }

            public final boolean component5() {
                return this.inclusiveMax;
            }

            @Nullable
            public final Double component6() {
                return this.boost;
            }

            @NotNull
            public final TermRangeQuery copy(@NotNull String field, @Nullable String min, boolean inclusiveMin, @Nullable String max, boolean inclusiveMax, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                return new TermRangeQuery(field, min, inclusiveMin, max, inclusiveMax, boost);
            }

            public static /* synthetic */ TermRangeQuery copy$default(TermRangeQuery termRangeQuery, String string, String string2, boolean bl, String string3, boolean bl2, Double d, int n, Object object) {
                if ((n & 1) != 0) {
                    string = termRangeQuery.field;
                }
                if ((n & 2) != 0) {
                    string2 = termRangeQuery.min;
                }
                if ((n & 4) != 0) {
                    bl = termRangeQuery.inclusiveMin;
                }
                if ((n & 8) != 0) {
                    string3 = termRangeQuery.max;
                }
                if ((n & 0x10) != 0) {
                    bl2 = termRangeQuery.inclusiveMax;
                }
                if ((n & 0x20) != 0) {
                    d = termRangeQuery.boost;
                }
                return termRangeQuery.copy(string, string2, bl, string3, bl2, d);
            }

            @Override
            @NotNull
            public String toString() {
                return "TermRangeQuery(field=" + this.field + ", min=" + this.min + ", inclusiveMin=" + this.inclusiveMin + ", max=" + this.max + ", inclusiveMax=" + this.inclusiveMax + ", boost=" + this.boost + ')';
            }

            public int hashCode() {
                int result2 = this.field.hashCode();
                result2 = result2 * 31 + (this.min == null ? 0 : this.min.hashCode());
                result2 = result2 * 31 + Boolean.hashCode(this.inclusiveMin);
                result2 = result2 * 31 + (this.max == null ? 0 : this.max.hashCode());
                result2 = result2 * 31 + Boolean.hashCode(this.inclusiveMax);
                result2 = result2 * 31 + (this.boost == null ? 0 : ((Object)this.boost).hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TermRangeQuery)) {
                    return false;
                }
                TermRangeQuery termRangeQuery = (TermRangeQuery)other;
                if (!Intrinsics.areEqual((Object)this.field, (Object)termRangeQuery.field)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.min, (Object)termRangeQuery.min)) {
                    return false;
                }
                if (this.inclusiveMin != termRangeQuery.inclusiveMin) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.max, (Object)termRangeQuery.max)) {
                    return false;
                }
                if (this.inclusiveMax != termRangeQuery.inclusiveMax) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.boost, (Object)termRangeQuery.boost);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0080\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ.\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u001e\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0010\u00a2\u0006\u0004\b\u001f\u0010 R\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\fX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$WildcardQuery;", "Lcom/couchbase/client/kotlin/search/SearchQuery;", "term", "", "field", "boost", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Double;)V", "getBoost", "()Ljava/lang/Double;", "Ljava/lang/Double;", "core", "Lcom/couchbase/client/core/api/search/queries/CoreWildcardQuery;", "getCore$kotlin_client", "()Lcom/couchbase/client/core/api/search/queries/CoreWildcardQuery;", "getField", "()Ljava/lang/String;", "getTerm", "component1", "component2", "component3", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$WildcardQuery;", "equals", "", "other", "", "hashCode", "", "toString", "withBoost", "withBoost$kotlin_client", "(Ljava/lang/Double;)Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$WildcardQuery;", "kotlin-client"})
        public static final class WildcardQuery
        extends SearchQuery {
            @NotNull
            private final String term;
            @NotNull
            private final String field;
            @Nullable
            private final Double boost;
            @NotNull
            private final CoreWildcardQuery core;

            public WildcardQuery(@NotNull String term, @NotNull String field, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)term, (String)"term");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                super(null);
                this.term = term;
                this.field = field;
                this.boost = boost;
                this.core = new CoreWildcardQuery(this.term, this.field, this.boost);
            }

            public /* synthetic */ WildcardQuery(String string, String string2, Double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    d = null;
                }
                this(string, string2, d);
            }

            @NotNull
            public final String getTerm() {
                return this.term;
            }

            @NotNull
            public final String getField() {
                return this.field;
            }

            @Nullable
            public final Double getBoost() {
                return this.boost;
            }

            @NotNull
            public CoreWildcardQuery getCore$kotlin_client() {
                return this.core;
            }

            @Override
            @NotNull
            public WildcardQuery withBoost$kotlin_client(@Nullable Double boost) {
                return WildcardQuery.copy$default(this, null, null, boost, 3, null);
            }

            @NotNull
            public final String component1() {
                return this.term;
            }

            @NotNull
            public final String component2() {
                return this.field;
            }

            @Nullable
            public final Double component3() {
                return this.boost;
            }

            @NotNull
            public final WildcardQuery copy(@NotNull String term, @NotNull String field, @Nullable Double boost) {
                Intrinsics.checkNotNullParameter((Object)term, (String)"term");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                return new WildcardQuery(term, field, boost);
            }

            public static /* synthetic */ WildcardQuery copy$default(WildcardQuery wildcardQuery, String string, String string2, Double d, int n, Object object) {
                if ((n & 1) != 0) {
                    string = wildcardQuery.term;
                }
                if ((n & 2) != 0) {
                    string2 = wildcardQuery.field;
                }
                if ((n & 4) != 0) {
                    d = wildcardQuery.boost;
                }
                return wildcardQuery.copy(string, string2, d);
            }

            @Override
            @NotNull
            public String toString() {
                return "WildcardQuery(term=" + this.term + ", field=" + this.field + ", boost=" + this.boost + ')';
            }

            public int hashCode() {
                int result2 = this.term.hashCode();
                result2 = result2 * 31 + this.field.hashCode();
                result2 = result2 * 31 + (this.boost == null ? 0 : ((Object)this.boost).hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof WildcardQuery)) {
                    return false;
                }
                WildcardQuery wildcardQuery = (WildcardQuery)other;
                if (!Intrinsics.areEqual((Object)this.term, (Object)wildcardQuery.term)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.field, (Object)wildcardQuery.field)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.boost, (Object)wildcardQuery.boost);
            }
        }
    }
}

