/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.codec;

import com.couchbase.client.kotlin.codec.JsonSerializer;
import com.couchbase.client.kotlin.codec.TypeRef;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KType;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ)\u0010\f\u001a\u00020\b\"\u0004\b\u0000\u0010\u00062\u0006\u0010\r\u001a\u0002H\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\nH\u0016\u00a2\u0006\u0002\u0010\u000eJ\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0010\"\u0004\b\u0000\u0010\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00060\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/couchbase/client/kotlin/codec/KotlinxSerializationJsonSerializer;", "Lcom/couchbase/client/kotlin/codec/JsonSerializer;", "jsonFormat", "Lkotlinx/serialization/json/Json;", "(Lkotlinx/serialization/json/Json;)V", "deserialize", "T", "json", "", "type", "Lcom/couchbase/client/kotlin/codec/TypeRef;", "([BLcom/couchbase/client/kotlin/codec/TypeRef;)Ljava/lang/Object;", "serialize", "value", "(Ljava/lang/Object;Lcom/couchbase/client/kotlin/codec/TypeRef;)[B", "serializer", "Lkotlinx/serialization/KSerializer;", "typeRef", "kotlin-client"})
public final class KotlinxSerializationJsonSerializer
implements JsonSerializer {
    @NotNull
    private final Json jsonFormat;

    public KotlinxSerializationJsonSerializer(@NotNull Json jsonFormat) {
        Intrinsics.checkNotNullParameter((Object)jsonFormat, (String)"jsonFormat");
        this.jsonFormat = jsonFormat;
    }

    public /* synthetic */ KotlinxSerializationJsonSerializer(Json json, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            json = (Json)Json.Default;
        }
        this(json);
    }

    @Override
    @NotNull
    public <T> byte[] serialize(T value2, @NotNull TypeRef<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        String string = this.jsonFormat.encodeToString((SerializationStrategy)this.serializer(type), value2);
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    @Override
    public <T> T deserialize(@NotNull byte[] json, @NotNull TypeRef<T> type) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return (T)this.jsonFormat.decodeFromString((DeserializationStrategy)this.serializer(type), new String(json, Charsets.UTF_8));
    }

    private final <T> KSerializer<T> serializer(TypeRef<T> typeRef2) {
        KSerializer kSerializer = SerializersKt.serializer((SerializersModule)this.jsonFormat.getSerializersModule(), (KType)typeRef2.getKtype());
        Intrinsics.checkNotNull((Object)kSerializer, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of com.couchbase.client.kotlin.codec.KotlinxSerializationJsonSerializer.serializer>");
        return kSerializer;
    }

    public KotlinxSerializationJsonSerializer() {
        this(null, 1, null);
    }
}

