/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.query;

import com.couchbase.client.core.api.query.CoreQueryMetaData;
import com.couchbase.client.core.api.query.CoreQueryMetrics;
import com.couchbase.client.core.api.query.CoreQueryWarning;
import com.couchbase.client.core.classic.query.ClassicCoreQueryMetaData;
import com.couchbase.client.core.msg.query.QueryChunkHeader;
import com.couchbase.client.core.msg.query.QueryChunkTrailer;
import com.couchbase.client.kotlin.internal.LangExtensionsKt;
import com.couchbase.client.kotlin.query.QueryFlowItem;
import com.couchbase.client.kotlin.query.QueryFlowItemKt;
import com.couchbase.client.kotlin.query.QueryMetrics;
import com.couchbase.client.kotlin.query.QueryStatus;
import com.couchbase.client.kotlin.query.QueryWarning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010,\u001a\u00020\u000bH\u0016R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\rR*\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0018\u00010\u00138FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010\u0016R\u0013\u0010!\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001aR\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006-"}, d2={"Lcom/couchbase/client/kotlin/query/QueryMetadata;", "Lcom/couchbase/client/kotlin/query/QueryFlowItem;", "header", "Lcom/couchbase/client/core/msg/query/QueryChunkHeader;", "trailer", "Lcom/couchbase/client/core/msg/query/QueryChunkTrailer;", "(Lcom/couchbase/client/core/msg/query/QueryChunkHeader;Lcom/couchbase/client/core/msg/query/QueryChunkTrailer;)V", "core", "Lcom/couchbase/client/core/api/query/CoreQueryMetaData;", "(Lcom/couchbase/client/core/api/query/CoreQueryMetaData;)V", "clientContextId", "", "getClientContextId", "()Ljava/lang/String;", "metrics", "Lcom/couchbase/client/kotlin/query/QueryMetrics;", "getMetrics", "()Lcom/couchbase/client/kotlin/query/QueryMetrics;", "profile", "", "", "getProfile", "()Ljava/util/Map;", "profileBytes", "", "getProfileBytes", "()[B", "requestId", "getRequestId", "signature", "getSignature$annotations", "()V", "getSignature", "signatureBytes", "getSignatureBytes", "status", "Lcom/couchbase/client/kotlin/query/QueryStatus;", "getStatus", "()Lcom/couchbase/client/kotlin/query/QueryStatus;", "warnings", "", "Lcom/couchbase/client/kotlin/query/QueryWarning;", "getWarnings", "()Ljava/util/List;", "toString", "kotlin-client"})
public final class QueryMetadata
extends QueryFlowItem {
    @NotNull
    private final CoreQueryMetaData core;

    public QueryMetadata(@NotNull CoreQueryMetaData core) {
        Intrinsics.checkNotNullParameter((Object)core, (String)"core");
        super(null);
        this.core = core;
    }

    @Deprecated(message="QueryMetadata constructor will be private in a future version.")
    public QueryMetadata(@NotNull QueryChunkHeader header, @NotNull QueryChunkTrailer trailer) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)trailer, (String)"trailer");
        this((CoreQueryMetaData)new ClassicCoreQueryMetaData(header, trailer));
    }

    @NotNull
    public final String getRequestId() {
        String string = this.core.requestId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"core.requestId()");
        return string;
    }

    @NotNull
    public final String getClientContextId() {
        String string = this.core.clientContextId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"core.clientContextId()");
        return string;
    }

    @NotNull
    public final QueryStatus getStatus() {
        return QueryStatus.Companion.from(this.core.status().name());
    }

    @Nullable
    public final Map<String, Object> getSignature() {
        Optional optional = this.core.signature();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"core.signature()");
        return QueryFlowItemKt.access$parseAsMap(optional).orElse(null);
    }

    @Deprecated(message="This accessor throws an exception if the signature returned by the query engine is not a JSON Object. Please use `signatureBytes` instead.")
    public static /* synthetic */ void getSignature$annotations() {
    }

    @Nullable
    public final byte[] getSignatureBytes() {
        return this.core.signature().orElse(null);
    }

    @Nullable
    public final Map<String, Object> getProfile() {
        Optional optional = this.core.profile();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"core.profile()");
        return QueryFlowItemKt.access$parseAsMap(optional).orElse(null);
    }

    @Nullable
    public final byte[] getProfileBytes() {
        return this.core.profile().orElse(null);
    }

    @Nullable
    public final QueryMetrics getMetrics() {
        return this.core.metrics().map(QueryMetadata::_get_metrics_$lambda-0).orElse(null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<QueryWarning> getWarnings() {
        void $this$mapTo$iv$iv;
        List list = this.core.warnings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"core.warnings()");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CoreQueryWarning coreQueryWarning = (CoreQueryWarning)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection2.add(new QueryWarning((CoreQueryWarning)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public String toString() {
        byte[] byArray = this.getSignatureBytes();
        byte[] byArray2 = this.getProfileBytes();
        return "QueryMetadata(requestId='" + this.getRequestId() + "', clientContextId='" + this.getClientContextId() + "', status=" + (Object)((Object)this.getStatus()) + ", signature=" + (byArray != null ? LangExtensionsKt.toStringUtf8(byArray) : null) + ", profile=" + (byArray2 != null ? LangExtensionsKt.toStringUtf8(byArray2) : null) + ", metrics=" + this.getMetrics() + ", warnings=" + this.getWarnings() + ')';
    }

    private static final QueryMetrics _get_metrics_$lambda-0(CoreQueryMetrics it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return new QueryMetrics(it);
    }
}

