/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.search;

import com.couchbase.client.core.api.search.CoreSearchMetaData;
import com.couchbase.client.core.api.search.result.CoreDateRangeSearchFacetResult;
import com.couchbase.client.core.api.search.result.CoreNumericRangeSearchFacetResult;
import com.couchbase.client.core.api.search.result.CoreSearchDateRange;
import com.couchbase.client.core.api.search.result.CoreSearchFacetResult;
import com.couchbase.client.core.api.search.result.CoreSearchMetrics;
import com.couchbase.client.core.api.search.result.CoreSearchNumericRange;
import com.couchbase.client.core.api.search.result.CoreSearchTermRange;
import com.couchbase.client.core.api.search.result.CoreTermSearchFacetResult;
import com.couchbase.client.kotlin.search.BaseFacetResult;
import com.couchbase.client.kotlin.search.Category;
import com.couchbase.client.kotlin.search.CategoryResult;
import com.couchbase.client.kotlin.search.DateFacet;
import com.couchbase.client.kotlin.search.DateFacetResult;
import com.couchbase.client.kotlin.search.DateRange;
import com.couchbase.client.kotlin.search.FacetResult;
import com.couchbase.client.kotlin.search.FacetResultAccessor;
import com.couchbase.client.kotlin.search.FrequentTerm;
import com.couchbase.client.kotlin.search.NumericFacet;
import com.couchbase.client.kotlin.search.NumericFacetResult;
import com.couchbase.client.kotlin.search.NumericRange;
import com.couchbase.client.kotlin.search.SearchFlowItem;
import com.couchbase.client.kotlin.search.SearchMetrics;
import com.couchbase.client.kotlin.search.TermFacet;
import com.couchbase.client.kotlin.search.TermFacetResult;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0096\u0002J\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0018\u001a\u00020\u001bH\u0096\u0002J\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u0007H\u0016R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lcom/couchbase/client/kotlin/search/SearchMetadata;", "Lcom/couchbase/client/kotlin/search/SearchFlowItem;", "Lcom/couchbase/client/kotlin/search/FacetResultAccessor;", "meta", "Lcom/couchbase/client/core/api/search/CoreSearchMetaData;", "coreFacets", "", "", "Lcom/couchbase/client/core/api/search/result/CoreSearchFacetResult;", "(Lcom/couchbase/client/core/api/search/CoreSearchMetaData;Ljava/util/Map;)V", "errors", "getErrors", "()Ljava/util/Map;", "facets", "", "Lcom/couchbase/client/kotlin/search/FacetResult;", "getFacets", "()Ljava/util/List;", "metrics", "Lcom/couchbase/client/kotlin/search/SearchMetrics;", "getMetrics", "()Lcom/couchbase/client/kotlin/search/SearchMetrics;", "get", "Lcom/couchbase/client/kotlin/search/DateFacetResult;", "facet", "Lcom/couchbase/client/kotlin/search/DateFacet;", "Lcom/couchbase/client/kotlin/search/NumericFacetResult;", "Lcom/couchbase/client/kotlin/search/NumericFacet;", "Lcom/couchbase/client/kotlin/search/TermFacetResult;", "Lcom/couchbase/client/kotlin/search/TermFacet;", "toString", "kotlin-client"})
public final class SearchMetadata
extends SearchFlowItem
implements FacetResultAccessor {
    @NotNull
    private final SearchMetrics metrics;
    @NotNull
    private final Map<String, String> errors;
    @NotNull
    private final List<FacetResult<?>> facets;

    /*
     * WARNING - void declaration
     */
    public SearchMetadata(@NotNull CoreSearchMetaData meta, @NotNull Map<String, ? extends CoreSearchFacetResult> coreFacets) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        Intrinsics.checkNotNullParameter(coreFacets, (String)"coreFacets");
        super(null);
        CoreSearchMetrics coreSearchMetrics = meta.metrics();
        Intrinsics.checkNotNullExpressionValue((Object)coreSearchMetrics, (String)"meta.metrics()");
        this.metrics = new SearchMetrics(coreSearchMetrics);
        Map map2 = meta.errors();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"meta.errors()");
        this.errors = map2;
        Iterable iterable = coreFacets.values();
        SearchMetadata searchMetadata = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FacetResult facetResult;
            CoreSearchNumericRange it;
            Collection collection2;
            Iterable $this$mapTo$iv$iv2;
            boolean $i$f$mapTo2;
            Collection destination$iv$iv2;
            Iterable $this$map$iv2;
            boolean $i$f$map2;
            void var14_15;
            void core;
            CoreSearchFacetResult coreSearchFacetResult = (CoreSearchFacetResult)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            void var12_13 = core;
            if (var12_13 instanceof CoreDateRangeSearchFacetResult) {
                List list = ((CoreDateRangeSearchFacetResult)core).dateRanges();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"core.dateRanges()");
                Iterable iterable2 = list;
                var14_15 = core;
                $i$f$map2 = false;
                Iterable iterable3 = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    CoreSearchDateRange coreSearchDateRange = (CoreSearchDateRange)item$iv$iv2;
                    collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    Instant instant = it.start();
                    Instant instant2 = it.end();
                    String string = it.name();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name()");
                    collection2.add(new CategoryResult<Category>(new DateRange(instant, instant2, string), it.count()));
                }
                List list2 = (List)destination$iv$iv2;
                void var27_27 = var14_15;
                BaseFacetResult<DateRange> baseFacetResult = new BaseFacetResult<DateRange>((CoreSearchFacetResult)var27_27, list2);
                facetResult = new DateFacetResult(baseFacetResult);
            } else if (var12_13 instanceof CoreNumericRangeSearchFacetResult) {
                List list = ((CoreNumericRangeSearchFacetResult)core).numericRanges();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"core.numericRanges()");
                $this$map$iv2 = list;
                var14_15 = core;
                $i$f$map2 = false;
                $this$mapTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    it = (CoreSearchNumericRange)item$iv$iv2;
                    collection2 = destination$iv$iv2;
                    boolean bl3 = false;
                    Double d = it.min();
                    Double d2 = it.max();
                    String string = it.name();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name()");
                    collection2.add(new CategoryResult<Category>(new NumericRange(d, d2, string), it.count()));
                }
                List list3 = (List)destination$iv$iv2;
                void var30_30 = var14_15;
                BaseFacetResult<NumericRange> baseFacetResult = new BaseFacetResult<NumericRange>((CoreSearchFacetResult)var30_30, list3);
                facetResult = new NumericFacetResult(baseFacetResult);
            } else if (var12_13 instanceof CoreTermSearchFacetResult) {
                List list = ((CoreTermSearchFacetResult)core).terms();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"core.terms()");
                $this$map$iv2 = list;
                var14_15 = core;
                $i$f$map2 = false;
                $this$mapTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    it = (CoreSearchTermRange)item$iv$iv2;
                    collection2 = destination$iv$iv2;
                    boolean bl4 = false;
                    String string = it.name();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name()");
                    collection2.add(new CategoryResult<Category>(new FrequentTerm(string), it.count()));
                }
                List list4 = (List)destination$iv$iv2;
                void var33_33 = var14_15;
                BaseFacetResult<FrequentTerm> baseFacetResult = new BaseFacetResult<FrequentTerm>((CoreSearchFacetResult)var33_33, list4);
                facetResult = new TermFacetResult(baseFacetResult);
            } else {
                throw new RuntimeException("Unexpected facet result type: " + core);
            }
            collection3.add(facetResult);
        }
        searchMetadata.facets = (List)destination$iv$iv;
    }

    @NotNull
    public final SearchMetrics getMetrics() {
        return this.metrics;
    }

    @NotNull
    public final Map<String, String> getErrors() {
        return this.errors;
    }

    @Override
    @NotNull
    public List<FacetResult<?>> getFacets() {
        return this.facets;
    }

    @Override
    @Nullable
    public TermFacetResult get(@NotNull TermFacet facet) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            Iterable iterable = this.getFacets();
            for (Object t : iterable) {
                FacetResult it = (FacetResult)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)facet.getName())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Object var2_7 = v0;
        return var2_7 instanceof TermFacetResult ? (TermFacetResult)var2_7 : null;
    }

    @Override
    @Nullable
    public NumericFacetResult get(@NotNull NumericFacet facet) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            Iterable iterable = this.getFacets();
            for (Object t : iterable) {
                FacetResult it = (FacetResult)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)facet.getName())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Object var2_7 = v0;
        return var2_7 instanceof NumericFacetResult ? (NumericFacetResult)var2_7 : null;
    }

    @Override
    @Nullable
    public DateFacetResult get(@NotNull DateFacet facet) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            Iterable iterable = this.getFacets();
            for (Object t : iterable) {
                FacetResult it = (FacetResult)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)facet.getName())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Object var2_7 = v0;
        return var2_7 instanceof DateFacetResult ? (DateFacetResult)var2_7 : null;
    }

    @NotNull
    public String toString() {
        return "SearchMetadata(metrics=" + this.metrics + ", errors=" + this.errors + ", facets=" + this.getFacets() + ')';
    }
}

