/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.manager.bucket;

import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.kotlin.kv.Durability;
import com.couchbase.client.kotlin.kv.Expiry;
import com.couchbase.client.kotlin.manager.bucket.BucketType;
import com.couchbase.client.kotlin.manager.bucket.CompressionMode;
import com.couchbase.client.kotlin.manager.bucket.ConflictResolutionType;
import com.couchbase.client.kotlin.manager.bucket.EvictionPolicyType;
import com.couchbase.client.kotlin.manager.bucket.StorageBackend;
import com.couchbase.client.kotlin.util.StorageSize;
import com.couchbase.client.kotlin.util.StorageSizeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001d\u0018\u0000 82\u00020\u0001:\u00018B\u008a\u0001\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\u0019\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\b\u00107\u001a\u00020\u0003H\u0016R\u001c\u0010\u0006\u001a\u00020\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010\u0010\u001a\u00020\u0011\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b!\u0010\u001fR\u001c\u0010\u0012\u001a\u00020\u0013\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b\"\u0010\u001fR\u001c\u0010\u0016\u001a\u00020\u0017\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b#\u0010\u001fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0015\u0010\u0019\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010(\u001a\u0004\b&\u0010'R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u001fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010,R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0015\u0010\u0018\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010(\u001a\u0004\b5\u0010'R\u001c\u0010\b\u001a\u00020\t\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b6\u0010\u001f\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00069"}, d2={"Lcom/couchbase/client/kotlin/manager/bucket/BucketSettings;", "", "name", "", "ramQuota", "Lcom/couchbase/client/kotlin/util/StorageSize;", "bucketType", "Lcom/couchbase/client/kotlin/manager/bucket/BucketType;", "storageBackend", "Lcom/couchbase/client/kotlin/manager/bucket/StorageBackend;", "flushEnabled", "", "replicas", "", "maximumExpiry", "Lcom/couchbase/client/kotlin/kv/Expiry;", "compressionMode", "Lcom/couchbase/client/kotlin/manager/bucket/CompressionMode;", "conflictResolutionType", "Lcom/couchbase/client/kotlin/manager/bucket/ConflictResolutionType;", "minimumDurability", "Lcom/couchbase/client/kotlin/kv/Durability;", "evictionPolicy", "Lcom/couchbase/client/kotlin/manager/bucket/EvictionPolicyType;", "replicateViewIndexes", "historyRetentionCollectionDefault", "historyRetentionSize", "historyRetentionDuration", "Lkotlin/time/Duration;", "(Ljava/lang/String;Lcom/couchbase/client/kotlin/util/StorageSize;Ljava/lang/String;Ljava/lang/String;ZILcom/couchbase/client/kotlin/kv/Expiry;Ljava/lang/String;Ljava/lang/String;Lcom/couchbase/client/kotlin/kv/Durability;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Lcom/couchbase/client/kotlin/util/StorageSize;Lkotlin/time/Duration;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getBucketType-_LoaUmE", "()Ljava/lang/String;", "Ljava/lang/String;", "getCompressionMode-BKvunfc", "getConflictResolutionType-nji6rpM", "getEvictionPolicy-0CRHu3k", "getFlushEnabled", "()Z", "getHistoryRetentionCollectionDefault", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getHistoryRetentionDuration-FghU774", "()Lkotlin/time/Duration;", "getHistoryRetentionSize", "()Lcom/couchbase/client/kotlin/util/StorageSize;", "getMaximumExpiry", "()Lcom/couchbase/client/kotlin/kv/Expiry;", "getMinimumDurability", "()Lcom/couchbase/client/kotlin/kv/Durability;", "getName", "getRamQuota", "getReplicas", "()I", "getReplicateViewIndexes", "getStorageBackend-HgnfZFs", "toString", "Companion", "kotlin-client"})
public final class BucketSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final StorageSize ramQuota;
    @NotNull
    private final String bucketType;
    @NotNull
    private final String storageBackend;
    private final boolean flushEnabled;
    private final int replicas;
    @NotNull
    private final Expiry maximumExpiry;
    @NotNull
    private final String compressionMode;
    @NotNull
    private final String conflictResolutionType;
    @NotNull
    private final Durability minimumDurability;
    @NotNull
    private final String evictionPolicy;
    @Nullable
    private final Boolean replicateViewIndexes;
    @Nullable
    private final Boolean historyRetentionCollectionDefault;
    @Nullable
    private final StorageSize historyRetentionSize;
    @Nullable
    private final Duration historyRetentionDuration;

    private BucketSettings(String name, StorageSize ramQuota, String bucketType, String storageBackend, boolean flushEnabled, int replicas, Expiry maximumExpiry, String compressionMode, String conflictResolutionType, Durability minimumDurability, String evictionPolicy, Boolean replicateViewIndexes, Boolean historyRetentionCollectionDefault, StorageSize historyRetentionSize, Duration historyRetentionDuration) {
        this.name = name;
        this.ramQuota = ramQuota;
        this.bucketType = bucketType;
        this.storageBackend = storageBackend;
        this.flushEnabled = flushEnabled;
        this.replicas = replicas;
        this.maximumExpiry = maximumExpiry;
        this.compressionMode = compressionMode;
        this.conflictResolutionType = conflictResolutionType;
        this.minimumDurability = minimumDurability;
        this.evictionPolicy = evictionPolicy;
        this.replicateViewIndexes = replicateViewIndexes;
        this.historyRetentionCollectionDefault = historyRetentionCollectionDefault;
        this.historyRetentionSize = historyRetentionSize;
        this.historyRetentionDuration = historyRetentionDuration;
        if (!(!(this.minimumDurability instanceof Durability.ClientVerified))) {
            boolean $i$a$-require-BucketSettings$32 = false;
            String $i$a$-require-BucketSettings$32 = "Minimum durability must not be client verified.";
            throw new IllegalArgumentException($i$a$-require-BucketSettings$32.toString());
        }
        if (!(!(this.maximumExpiry instanceof Expiry.Absolute))) {
            boolean bl = false;
            String string = "Maximum expiry must not be absolute -- use Expiry.none() or Expiry.of(Duration).";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final StorageSize getRamQuota() {
        return this.ramQuota;
    }

    @NotNull
    public final String getBucketType-_LoaUmE() {
        return this.bucketType;
    }

    @NotNull
    public final String getStorageBackend-HgnfZFs() {
        return this.storageBackend;
    }

    public final boolean getFlushEnabled() {
        return this.flushEnabled;
    }

    public final int getReplicas() {
        return this.replicas;
    }

    @NotNull
    public final Expiry getMaximumExpiry() {
        return this.maximumExpiry;
    }

    @NotNull
    public final String getCompressionMode-BKvunfc() {
        return this.compressionMode;
    }

    @NotNull
    public final String getConflictResolutionType-nji6rpM() {
        return this.conflictResolutionType;
    }

    @NotNull
    public final Durability getMinimumDurability() {
        return this.minimumDurability;
    }

    @NotNull
    public final String getEvictionPolicy-0CRHu3k() {
        return this.evictionPolicy;
    }

    @Nullable
    public final Boolean getReplicateViewIndexes() {
        return this.replicateViewIndexes;
    }

    @Nullable
    public final Boolean getHistoryRetentionCollectionDefault() {
        return this.historyRetentionCollectionDefault;
    }

    @Nullable
    public final StorageSize getHistoryRetentionSize() {
        return this.historyRetentionSize;
    }

    @Nullable
    public final Duration getHistoryRetentionDuration-FghU774() {
        return this.historyRetentionDuration;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BucketSettings(name='").append(this.name).append("', ramQuota=").append(this.ramQuota).append(", bucketType=").append((Object)BucketType.toString-impl(this.bucketType)).append(", storageBackend=").append((Object)StorageBackend.toString-impl(this.storageBackend)).append(", flushEnabled=").append(this.flushEnabled).append(", replicas=").append(this.replicas).append(", maximumExpiry=").append(this.maximumExpiry).append(", compressionMode=").append((Object)CompressionMode.toString-impl(this.compressionMode)).append(", conflictResolutionType=").append((Object)ConflictResolutionType.toString-impl(this.conflictResolutionType)).append(", minimumDurability=").append(this.minimumDurability).append(", evictionPolicy=").append((Object)EvictionPolicyType.toString-impl(this.evictionPolicy)).append(", replicateViewIndexes=");
        stringBuilder.append(this.replicateViewIndexes).append(", historyRetentionCollectionDefault=").append(this.historyRetentionCollectionDefault).append(", historyRetentionSize=").append(this.historyRetentionSize).append(", historyRetentionDuration=").append(this.historyRetentionDuration).append(')');
        return stringBuilder.toString();
    }

    public /* synthetic */ BucketSettings(String name, StorageSize ramQuota, String bucketType, String storageBackend, boolean flushEnabled, int replicas, Expiry maximumExpiry, String compressionMode, String conflictResolutionType, Durability minimumDurability, String evictionPolicy, Boolean replicateViewIndexes, Boolean historyRetentionCollectionDefault, StorageSize historyRetentionSize, Duration historyRetentionDuration, DefaultConstructorMarker $constructor_marker) {
        this(name, ramQuota, bucketType, storageBackend, flushEnabled, replicas, maximumExpiry, compressionMode, conflictResolutionType, minimumDurability, evictionPolicy, replicateViewIndexes, historyRetentionCollectionDefault, historyRetentionSize, historyRetentionDuration);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/couchbase/client/kotlin/manager/bucket/BucketSettings$Companion;", "", "()V", "fromJson", "Lcom/couchbase/client/kotlin/manager/bucket/BucketSettings;", "jsonBytes", "", "fromJson$kotlin_client", "kotlin-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BucketSettings fromJson$kotlin_client(@NotNull byte[] jsonBytes) {
            Duration duration;
            StorageSize storageSize;
            Intrinsics.checkNotNullParameter((Object)jsonBytes, (String)"jsonBytes");
            JsonNode json = Mapper.decodeIntoTree((byte[])jsonBytes);
            String string = json.get("name").textValue();
            boolean bl = !json.path("controllers").path("flush").isMissingNode();
            StorageSize.Companion companion = StorageSize.Companion;
            long $this$bytes$iv = json.path("quota").path("rawRAM").longValue();
            boolean $i$f$getBytes = false;
            StorageSize storageSize2 = new StorageSize($this$bytes$iv, StorageSizeUnit.BYTES).simplify$kotlin_client();
            int n = json.path("replicaNumber").intValue();
            long it = json.path("maxTTL").asLong();
            boolean bl2 = false;
            Expiry expiry = it == 0L ? Expiry.Companion.none() : Expiry.Companion.of-LRDsOJo(DurationKt.toDuration((long)it, (DurationUnit)DurationUnit.SECONDS));
            String string2 = json.path("compressionMode").asText(CompressionMode.Companion.getOFF-BKvunfc());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"json.path(\"compressionMo\u2026CompressionMode.OFF.name)");
            String string3 = CompressionMode.Companion.of-f1Fik4o(string2);
            String string4 = json.path("bucketType").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"json.path(\"bucketType\").asText()");
            String string5 = BucketType.Companion.of-ND5g760(string4);
            String string6 = json.path("conflictResolutionType").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"json.path(\"conflictResolutionType\").asText()");
            String string7 = ConflictResolutionType.Companion.of-8JJJEQI(string6);
            DurabilityLevel durabilityLevel = DurabilityLevel.decodeFromManagementApi((String)json.path("durabilityMinLevel").textValue());
            Intrinsics.checkNotNullExpressionValue((Object)durabilityLevel, (String)"decodeFromManagementApi(\u2026tyMinLevel\").textValue())");
            Durability durability = Durability.Companion.of$kotlin_client(durabilityLevel);
            String string8 = json.path("evictionPolicy").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"json.path(\"evictionPolicy\").asText()");
            String string9 = EvictionPolicyType.Companion.of-kg-6-4o(string8);
            String string10 = json.path("storageBackend").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"json.path(\"storageBackend\").asText()");
            String string11 = StorageBackend.Companion.of-LVunbCs(string10);
            JsonNode jsonNode = json.get("replicaIndex");
            Boolean bl3 = jsonNode != null ? Boolean.valueOf(jsonNode.booleanValue()) : null;
            JsonNode jsonNode2 = json.get("historyRetentionCollectionDefault");
            Boolean bl4 = jsonNode2 != null ? Boolean.valueOf(jsonNode2.booleanValue()) : null;
            JsonNode jsonNode3 = json.get("historyRetentionBytes");
            if (jsonNode3 != null) {
                long l = jsonNode3.longValue();
                StorageSize.Companion companion2 = StorageSize.Companion;
                long $this$bytes$iv2 = l;
                boolean $i$f$getBytes2 = false;
                storageSize = new StorageSize($this$bytes$iv2, StorageSizeUnit.BYTES).simplify$kotlin_client();
            } else {
                storageSize = null;
            }
            StorageSize storageSize3 = storageSize;
            JsonNode jsonNode4 = json.get("historyRetentionSeconds");
            if (jsonNode4 != null) {
                long l = jsonNode4.longValue();
                duration = Duration.box-impl((long)DurationKt.toDuration((long)l, (DurationUnit)DurationUnit.SECONDS));
            } else {
                duration = null;
            }
            Duration duration2 = duration;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textValue()");
            return new BucketSettings(string, storageSize2, string5, string11, bl, n, expiry, string3, string7, durability, string9, bl3, bl4, storageSize3, duration2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

