/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.http;

import com.couchbase.client.core.endpoint.http.CoreHttpResponse;
import com.couchbase.client.core.error.HttpStatusCodeException;
import com.couchbase.client.kotlin.internal.LangExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0010\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0019\u001a\u00020\u0010H\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lcom/couchbase/client/kotlin/http/CouchbaseHttpResponse;", "", "coreResponse", "Lcom/couchbase/client/core/endpoint/http/CoreHttpResponse;", "(Lcom/couchbase/client/core/endpoint/http/CoreHttpResponse;)V", "e", "Lcom/couchbase/client/core/error/HttpStatusCodeException;", "(Lcom/couchbase/client/core/error/HttpStatusCodeException;)V", "statusCode", "", "content", "", "(I[B)V", "getContent", "()[B", "contentAsString", "", "getContentAsString", "()Ljava/lang/String;", "getStatusCode", "()I", "success", "", "getSuccess", "()Z", "toString", "kotlin-client"})
public final class CouchbaseHttpResponse {
    private final int statusCode;
    @NotNull
    private final byte[] content;

    public CouchbaseHttpResponse(int statusCode, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.statusCode = statusCode;
        this.content = content;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    @NotNull
    public final byte[] getContent() {
        return this.content;
    }

    public final boolean getSuccess() {
        int n = this.statusCode;
        return 200 <= n ? n < 300 : false;
    }

    @NotNull
    public final String getContentAsString() {
        return LangExtensionsKt.toStringUtf8(this.content);
    }

    public CouchbaseHttpResponse(@NotNull CoreHttpResponse coreResponse) {
        Intrinsics.checkNotNullParameter((Object)coreResponse, (String)"coreResponse");
        int n = coreResponse.httpStatus();
        byte[] byArray = coreResponse.content();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"coreResponse.content()");
        this(n, byArray);
    }

    public CouchbaseHttpResponse(@NotNull HttpStatusCodeException e) {
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        int n = e.httpStatusCode();
        String string = e.content();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.content()");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this(n, byArray);
    }

    @NotNull
    public String toString() {
        return "CouchbaseHttpResponse(statusCode=" + this.statusCode + ", contentAsString=" + this.getContentAsString() + ')';
    }
}

