/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.search;

import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.kotlin.internal.LangExtensionsKt;
import com.couchbase.client.kotlin.search.BuiltQuery;
import com.couchbase.client.kotlin.search.ConjunctionQuery;
import com.couchbase.client.kotlin.search.DisjunctionQuery;
import com.couchbase.client.kotlin.search.GeoDistance;
import com.couchbase.client.kotlin.search.GeoPoint;
import com.couchbase.client.kotlin.search.GeoShape;
import com.couchbase.client.kotlin.search.SearchQuery;
import com.couchbase.client.kotlin.search.SearchQueryKt;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0004J#\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\bH \u00a2\u0006\u0002\b\nJ\u001b\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\fH\u0000\u00a2\u0006\u0002\b\rJ\b\u0010\u000e\u001a\u00020\tH\u0016\u0082\u0001\u0003\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery;", "", "()V", "boost", "", "inject", "", "json", "", "", "inject$kotlin_client", "toMap", "", "toMap$kotlin_client", "toString", "Companion", "Lcom/couchbase/client/kotlin/search/BuiltQuery;", "Lcom/couchbase/client/kotlin/search/ConjunctionQuery;", "Lcom/couchbase/client/kotlin/search/DisjunctionQuery;", "kotlin-client"})
public abstract class SearchQuery {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private SearchQuery() {
    }

    @NotNull
    public final SearchQuery boost(@NotNull Number boost2) {
        Intrinsics.checkNotNullParameter((Object)boost2, (String)"boost");
        return SearchQuery.Companion.build((Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(this, boost2){
            final /* synthetic */ SearchQuery this$0;
            final /* synthetic */ Number $boost;
            {
                this.this$0 = $receiver;
                this.$boost = $boost;
                super(1);
            }

            public final void invoke(@NotNull Map<String, Object> $this$build) {
                Intrinsics.checkNotNullParameter($this$build, (String)"$this$build");
                this.this$0.inject$kotlin_client($this$build);
                $this$build.put("boost", this.$boost);
            }
        }));
    }

    @NotNull
    public String toString() {
        String string = Mapper.encodeAsString(this.toMap$kotlin_client());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeAsString(toMap())");
        return string;
    }

    @NotNull
    public final Map<String, Object> toMap$kotlin_client() {
        Map map2 = new LinkedHashMap();
        this.inject$kotlin_client(map2);
        return map2;
    }

    public abstract void inject$kotlin_client(@NotNull Map<String, Object> var1);

    public /* synthetic */ SearchQuery(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0004\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001LB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bJ\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ/\u0010\u000f\u001a\u00020\u00042%\u0010\u0010\u001a!\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\u0002\b\u0014H\u0002J'\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00042\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0018\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0019J\u0014\u0010\u0015\u001a\u00020\u00062\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001bJ-\u0010\u001c\u001a\u00020\u00042%\u0010\u0010\u001a!\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\u0002\b\u0014J<\u0010\u001d\u001a\u00020\u00042\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\b\u0002\u0010 \u001a\u00020\f2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u001f2\b\b\u0002\u0010\"\u001a\u00020\fJ1\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u00042\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0018\"\u00020\u00042\b\b\u0002\u0010&\u001a\u00020'\u00a2\u0006\u0002\u0010(J\u001e\u0010#\u001a\u00020\b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b2\b\b\u0002\u0010&\u001a\u00020'J\u0014\u0010*\u001a\u00020\u00042\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001bJ \u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0018\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u0002032\b\b\u0002\u0010\r\u001a\u00020\u000eJB\u00104\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u000e2\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u00105\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u00106\u001a\u0002072\b\b\u0002\u00108\u001a\u00020'2\b\b\u0002\u00109\u001a\u00020'J\u0006\u0010:\u001a\u00020\u0004J\u0006\u0010;\u001a\u00020\u0004J$\u0010<\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u000e2\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u00105\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010=\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\u0004J<\u0010?\u001a\u00020\u00042\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010@2\b\b\u0002\u0010A\u001a\u00020\f2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010@2\b\b\u0002\u0010C\u001a\u00020\fJ\u001e\u0010D\u001a\u00020\u00042\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001b2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0018\u0010F\u001a\u00020\u00042\u0006\u0010F\u001a\u00020\u000e2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u000e\u0010G\u001a\u00020\u00042\u0006\u0010G\u001a\u00020\u000eJ\u0018\u0010H\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u000e2\b\b\u0002\u0010\r\u001a\u00020\u000eJ,\u0010I\u001a\u00020\u00042\u0006\u0010I\u001a\u00020\u000e2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u00108\u001a\u00020'2\b\b\u0002\u00109\u001a\u00020'J<\u0010J\u001a\u00020\u00042\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010A\u001a\u00020\f2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010C\u001a\u00020\fJ\u0018\u0010K\u001a\u00020\u00042\u0006\u0010I\u001a\u00020\u000e2\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a8\u0006M"}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion;", "", "()V", "boolean", "Lcom/couchbase/client/kotlin/search/SearchQuery;", "must", "Lcom/couchbase/client/kotlin/search/ConjunctionQuery;", "should", "Lcom/couchbase/client/kotlin/search/DisjunctionQuery;", "mustNot", "booleanField", "bool", "", "field", "", "build", "customizer", "Lkotlin/Function1;", "", "", "Lkotlin/ExtensionFunctionType;", "conjunction", "firstConjunct", "remainingConjuncts", "", "(Lcom/couchbase/client/kotlin/search/SearchQuery;[Lcom/couchbase/client/kotlin/search/SearchQuery;)Lcom/couchbase/client/kotlin/search/ConjunctionQuery;", "conjuncts", "", "custom", "dateRange", "start", "Ljava/time/Instant;", "inclusiveStart", "end", "inclusiveEnd", "disjunction", "firstDisjunct", "remainingDisjuncts", "min", "", "(Lcom/couchbase/client/kotlin/search/SearchQuery;[Lcom/couchbase/client/kotlin/search/SearchQuery;I)Lcom/couchbase/client/kotlin/search/DisjunctionQuery;", "disjuncts", "documentId", "ids", "geoDistance", "location", "Lcom/couchbase/client/kotlin/search/GeoPoint;", "distance", "Lcom/couchbase/client/kotlin/search/GeoDistance;", "geoShape", "shape", "Lcom/couchbase/client/kotlin/search/GeoShape;", "match", "analyzer", "operator", "Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchOperator;", "fuzziness", "prefixLength", "matchAll", "matchNone", "matchPhrase", "negation", "query", "numericRange", "", "inclusiveMin", "max", "inclusiveMax", "phrase", "terms", "prefix", "queryString", "regexp", "term", "termRange", "wildcard", "MatchOperator", "kotlin-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SearchQuery match(@NotNull String match2, @NotNull String field, @Nullable String analyzer, @NotNull MatchOperator operator, int fuzziness, int prefixLength) {
            Intrinsics.checkNotNullParameter((Object)match2, (String)"match");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
            return this.build((Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(field, match2, analyzer, fuzziness, prefixLength, operator){
                final /* synthetic */ String $field;
                final /* synthetic */ String $match;
                final /* synthetic */ String $analyzer;
                final /* synthetic */ int $fuzziness;
                final /* synthetic */ int $prefixLength;
                final /* synthetic */ MatchOperator $operator;
                {
                    this.$field = $field;
                    this.$match = $match;
                    this.$analyzer = $analyzer;
                    this.$fuzziness = $fuzziness;
                    this.$prefixLength = $prefixLength;
                    this.$operator = $operator;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, Object> $this$build) {
                    Intrinsics.checkNotNullParameter($this$build, (String)"$this$build");
                    SearchQueryKt.access$putField($this$build, this.$field);
                    $this$build.put("match", this.$match);
                    LangExtensionsKt.putIfNotNull($this$build, "analyzer", this.$analyzer);
                    LangExtensionsKt.putIfNotZero($this$build, "fuzziness", this.$fuzziness);
                    LangExtensionsKt.putIfNotZero($this$build, "prefix_length", this.$prefixLength);
                    if (this.$operator != MatchOperator.OR) {
                        $this$build.put("operator", this.$operator.getWireName$kotlin_client());
                    }
                }
            }));
        }

        public static /* synthetic */ SearchQuery match$default(Companion companion, String string, String string2, String string3, MatchOperator matchOperator, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                string2 = "_all";
            }
            if ((n3 & 4) != 0) {
                string3 = null;
            }
            if ((n3 & 8) != 0) {
                matchOperator = MatchOperator.OR;
            }
            if ((n3 & 0x10) != 0) {
                n = 0;
            }
            if ((n3 & 0x20) != 0) {
                n2 = 0;
            }
            return companion.match(string, string2, string3, matchOperator, n, n2);
        }

        @NotNull
        public final SearchQuery matchPhrase(@NotNull String matchPhrase2, @NotNull String field, @Nullable String analyzer) {
            Intrinsics.checkNotNullParameter((Object)matchPhrase2, (String)"matchPhrase");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return this.build((Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(field, matchPhrase2, analyzer){
                final /* synthetic */ String $field;
                final /* synthetic */ String $matchPhrase;
                final /* synthetic */ String $analyzer;
                {
                    this.$field = $field;
                    this.$matchPhrase = $matchPhrase;
                    this.$analyzer = $analyzer;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, Object> $this$build) {
                    Intrinsics.checkNotNullParameter($this$build, (String)"$this$build");
                    SearchQueryKt.access$putField($this$build, this.$field);
                    $this$build.put("match_phrase", this.$matchPhrase);
                    LangExtensionsKt.putIfNotNull($this$build, "analyzer", this.$analyzer);
                }
            }));
        }

        public static /* synthetic */ SearchQuery matchPhrase$default(Companion companion, String string, String string2, String string3, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "_all";
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            return companion.matchPhrase(string, string2, string3);
        }

        @NotNull
        public final SearchQuery term(@NotNull String term2, @NotNull String field, int fuzziness, int prefixLength) {
            Intrinsics.checkNotNullParameter((Object)term2, (String)"term");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return this.build((Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(field, term2, fuzziness, prefixLength){
                final /* synthetic */ String $field;
                final /* synthetic */ String $term;
                final /* synthetic */ int $fuzziness;
                final /* synthetic */ int $prefixLength;
                {
                    this.$field = $field;
                    this.$term = $term;
                    this.$fuzziness = $fuzziness;
                    this.$prefixLength = $prefixLength;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, Object> $this$build) {
                    Intrinsics.checkNotNullParameter($this$build, (String)"$this$build");
                    SearchQueryKt.access$putField($this$build, this.$field);
                    $this$build.put("term", this.$term);
                    LangExtensionsKt.putIfNotZero($this$build, "fuzziness", this.$fuzziness);
                    LangExtensionsKt.putIfNotZero($this$build, "prefix_length", this.$prefixLength);
                }
            }));
        }

        public static /* synthetic */ SearchQuery term$default(Companion companion, String string, String string2, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                string2 = "_all";
            }
            if ((n3 & 4) != 0) {
                n = 0;
            }
            if ((n3 & 8) != 0) {
                n2 = 0;
            }
            return companion.term(string, string2, n, n2);
        }

        @NotNull
        public final SearchQuery phrase(@NotNull List<String> terms, @NotNull String field) {
            Intrinsics.checkNotNullParameter(terms, (String)"terms");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            if (!(!((Collection)terms).isEmpty())) {
                boolean bl = false;
                String string = "Phrase query 'terms' must not be empty.";
                throw new IllegalArgumentException(string.toString());
            }
            return this.build((Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(field, terms){
                final /* synthetic */ String $field;
                final /* synthetic */ List<String> $terms;
                {
                    this.$field = $field;
                    this.$terms = $terms;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, Object> $this$build) {
                    Intrinsics.checkNotNullParameter($this$build, (String)"$this$build");
                    SearchQueryKt.access$putField($this$build, this.$field);
                    $this$build.put("terms", this.$terms);
                }
            }));
        }

        public static /* synthetic */ SearchQuery phrase$default(Companion companion, List list, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = "_all";
            }
            return companion.phrase(list, string);
        }

        @NotNull
        public final SearchQuery prefix(@NotNull String prefix2, @NotNull String field) {
            Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return this.build((Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(field, prefix2){
                final /* synthetic */ String $field;
                final /* synthetic */ String $prefix;
                {
                    this.$field = $field;
                    this.$prefix = $prefix;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, Object> $this$build) {
                    Intrinsics.checkNotNullParameter($this$build, (String)"$this$build");
                    SearchQueryKt.access$putField($this$build, this.$field);
                    $this$build.put("prefix", this.$prefix);
                }
            }));
        }

        public static /* synthetic */ SearchQuery prefix$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "_all";
            }
            return companion.prefix(string, string2);
        }

        @NotNull
        public final SearchQuery regexp(@NotNull String regexp2, @NotNull String field) {
            Intrinsics.checkNotNullParameter((Object)regexp2, (String)"regexp");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return this.build((Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(field, regexp2){
                final /* synthetic */ String $field;
                final /* synthetic */ String $regexp;
                {
                    this.$field = $field;
                    this.$regexp = $regexp;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, Object> $this$build) {
                    Intrinsics.checkNotNullParameter($this$build, (String)"$this$build");
                    SearchQueryKt.access$putField($this$build, this.$field);
                    $this$build.put("regexp", this.$regexp);
                }
            }));
        }

        public static /* synthetic */ SearchQuery regexp$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "_all";
            }
            return companion.regexp(string, string2);
        }

        @NotNull
        public final SearchQuery wildcard(@NotNull String term2, @NotNull String field) {
            Intrinsics.checkNotNullParameter((Object)term2, (String)"term");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return this.build((Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(term2, field){
                final /* synthetic */ String $term;
                final /* synthetic */ String $field;
                {
                    this.$term = $term;
                    this.$field = $field;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, Object> $this$build) {
                    Intrinsics.checkNotNullParameter($this$build, (String)"$this$build");
                    $this$build.put("wildcard", this.$term);
                    SearchQueryKt.access$putField($this$build, this.$field);
                }
            }));
        }

        public static /* synthetic */ SearchQuery wildcard$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "_all";
            }
            return companion.wildcard(string, string2);
        }

        @NotNull
        public final SearchQuery queryString(@NotNull String queryString2) {
            Intrinsics.checkNotNullParameter((Object)queryString2, (String)"queryString");
            return this.build((Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(queryString2){
                final /* synthetic */ String $queryString;
                {
                    this.$queryString = $queryString;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, Object> $this$build) {
                    Intrinsics.checkNotNullParameter($this$build, (String)"$this$build");
                    $this$build.put("query", this.$queryString);
                }
            }));
        }

        @NotNull
        public final SearchQuery booleanField(boolean bool, @NotNull String field) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return this.build((Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(bool, field){
                final /* synthetic */ boolean $bool;
                final /* synthetic */ String $field;
                {
                    this.$bool = $bool;
                    this.$field = $field;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, Object> $this$build) {
                    Intrinsics.checkNotNullParameter($this$build, (String)"$this$build");
                    $this$build.put("bool", this.$bool);
                    SearchQueryKt.access$putField($this$build, this.$field);
                }
            }));
        }

        @NotNull
        public final SearchQuery documentId(@NotNull List<String> ids) {
            Intrinsics.checkNotNullParameter(ids, (String)"ids");
            if (!(!((Collection)ids).isEmpty())) {
                boolean bl = false;
                String string = "Document ID query 'ids' must not be empty.";
                throw new IllegalArgumentException(string.toString());
            }
            return this.build((Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(ids){
                final /* synthetic */ List<String> $ids;
                {
                    this.$ids = $ids;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, Object> $this$build) {
                    Intrinsics.checkNotNullParameter($this$build, (String)"$this$build");
                    $this$build.put("ids", this.$ids);
                }
            }));
        }

        @NotNull
        public final SearchQuery termRange(@NotNull String field, @Nullable String min, boolean inclusiveMin, @Nullable String max, boolean inclusiveMax) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            if (!(min != null || max != null)) {
                boolean bl = false;
                String string = "Term range query needs at least one of 'min' or 'max'.";
                throw new IllegalArgumentException(string.toString());
            }
            return this.build((Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(min, inclusiveMin, max, inclusiveMax, field){
                final /* synthetic */ String $min;
                final /* synthetic */ boolean $inclusiveMin;
                final /* synthetic */ String $max;
                final /* synthetic */ boolean $inclusiveMax;
                final /* synthetic */ String $field;
                {
                    this.$min = $min;
                    this.$inclusiveMin = $inclusiveMin;
                    this.$max = $max;
                    this.$inclusiveMax = $inclusiveMax;
                    this.$field = $field;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, Object> $this$build) {
                    Intrinsics.checkNotNullParameter($this$build, (String)"$this$build");
                    LangExtensionsKt.putIfNotNull($this$build, "min", this.$min);
                    LangExtensionsKt.putIfFalse($this$build, "inclusive_min", this.$inclusiveMin);
                    LangExtensionsKt.putIfNotNull($this$build, "max", this.$max);
                    LangExtensionsKt.putIfTrue($this$build, "inclusive_max", this.$inclusiveMax);
                    SearchQueryKt.access$putField($this$build, this.$field);
                }
            }));
        }

        public static /* synthetic */ SearchQuery termRange$default(Companion companion, String string, String string2, boolean bl, String string3, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                string = "_all";
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            return companion.termRange(string, string2, bl, string3, bl2);
        }

        @NotNull
        public final SearchQuery numericRange(@NotNull String field, @Nullable Number min, boolean inclusiveMin, @Nullable Number max, boolean inclusiveMax) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            if (!(min != null || max != null)) {
                boolean bl = false;
                String string = "Numeric range query needs at least one of 'min' or 'max'.";
                throw new IllegalArgumentException(string.toString());
            }
            return this.build((Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(min, inclusiveMin, max, inclusiveMax, field){
                final /* synthetic */ Number $min;
                final /* synthetic */ boolean $inclusiveMin;
                final /* synthetic */ Number $max;
                final /* synthetic */ boolean $inclusiveMax;
                final /* synthetic */ String $field;
                {
                    this.$min = $min;
                    this.$inclusiveMin = $inclusiveMin;
                    this.$max = $max;
                    this.$inclusiveMax = $inclusiveMax;
                    this.$field = $field;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, Object> $this$build) {
                    Intrinsics.checkNotNullParameter($this$build, (String)"$this$build");
                    LangExtensionsKt.putIfNotNull($this$build, "min", this.$min);
                    LangExtensionsKt.putIfFalse($this$build, "inclusive_min", this.$inclusiveMin);
                    LangExtensionsKt.putIfNotNull($this$build, "max", this.$max);
                    LangExtensionsKt.putIfTrue($this$build, "inclusive_max", this.$inclusiveMax);
                    SearchQueryKt.access$putField($this$build, this.$field);
                }
            }));
        }

        public static /* synthetic */ SearchQuery numericRange$default(Companion companion, String string, Number number, boolean bl, Number number2, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                string = "_all";
            }
            if ((n & 2) != 0) {
                number = null;
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                number2 = null;
            }
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            return companion.numericRange(string, number, bl, number2, bl2);
        }

        @NotNull
        public final SearchQuery dateRange(@NotNull String field, @Nullable Instant start, boolean inclusiveStart, @Nullable Instant end, boolean inclusiveEnd) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            if (!(start != null || end != null)) {
                boolean bl = false;
                String string = "Date range query needs at least one of 'start' or 'end'.";
                throw new IllegalArgumentException(string.toString());
            }
            return this.build((Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(start, inclusiveStart, end, inclusiveEnd, field){
                final /* synthetic */ Instant $start;
                final /* synthetic */ boolean $inclusiveStart;
                final /* synthetic */ Instant $end;
                final /* synthetic */ boolean $inclusiveEnd;
                final /* synthetic */ String $field;
                {
                    this.$start = $start;
                    this.$inclusiveStart = $inclusiveStart;
                    this.$end = $end;
                    this.$inclusiveEnd = $inclusiveEnd;
                    this.$field = $field;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, Object> $this$build) {
                    Intrinsics.checkNotNullParameter($this$build, (String)"$this$build");
                    Instant instant = this.$start;
                    LangExtensionsKt.putIfNotNull($this$build, "start", instant != null ? instant.toString() : null);
                    LangExtensionsKt.putIfFalse($this$build, "inclusive_start", this.$inclusiveStart);
                    Instant instant2 = this.$end;
                    LangExtensionsKt.putIfNotNull($this$build, "end", instant2 != null ? instant2.toString() : null);
                    LangExtensionsKt.putIfTrue($this$build, "inclusive_end", this.$inclusiveEnd);
                    SearchQueryKt.access$putField($this$build, this.$field);
                }
            }));
        }

        public static /* synthetic */ SearchQuery dateRange$default(Companion companion, String string, Instant instant, boolean bl, Instant instant2, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                string = "_all";
            }
            if ((n & 2) != 0) {
                instant = null;
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                instant2 = null;
            }
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            return companion.dateRange(string, instant, bl, instant2, bl2);
        }

        @NotNull
        public final SearchQuery geoDistance(@NotNull GeoPoint location, @NotNull GeoDistance distance, @NotNull String field) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)distance, (String)"distance");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return this.geoShape(GeoShape.Companion.circle(location, distance), field);
        }

        public static /* synthetic */ SearchQuery geoDistance$default(Companion companion, GeoPoint geoPoint, GeoDistance geoDistance, String string, int n, Object object) {
            if ((n & 4) != 0) {
                string = "_all";
            }
            return companion.geoDistance(geoPoint, geoDistance, string);
        }

        @NotNull
        public final SearchQuery geoShape(@NotNull GeoShape shape, @NotNull String field) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return this.build((Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(shape, field){
                final /* synthetic */ GeoShape $shape;
                final /* synthetic */ String $field;
                {
                    this.$shape = $shape;
                    this.$field = $field;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, Object> $this$build) {
                    Intrinsics.checkNotNullParameter($this$build, (String)"$this$build");
                    this.$shape.inject$kotlin_client($this$build);
                    SearchQueryKt.access$putField($this$build, this.$field);
                }
            }));
        }

        public static /* synthetic */ SearchQuery geoShape$default(Companion companion, GeoShape geoShape2, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = "_all";
            }
            return companion.geoShape(geoShape2, string);
        }

        @NotNull
        public final SearchQuery negation(@NotNull SearchQuery query2) {
            Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
            return com.couchbase.client.kotlin.search.SearchQuery$Companion.boolean$default(this, null, null, com.couchbase.client.kotlin.search.SearchQuery$Companion.disjunction$default(this, query2, new SearchQuery[0], 0, 4, null), 3, null);
        }

        @NotNull
        public final ConjunctionQuery conjunction(@NotNull SearchQuery firstConjunct, SearchQuery ... remainingConjuncts) {
            Intrinsics.checkNotNullParameter((Object)firstConjunct, (String)"firstConjunct");
            Intrinsics.checkNotNullParameter((Object)remainingConjuncts, (String)"remainingConjuncts");
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)firstConjunct);
            spreadBuilder.addSpread((Object)remainingConjuncts);
            return this.conjunction(CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new SearchQuery[spreadBuilder.size()])));
        }

        @NotNull
        public final ConjunctionQuery conjunction(@NotNull List<? extends SearchQuery> conjuncts) {
            Intrinsics.checkNotNullParameter(conjuncts, (String)"conjuncts");
            return new ConjunctionQuery(conjuncts);
        }

        @NotNull
        public final DisjunctionQuery disjunction(@NotNull SearchQuery firstDisjunct, @NotNull SearchQuery[] remainingDisjuncts, int min) {
            Intrinsics.checkNotNullParameter((Object)firstDisjunct, (String)"firstDisjunct");
            Intrinsics.checkNotNullParameter((Object)remainingDisjuncts, (String)"remainingDisjuncts");
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)firstDisjunct);
            spreadBuilder.addSpread((Object)remainingDisjuncts);
            return this.disjunction(CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new SearchQuery[spreadBuilder.size()])), min);
        }

        public static /* synthetic */ DisjunctionQuery disjunction$default(Companion companion, SearchQuery searchQuery2, SearchQuery[] searchQueryArray, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 1;
            }
            return companion.disjunction(searchQuery2, searchQueryArray, n);
        }

        @NotNull
        public final DisjunctionQuery disjunction(@NotNull List<? extends SearchQuery> disjuncts, int min) {
            Intrinsics.checkNotNullParameter(disjuncts, (String)"disjuncts");
            return new DisjunctionQuery(disjuncts, min);
        }

        public static /* synthetic */ DisjunctionQuery disjunction$default(Companion companion, List list, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 1;
            }
            return companion.disjunction(list, n);
        }

        @NotNull
        public final SearchQuery boolean(@Nullable ConjunctionQuery must, @Nullable DisjunctionQuery should, @Nullable DisjunctionQuery mustNot) {
            if (!(must != null || should != null || mustNot != null)) {
                boolean bl = false;
                String string = "Boolean query must have at least one of 'must', 'should', or 'mustNot'.";
                throw new IllegalArgumentException(string.toString());
            }
            return this.build((Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(must, should, mustNot){
                final /* synthetic */ ConjunctionQuery $must;
                final /* synthetic */ DisjunctionQuery $should;
                final /* synthetic */ DisjunctionQuery $mustNot;
                {
                    this.$must = $must;
                    this.$should = $should;
                    this.$mustNot = $mustNot;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, Object> $this$build) {
                    Intrinsics.checkNotNullParameter($this$build, (String)"$this$build");
                    ConjunctionQuery conjunctionQuery = this.$must;
                    LangExtensionsKt.putIfNotNull($this$build, "must", conjunctionQuery != null ? conjunctionQuery.toMap$kotlin_client() : null);
                    DisjunctionQuery disjunctionQuery = this.$should;
                    LangExtensionsKt.putIfNotNull($this$build, "should", disjunctionQuery != null ? disjunctionQuery.toMap$kotlin_client() : null);
                    DisjunctionQuery disjunctionQuery2 = this.$mustNot;
                    LangExtensionsKt.putIfNotNull($this$build, "must_not", disjunctionQuery2 != null ? disjunctionQuery2.toMap$kotlin_client() : null);
                }
            }));
        }

        public static /* synthetic */ SearchQuery boolean$default(Companion companion, ConjunctionQuery conjunctionQuery, DisjunctionQuery disjunctionQuery, DisjunctionQuery disjunctionQuery2, int n, Object object) {
            if ((n & 1) != 0) {
                conjunctionQuery = null;
            }
            if ((n & 2) != 0) {
                disjunctionQuery = null;
            }
            if ((n & 4) != 0) {
                disjunctionQuery2 = null;
            }
            return companion.boolean(conjunctionQuery, disjunctionQuery, disjunctionQuery2);
        }

        @NotNull
        public final SearchQuery matchAll() {
            return this.build((Function1<? super Map<String, Object>, Unit>)((Function1)matchAll.1.INSTANCE));
        }

        @NotNull
        public final SearchQuery matchNone() {
            return this.build((Function1<? super Map<String, Object>, Unit>)((Function1)matchNone.1.INSTANCE));
        }

        @NotNull
        public final SearchQuery custom(@NotNull Function1<? super Map<String, Object>, Unit> customizer) {
            Intrinsics.checkNotNullParameter(customizer, (String)"customizer");
            return this.build(customizer);
        }

        private final SearchQuery build(Function1<? super Map<String, Object>, Unit> customizer) {
            return new BuiltQuery(customizer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/couchbase/client/kotlin/search/SearchQuery$Companion$MatchOperator;", "", "(Ljava/lang/String;I)V", "wireName", "", "getWireName$kotlin_client", "()Ljava/lang/String;", "AND", "OR", "kotlin-client"})
        public static final class MatchOperator
        extends Enum<MatchOperator> {
            @NotNull
            private final String wireName;
            public static final /* enum */ MatchOperator AND = new MatchOperator();
            public static final /* enum */ MatchOperator OR = new MatchOperator();
            private static final /* synthetic */ MatchOperator[] $VALUES;

            private MatchOperator() {
                String string = this.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                this.wireName = string;
            }

            @NotNull
            public final String getWireName$kotlin_client() {
                return this.wireName;
            }

            public static MatchOperator[] values() {
                return (MatchOperator[])$VALUES.clone();
            }

            public static MatchOperator valueOf(String value2) {
                return Enum.valueOf(MatchOperator.class, value2);
            }

            static {
                $VALUES = matchOperatorArray = new MatchOperator[]{MatchOperator.AND, MatchOperator.OR};
            }
        }
    }
}

