/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.internal;

import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.client.kotlin.internal.LangExtensionsKt;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u001a#\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001*\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004\u001a \u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\n\b\u0000\u0010\u0006\u0018\u0001*\u00020\u0007*\u00020\u0007H\u0080\b\u00a2\u0006\u0002\u0010\b\u001a\u0019\u0010\t\u001a\u00020\n\"\n\b\u0000\u0010\u0006\u0018\u0001*\u00020\u0007*\u00020\u0007H\u0080\b\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0000\u001a3\u0010\u000e\u001a\u00020\n\"\u000e\b\u0000\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u000f0\u0010*\u0004\u0018\u0001H\u000f2\u0006\u0010\u0011\u001a\u0002H\u000f2\u0006\u0010\u0012\u001a\u0002H\u000fH\u0000\u00a2\u0006\u0002\u0010\u0013\u001a\u0010\u0010\u0014\u001a\u00020\n*\u0006\u0012\u0002\b\u00030\u0015H\u0000\u001a*\u0010\u0016\u001a\u00020\u0017*\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\nH\u0000\u001a.\u0010\u001c\u001a\u00020\u0017*\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\u0006\u0010\u001a\u001a\u00020\f2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0000\u001a2\u0010\u001c\u001a\u00020\u0017*\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\u0006\u0010\u001a\u001a\u00020\f2\u000e\u0010\u001b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001eH\u0000\u001a,\u0010\u001f\u001a\u00020\u0017*\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\u0006\u0010\u001a\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0019H\u0000\u001a*\u0010 \u001a\u00020\u0017*\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020!H\u0000\u001a*\u0010\"\u001a\u00020\u0017*\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\nH\u0000\u001a\u0016\u0010#\u001a\u00020\f*\u00020$2\b\b\u0002\u0010%\u001a\u00020!H\u0000\u001a\u001f\u0010&\u001a\b\u0012\u0004\u0012\u0002H\u00060'\"\u0004\b\u0000\u0010\u0006*\u0004\u0018\u0001H\u0006H\u0000\u00a2\u0006\u0002\u0010(\u001a\f\u0010)\u001a\u00020!*\u00020*H\u0000\u001a\f\u0010+\u001a\u00020\f*\u00020\rH\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006,"}, d2={"await", "Ljava/lang/Void;", "kotlin.jvm.PlatformType", "Lreactor/core/publisher/Mono;", "(Lreactor/core/publisher/Mono;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findCause", "T", "", "(Ljava/lang/Throwable;)Ljava/lang/Throwable;", "hasCause", "", "hexContentToString", "", "", "isAnyOf", "E", "", "a", "b", "(Ljava/lang/Enum;Ljava/lang/Enum;Ljava/lang/Enum;)Z", "isEmpty", "", "putIfFalse", "", "", "", "key", "value", "putIfNotEmpty", "", "", "putIfNotNull", "putIfNotZero", "", "putIfTrue", "toHexString", "", "pad", "toOptional", "Ljava/util/Optional;", "(Ljava/lang/Object;)Ljava/util/Optional;", "toSaturatedInt", "", "toStringUtf8", "kotlin-client"})
public final class LangExtensionsKt {
    @NotNull
    public static final String toStringUtf8(@NotNull byte[] $this$toStringUtf8) {
        Intrinsics.checkNotNullParameter((Object)$this$toStringUtf8, (String)"<this>");
        byte[] byArray = $this$toStringUtf8;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return new String(byArray, charset2);
    }

    @NotNull
    public static final String hexContentToString(@NotNull byte[] $this$hexContentToString) {
        Intrinsics.checkNotNullParameter((Object)$this$hexContentToString, (String)"<this>");
        return '[' + ArraysKt.joinToString$default((byte[])$this$hexContentToString, null, null, null, (int)0, null, (Function1)hexContentToString.1.INSTANCE, (int)31, null) + ']';
    }

    @NotNull
    public static final String toHexString(byte $this$toHexString, int pad) {
        return StringsKt.padStart((String)UStringsKt.toString-LxnNnR4((byte)UByte.constructor-impl((byte)$this$toHexString), (int)16), (int)pad, (char)'0');
    }

    public static /* synthetic */ String toHexString$default(byte by, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        return LangExtensionsKt.toHexString(by, n);
    }

    public static final int toSaturatedInt(long $this$toSaturatedInt) {
        return (int)RangesKt.coerceIn((long)$this$toSaturatedInt, (long)Integer.MIN_VALUE, (long)Integer.MAX_VALUE);
    }

    public static final boolean isEmpty(@NotNull Iterable<?> $this$isEmpty) {
        Intrinsics.checkNotNullParameter($this$isEmpty, (String)"<this>");
        return !$this$isEmpty.iterator().hasNext();
    }

    @NotNull
    public static final <T> Optional<T> toOptional(@Nullable T $this$toOptional) {
        Optional<T> optional = Optional.ofNullable($this$toOptional);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(this)");
        return optional;
    }

    @Nullable
    public static final Object await(@NotNull Mono<Void> $this$await, @NotNull Continuation<? super Void> $completion) {
        CompletableFuture completableFuture = $this$await.toFuture();
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"toFuture()");
        return FutureKt.await((CompletionStage)completableFuture, $completion);
    }

    public static final void putIfNotEmpty(@NotNull Map<String, Object> $this$putIfNotEmpty, @NotNull String key, @NotNull Collection<?> value2) {
        Intrinsics.checkNotNullParameter($this$putIfNotEmpty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        if (!value2.isEmpty()) {
            $this$putIfNotEmpty.put(key, value2);
        }
    }

    public static final void putIfNotEmpty(@NotNull Map<String, Object> $this$putIfNotEmpty, @NotNull String key, @NotNull Map<?, ?> value2) {
        Intrinsics.checkNotNullParameter($this$putIfNotEmpty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        if (!value2.isEmpty()) {
            $this$putIfNotEmpty.put(key, value2);
        }
    }

    public static final void putIfTrue(@NotNull Map<String, Object> $this$putIfTrue, @NotNull String key, boolean value2) {
        Intrinsics.checkNotNullParameter($this$putIfTrue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value2) {
            $this$putIfTrue.put(key, true);
        }
    }

    public static final void putIfFalse(@NotNull Map<String, Object> $this$putIfFalse, @NotNull String key, boolean value2) {
        Intrinsics.checkNotNullParameter($this$putIfFalse, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!value2) {
            $this$putIfFalse.put(key, false);
        }
    }

    public static final void putIfNotNull(@NotNull Map<String, Object> $this$putIfNotNull, @NotNull String key, @Nullable Object value2) {
        Intrinsics.checkNotNullParameter($this$putIfNotNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value2 != null) {
            $this$putIfNotNull.put(key, value2);
        }
    }

    public static final void putIfNotZero(@NotNull Map<String, Object> $this$putIfNotZero, @NotNull String key, int value2) {
        Intrinsics.checkNotNullParameter($this$putIfNotZero, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value2 != 0) {
            $this$putIfNotZero.put(key, value2);
        }
    }

    public static final /* synthetic */ <T extends Throwable> T findCause(Throwable $this$findCause) {
        Intrinsics.checkNotNullParameter((Object)$this$findCause, (String)"<this>");
        boolean $i$f$findCause = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)((Throwable)CbThrowables.findCause((Throwable)$this$findCause, Throwable.class).orElse(null));
    }

    public static final /* synthetic */ <T extends Throwable> boolean hasCause(Throwable $this$hasCause) {
        Intrinsics.checkNotNullParameter((Object)$this$hasCause, (String)"<this>");
        boolean $i$f$hasCause = false;
        Throwable $this$findCause$iv = $this$hasCause;
        boolean $i$f$findCause = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (Throwable)CbThrowables.findCause((Throwable)$this$findCause$iv, Throwable.class).orElse(null) != null;
    }

    public static final <E extends Enum<E>> boolean isAnyOf(@Nullable E $this$isAnyOf, @NotNull E a, @NotNull E b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        return Intrinsics.areEqual(a, $this$isAnyOf) || Intrinsics.areEqual(b, $this$isAnyOf);
    }
}

