/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.analytics;

import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.error.ErrorCodeAndMessage;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkHeader;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkTrailer;
import com.couchbase.client.kotlin.analytics.AnalyticsFlowItem;
import com.couchbase.client.kotlin.analytics.AnalyticsFlowItemKt;
import com.couchbase.client.kotlin.analytics.AnalyticsMetrics;
import com.couchbase.client.kotlin.analytics.AnalyticsStatus;
import com.couchbase.client.kotlin.analytics.AnalyticsWarning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001f\u001a\u00020\bH\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR!\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/couchbase/client/kotlin/analytics/AnalyticsMetadata;", "Lcom/couchbase/client/kotlin/analytics/AnalyticsFlowItem;", "header", "Lcom/couchbase/client/core/msg/analytics/AnalyticsChunkHeader;", "trailer", "Lcom/couchbase/client/core/msg/analytics/AnalyticsChunkTrailer;", "(Lcom/couchbase/client/core/msg/analytics/AnalyticsChunkHeader;Lcom/couchbase/client/core/msg/analytics/AnalyticsChunkTrailer;)V", "clientContextId", "", "getClientContextId", "()Ljava/lang/String;", "metrics", "Lcom/couchbase/client/kotlin/analytics/AnalyticsMetrics;", "getMetrics", "()Lcom/couchbase/client/kotlin/analytics/AnalyticsMetrics;", "requestId", "getRequestId", "signature", "", "", "getSignature", "()Ljava/util/Map;", "status", "Lcom/couchbase/client/kotlin/analytics/AnalyticsStatus;", "getStatus", "()Lcom/couchbase/client/kotlin/analytics/AnalyticsStatus;", "warnings", "", "Lcom/couchbase/client/kotlin/analytics/AnalyticsWarning;", "getWarnings", "()Ljava/util/List;", "toString", "kotlin-client"})
public final class AnalyticsMetadata
extends AnalyticsFlowItem {
    @NotNull
    private final AnalyticsChunkHeader header;
    @NotNull
    private final AnalyticsChunkTrailer trailer;

    public AnalyticsMetadata(@NotNull AnalyticsChunkHeader header, @NotNull AnalyticsChunkTrailer trailer) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)trailer, (String)"trailer");
        super(null);
        this.header = header;
        this.trailer = trailer;
    }

    @NotNull
    public final String getRequestId() {
        String string = this.header.requestId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"header.requestId()");
        return string;
    }

    @NotNull
    public final String getClientContextId() {
        String string = this.header.clientContextId().orElse("");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"header.clientContextId().orElse(\"\")");
        return string;
    }

    @NotNull
    public final AnalyticsStatus getStatus() {
        String string = this.trailer.status();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trailer.status()");
        return AnalyticsStatus.Companion.from(string);
    }

    @Nullable
    public final Map<String, Object> getSignature() {
        Optional optional = this.header.signature();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"header.signature()");
        return AnalyticsFlowItemKt.access$parseAsMap(optional).orElse(null);
    }

    @NotNull
    public final AnalyticsMetrics getMetrics() {
        Object object = Mapper.decodeInto((byte[])this.trailer.metrics(), (TypeReference)AnalyticsFlowItemKt.access$getMAP_TYPE_REF$p());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"decodeInto(trailer.metrics(), MAP_TYPE_REF)");
        return new AnalyticsMetrics((Map)object);
    }

    @NotNull
    public final List<AnalyticsWarning> getWarnings() {
        List list = this.trailer.warnings().map(AnalyticsMetadata::_get_warnings_$lambda-1).orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"trailer.warnings().map {\u2026    }.orElse(emptyList())");
        return list;
    }

    @NotNull
    public String toString() {
        return "AnalyticsMetadata(requestId='" + this.getRequestId() + "', clientContextId='" + this.getClientContextId() + "', status=" + (Object)((Object)this.getStatus()) + ", signature=" + this.getSignature() + ", metrics=" + this.getMetrics() + ", warnings=" + this.getWarnings() + ')';
    }

    /*
     * WARNING - void declaration
     */
    private static final List _get_warnings_$lambda-1(byte[] warnings) {
        void $this$mapTo$iv$iv;
        List list = ErrorCodeAndMessage.fromJsonArray((byte[])warnings);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fromJsonArray(warnings)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ErrorCodeAndMessage errorCodeAndMessage = (ErrorCodeAndMessage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int n = it.code();
            String string = it.message();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.message()");
            collection.add(new AnalyticsWarning(n, string));
        }
        return (List)destination$iv$iv;
    }
}

