/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.diagnostics;

import com.couchbase.client.core.endpoint.EndpointState;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001b\u001a\u00020\u0006H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\n\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001c"}, d2={"Lcom/couchbase/client/kotlin/diagnostics/EndpointDiagnostics;", "", "core", "Lcom/couchbase/client/core/diagnostics/EndpointDiagnostics;", "(Lcom/couchbase/client/core/diagnostics/EndpointDiagnostics;)V", "id", "", "getId", "()Ljava/lang/String;", "lastActivity", "Lkotlin/time/Duration;", "getLastActivity-FghU774", "()Lkotlin/time/Duration;", "local", "getLocal", "namespace", "getNamespace", "remote", "getRemote", "state", "Lcom/couchbase/client/core/endpoint/EndpointState;", "getState", "()Lcom/couchbase/client/core/endpoint/EndpointState;", "type", "Lcom/couchbase/client/core/service/ServiceType;", "getType", "()Lcom/couchbase/client/core/service/ServiceType;", "toString", "kotlin-client"})
public final class EndpointDiagnostics {
    @NotNull
    private final ServiceType type;
    @NotNull
    private final EndpointState state;
    @Nullable
    private final String local;
    @Nullable
    private final String remote;
    @Nullable
    private final String namespace;
    @Nullable
    private final kotlin.time.Duration lastActivity;
    @Nullable
    private final String id;

    public EndpointDiagnostics(@NotNull com.couchbase.client.core.diagnostics.EndpointDiagnostics core) {
        Intrinsics.checkNotNullParameter((Object)core, (String)"core");
        ServiceType serviceType = core.type();
        Intrinsics.checkNotNullExpressionValue((Object)serviceType, (String)"core.type()");
        this.type = serviceType;
        EndpointState endpointState = core.state();
        Intrinsics.checkNotNullExpressionValue((Object)endpointState, (String)"core.state()");
        this.state = endpointState;
        this.local = core.local();
        this.remote = core.remote();
        this.namespace = core.namespace().orElse(null);
        this.lastActivity = core.lastActivity().map(EndpointDiagnostics::lastActivity$lambda-0).orElse(null);
        this.id = core.id().orElse(null);
    }

    @NotNull
    public final ServiceType getType() {
        return this.type;
    }

    @NotNull
    public final EndpointState getState() {
        return this.state;
    }

    @Nullable
    public final String getLocal() {
        return this.local;
    }

    @Nullable
    public final String getRemote() {
        return this.remote;
    }

    @Nullable
    public final String getNamespace() {
        return this.namespace;
    }

    @Nullable
    public final kotlin.time.Duration getLastActivity-FghU774() {
        return this.lastActivity;
    }

    @Nullable
    public final String getId() {
        return this.id;
    }

    @NotNull
    public String toString() {
        return "EndpointDiagnostics(type=" + this.type + ", state=" + this.state + ", local=" + this.local + ", remote=" + this.remote + ", namespace=" + this.namespace + ", lastActivity=" + this.lastActivity + ", id=" + this.id + ')';
    }

    private static final kotlin.time.Duration lastActivity$lambda-0(Duration it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        Duration duration = it;
        return kotlin.time.Duration.box-impl((long)kotlin.time.Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration.getNano(), (DurationUnit)DurationUnit.NANOSECONDS)));
    }
}

