/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.kotlin.Bucket;
import com.couchbase.client.kotlin.Collection;
import com.couchbase.client.kotlin.CommonOptions;
import com.couchbase.client.kotlin.analytics.AnalyticsFlowItem;
import com.couchbase.client.kotlin.analytics.AnalyticsParameters;
import com.couchbase.client.kotlin.analytics.AnalyticsPriority;
import com.couchbase.client.kotlin.analytics.AnalyticsScanConsistency;
import com.couchbase.client.kotlin.analytics.internal.AnalyticsExecutor;
import com.couchbase.client.kotlin.codec.JsonSerializer;
import com.couchbase.client.kotlin.internal.LangExtensionsKt;
import com.couchbase.client.kotlin.query.QueryFlowItem;
import com.couchbase.client.kotlin.query.QueryParameters;
import com.couchbase.client.kotlin.query.QueryProfile;
import com.couchbase.client.kotlin.query.QueryScanConsistency;
import com.couchbase.client.kotlin.query.internal.QueryExecutor;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006Jv\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\b\u0002\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u00032\u0016\b\u0002\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010(J\u000e\u0010)\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003J\u00d3\u0001\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u00172\u0006\u0010\u0019\u001a\u00020\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020#2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\b\u0002\u0010 \u001a\u00020.2\b\b\u0002\u0010\"\u001a\u00020#2\b\b\u0002\u0010/\u001a\u00020#2\b\b\u0002\u00100\u001a\u00020#2\b\b\u0002\u00101\u001a\u00020#2\b\b\u0002\u00102\u001a\u0002032\n\b\u0002\u00104\u001a\u0004\u0018\u0001052\n\b\u0002\u00106\u001a\u0004\u0018\u0001052\n\b\u0002\u00107\u001a\u0004\u0018\u0001052\n\b\u0002\u00108\u001a\u0004\u0018\u0001052\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u00032\u0016\b\u0002\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010(\u00a2\u0006\u0002\u00109R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/couchbase/client/kotlin/Scope;", "", "name", "", "bucket", "Lcom/couchbase/client/kotlin/Bucket;", "(Ljava/lang/String;Lcom/couchbase/client/kotlin/Bucket;)V", "analyticsExecutor", "Lcom/couchbase/client/kotlin/analytics/internal/AnalyticsExecutor;", "getBucket", "()Lcom/couchbase/client/kotlin/Bucket;", "collectionCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/couchbase/client/kotlin/Collection;", "core", "Lcom/couchbase/client/core/Core;", "getCore$kotlin_client", "()Lcom/couchbase/client/core/Core;", "getName", "()Ljava/lang/String;", "queryExecutor", "Lcom/couchbase/client/kotlin/query/internal/QueryExecutor;", "analyticsQuery", "Lkotlinx/coroutines/flow/Flow;", "Lcom/couchbase/client/kotlin/analytics/AnalyticsFlowItem;", "statement", "common", "Lcom/couchbase/client/kotlin/CommonOptions;", "parameters", "Lcom/couchbase/client/kotlin/analytics/AnalyticsParameters;", "serializer", "Lcom/couchbase/client/kotlin/codec/JsonSerializer;", "consistency", "Lcom/couchbase/client/kotlin/analytics/AnalyticsScanConsistency;", "readonly", "", "priority", "Lcom/couchbase/client/kotlin/analytics/AnalyticsPriority;", "clientContextId", "raw", "", "collection", "query", "Lcom/couchbase/client/kotlin/query/QueryFlowItem;", "Lcom/couchbase/client/kotlin/query/QueryParameters;", "preserveExpiry", "Lcom/couchbase/client/kotlin/query/QueryScanConsistency;", "adhoc", "flexIndex", "metrics", "profile", "Lcom/couchbase/client/kotlin/query/QueryProfile;", "maxParallelism", "", "scanCap", "pipelineBatch", "pipelineCap", "(Ljava/lang/String;Lcom/couchbase/client/kotlin/CommonOptions;Lcom/couchbase/client/kotlin/query/QueryParameters;ZLcom/couchbase/client/kotlin/codec/JsonSerializer;Lcom/couchbase/client/kotlin/query/QueryScanConsistency;ZZZZLcom/couchbase/client/kotlin/query/QueryProfile;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/util/Map;)Lkotlinx/coroutines/flow/Flow;", "kotlin-client"})
public final class Scope {
    @NotNull
    private final String name;
    @NotNull
    private final Bucket bucket;
    @NotNull
    private final Core core;
    @NotNull
    private final ConcurrentHashMap<String, Collection> collectionCache;
    @NotNull
    private final QueryExecutor queryExecutor;
    @NotNull
    private final AnalyticsExecutor analyticsExecutor;

    public Scope(@NotNull String name, @NotNull Bucket bucket) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        this.name = name;
        this.bucket = bucket;
        this.core = this.bucket.getCore$kotlin_client();
        this.collectionCache = new ConcurrentHashMap();
        this.queryExecutor = new QueryExecutor(this.core, this);
        this.analyticsExecutor = new AnalyticsExecutor(this.core, this);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Bucket getBucket() {
        return this.bucket;
    }

    @NotNull
    public final Core getCore$kotlin_client() {
        return this.core;
    }

    @NotNull
    public final Collection collection(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String collectionName = name;
        String scopeName = this.name;
        Collection collection = this.collectionCache.computeIfAbsent(name, arg_0 -> Scope.collection$lambda-0(collectionName, scopeName, this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"collectionCache.computeI\u2026tionName, this)\n        }");
        return collection;
    }

    @NotNull
    public final Flow<QueryFlowItem> query(@NotNull String statement2, @NotNull CommonOptions common, @NotNull QueryParameters parameters, boolean preserveExpiry, @Nullable JsonSerializer serializer, @NotNull QueryScanConsistency consistency, boolean readonly, boolean adhoc, boolean flexIndex, boolean metrics, @NotNull QueryProfile profile, @Nullable Integer maxParallelism, @Nullable Integer scanCap, @Nullable Integer pipelineBatch, @Nullable Integer pipelineCap, @Nullable String clientContextId, @NotNull Map<String, ? extends Object> raw) {
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)common, (String)"common");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)consistency, (String)"consistency");
        Intrinsics.checkNotNullParameter((Object)((Object)profile), (String)"profile");
        Intrinsics.checkNotNullParameter(raw, (String)"raw");
        return this.queryExecutor.query(statement2, common, parameters, preserveExpiry, serializer, consistency, readonly, adhoc, flexIndex, metrics, profile, maxParallelism, scanCap, pipelineBatch, pipelineCap, clientContextId, raw);
    }

    public static /* synthetic */ Flow query$default(Scope scope, String string, CommonOptions commonOptions, QueryParameters queryParameters, boolean bl, JsonSerializer jsonSerializer, QueryScanConsistency queryScanConsistency, boolean bl2, boolean bl3, boolean bl4, boolean bl5, QueryProfile queryProfile, Integer n, Integer n2, Integer n3, Integer n4, String string2, Map map2, int n5, Object object) {
        if ((n5 & 2) != 0) {
            commonOptions = CommonOptions.Companion.getDefault();
        }
        if ((n5 & 4) != 0) {
            queryParameters = QueryParameters.None.INSTANCE;
        }
        if ((n5 & 8) != 0) {
            bl = false;
        }
        if ((n5 & 0x10) != 0) {
            jsonSerializer = null;
        }
        if ((n5 & 0x20) != 0) {
            queryScanConsistency = QueryScanConsistency.Companion.notBounded();
        }
        if ((n5 & 0x40) != 0) {
            bl2 = false;
        }
        if ((n5 & 0x80) != 0) {
            bl3 = true;
        }
        if ((n5 & 0x100) != 0) {
            bl4 = false;
        }
        if ((n5 & 0x200) != 0) {
            bl5 = false;
        }
        if ((n5 & 0x400) != 0) {
            queryProfile = QueryProfile.OFF;
        }
        if ((n5 & 0x800) != 0) {
            n = null;
        }
        if ((n5 & 0x1000) != 0) {
            n2 = null;
        }
        if ((n5 & 0x2000) != 0) {
            n3 = null;
        }
        if ((n5 & 0x4000) != 0) {
            n4 = null;
        }
        if ((n5 & 0x8000) != 0) {
            string2 = UUID.randomUUID().toString();
        }
        if ((n5 & 0x10000) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return scope.query(string, commonOptions, queryParameters, bl, jsonSerializer, queryScanConsistency, bl2, bl3, bl4, bl5, queryProfile, n, n2, n3, n4, string2, map2);
    }

    @NotNull
    public final Flow<AnalyticsFlowItem> analyticsQuery(@NotNull String statement2, @NotNull CommonOptions common, @NotNull AnalyticsParameters parameters, @Nullable JsonSerializer serializer, @NotNull AnalyticsScanConsistency consistency, boolean readonly, @NotNull AnalyticsPriority priority, @Nullable String clientContextId, @NotNull Map<String, ? extends Object> raw) {
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)common, (String)"common");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)consistency, (String)"consistency");
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        Intrinsics.checkNotNullParameter(raw, (String)"raw");
        return this.analyticsExecutor.query(statement2, common, parameters, serializer, consistency, readonly, priority, clientContextId, raw);
    }

    public static /* synthetic */ Flow analyticsQuery$default(Scope scope, String string, CommonOptions commonOptions, AnalyticsParameters analyticsParameters, JsonSerializer jsonSerializer, AnalyticsScanConsistency analyticsScanConsistency, boolean bl, AnalyticsPriority analyticsPriority, String string2, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            commonOptions = CommonOptions.Companion.getDefault();
        }
        if ((n & 4) != 0) {
            analyticsParameters = AnalyticsParameters.None.INSTANCE;
        }
        if ((n & 8) != 0) {
            jsonSerializer = null;
        }
        if ((n & 0x10) != 0) {
            analyticsScanConsistency = AnalyticsScanConsistency.Companion.notBounded();
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            analyticsPriority = AnalyticsPriority.Companion.normal();
        }
        if ((n & 0x80) != 0) {
            string2 = UUID.randomUUID().toString();
        }
        if ((n & 0x100) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return scope.analyticsQuery(string, commonOptions, analyticsParameters, jsonSerializer, analyticsScanConsistency, bl, analyticsPriority, string2, map2);
    }

    private static final Collection collection$lambda-0(String $collectionName, String $scopeName, Scope this$0, String it) {
        boolean defaultScopeAndCollection;
        Intrinsics.checkNotNullParameter((Object)$collectionName, (String)"$collectionName");
        Intrinsics.checkNotNullParameter((Object)$scopeName, (String)"$scopeName");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean bl = defaultScopeAndCollection = Intrinsics.areEqual((Object)$collectionName, (Object)"_default") && Intrinsics.areEqual((Object)$scopeName, (Object)"_default");
        if (!defaultScopeAndCollection) {
            this$0.core.configurationProvider().refreshCollectionId(new CollectionIdentifier(this$0.bucket.getName(), LangExtensionsKt.toOptional($scopeName), LangExtensionsKt.toOptional($collectionName)));
        }
        return new Collection($collectionName, this$0);
    }
}

