/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.codec;

import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.kotlin.codec.Content;
import com.couchbase.client.kotlin.codec.JsonSerializer;
import com.couchbase.client.kotlin.codec.Transcoder;
import com.couchbase.client.kotlin.codec.TypeRef;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ)\u0010\f\u001a\u00020\b\"\u0004\b\u0000\u0010\u00062\u0006\u0010\r\u001a\u0002H\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\nH\u0016\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/couchbase/client/kotlin/codec/JsonTranscoder;", "Lcom/couchbase/client/kotlin/codec/Transcoder;", "serializer", "Lcom/couchbase/client/kotlin/codec/JsonSerializer;", "(Lcom/couchbase/client/kotlin/codec/JsonSerializer;)V", "decode", "T", "content", "Lcom/couchbase/client/kotlin/codec/Content;", "type", "Lcom/couchbase/client/kotlin/codec/TypeRef;", "(Lcom/couchbase/client/kotlin/codec/Content;Lcom/couchbase/client/kotlin/codec/TypeRef;)Ljava/lang/Object;", "doEncode", "input", "(Ljava/lang/Object;Lcom/couchbase/client/kotlin/codec/TypeRef;)Lcom/couchbase/client/kotlin/codec/Content;", "kotlin-client"})
public final class JsonTranscoder
implements Transcoder {
    @NotNull
    private final JsonSerializer serializer;

    public JsonTranscoder(@NotNull JsonSerializer serializer) {
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        this.serializer = serializer;
    }

    @Override
    @NotNull
    public <T> Content doEncode(T input, @NotNull TypeRef<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        if (input instanceof byte[]) {
            InvalidArgumentException invalidArgumentException = InvalidArgumentException.fromMessage((String)"JsonTranscoder can't encode ByteArray. To write arbitrary binary content, use RawBinaryTranscoder or pass Content.binary(myByteArray). To write pre-serialized JSON, use RawJsonTranscoder or pass Content.json(mySerializedJson).");
            Intrinsics.checkNotNullExpressionValue((Object)invalidArgumentException, (String)"fromMessage(\n           \u2026izedJson).\"\n            )");
            throw (Throwable)invalidArgumentException;
        }
        return Content.Companion.json(this.serializer.serialize(input, type));
    }

    @Override
    public <T> T decode(@NotNull Content content, @NotNull TypeRef<T> type) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        if (Intrinsics.areEqual((Object)type.getType(), byte[].class)) {
            InvalidArgumentException invalidArgumentException = InvalidArgumentException.fromMessage((String)"JsonTranscoder can't decode to ByteArray. To access raw document content, use the 'content' property instead of calling 'contentAs<ByteArray>()'");
            Intrinsics.checkNotNullExpressionValue((Object)invalidArgumentException, (String)"fromMessage(\n           \u2026eArray>()'\"\n            )");
            throw (Throwable)invalidArgumentException;
        }
        return this.serializer.deserialize(content.getBytes(), type);
    }

    @Override
    @NotNull
    public <T> Content encode(T input, @NotNull TypeRef<T> type) {
        return Transcoder.DefaultImpls.encode(this, input, type);
    }
}

