/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.search;

import com.couchbase.client.kotlin.internal.LangExtensionsKt;
import com.couchbase.client.kotlin.search.Category;
import com.couchbase.client.kotlin.search.SearchFacetKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B#\b\u0012\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\b\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\u001b\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011H\u0000\u00a2\u0006\u0002\b\u0013J\b\u0010\u0014\u001a\u00020\u0006H\u0016R\u0015\u0010\u0004\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0002\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/couchbase/client/kotlin/search/NumericRange;", "Lcom/couchbase/client/kotlin/search/Category;", "min", "", "max", "name", "", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/String;)V", "", "(Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/String;)V", "getMax", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getMin", "getName", "()Ljava/lang/String;", "toMap", "", "", "toMap$kotlin_client", "toString", "Companion", "kotlin-client"})
public final class NumericRange
implements Category {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Double min;
    @Nullable
    private final Double max;
    @NotNull
    private final String name;

    public NumericRange(@Nullable Double min, @Nullable Double max, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.min = min;
        this.max = max;
        this.name = name;
        if (!(this.min != null || this.max != null)) {
            boolean $i$a$-require-NumericRange$32 = false;
            String $i$a$-require-NumericRange$32 = "Numeric range requires at least one of 'min' or 'max'.";
            throw new IllegalArgumentException($i$a$-require-NumericRange$32.toString());
        }
        if (this.min != null && this.max != null && !(this.min < this.max)) {
            boolean bl = false;
            String string = "Numeric range 'min' must be < 'max'.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Nullable
    public final Double getMin() {
        return this.min;
    }

    @Nullable
    public final Double getMax() {
        return this.max;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    private NumericRange(Number min, Number max, String name) {
        this(SearchFacetKt.access$toDoubleSafe(min), SearchFacetKt.access$toDoubleSafe(max), name);
    }

    @NotNull
    public final Map<String, Object> toMap$kotlin_client() {
        Map map2;
        Map $this$toMap_u24lambda_u2d2 = map2 = (Map)new LinkedHashMap();
        boolean bl = false;
        $this$toMap_u24lambda_u2d2.put("name", this.getName());
        LangExtensionsKt.putIfNotNull($this$toMap_u24lambda_u2d2, "min", this.getMin());
        LangExtensionsKt.putIfNotNull($this$toMap_u24lambda_u2d2, "max", this.getMax());
        return map2;
    }

    @NotNull
    public String toString() {
        return "NumericRange(name='" + this.getName() + "', min=" + this.min + ", max=" + this.max + ')';
    }

    public /* synthetic */ NumericRange(Number min, Number max, String name, DefaultConstructorMarker $constructor_marker) {
        this(min, max, name);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tJ\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lcom/couchbase/client/kotlin/search/NumericRange$Companion;", "", "()V", "bounds", "Lcom/couchbase/client/kotlin/search/NumericRange;", "min", "", "max", "name", "", "lowerBound", "upperBound", "kotlin-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NumericRange lowerBound(@NotNull Number min, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)min, (String)"min");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new NumericRange(min, null, name, null);
        }

        public static /* synthetic */ NumericRange lowerBound$default(Companion companion, Number number, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = number + "<=x<\u221e";
            }
            return companion.lowerBound(number, string);
        }

        @NotNull
        public final NumericRange upperBound(@NotNull Number max, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)max, (String)"max");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new NumericRange(null, max, name, null);
        }

        public static /* synthetic */ NumericRange upperBound$default(Companion companion, Number number, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = Intrinsics.stringPlus((String)"-\u221e<=x<", (Object)number);
            }
            return companion.upperBound(number, string);
        }

        @NotNull
        public final NumericRange bounds(@NotNull Number min, @NotNull Number max, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)min, (String)"min");
            Intrinsics.checkNotNullParameter((Object)max, (String)"max");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new NumericRange(min, max, name, null);
        }

        public static /* synthetic */ NumericRange bounds$default(Companion companion, Number number, Number number2, String string, int n, Object object) {
            if ((n & 4) != 0) {
                string = number + "<=x<" + number2;
            }
            return companion.bounds(number, number2, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

