/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.search;

import com.couchbase.client.kotlin.internal.LangExtensionsKt;
import com.couchbase.client.kotlin.search.Category;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B)\b\u0000\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0000\u00a2\u0006\u0002\b\u0010J\b\u0010\u0011\u001a\u00020\u0006H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/couchbase/client/kotlin/search/DateRange;", "Lcom/couchbase/client/kotlin/search/Category;", "start", "Ljava/time/Instant;", "end", "name", "", "(Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/String;)V", "getEnd", "()Ljava/time/Instant;", "getName", "()Ljava/lang/String;", "getStart", "toMap", "", "", "toMap$kotlin_client", "toString", "Companion", "kotlin-client"})
public final class DateRange
implements Category {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Instant start;
    @Nullable
    private final Instant end;
    @NotNull
    private final String name;

    public DateRange(@Nullable Instant start, @Nullable Instant end, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.start = start;
        this.end = end;
        this.name = name;
        if (!(this.start != null || this.end != null)) {
            boolean $i$a$-require-DateRange$32 = false;
            String $i$a$-require-DateRange$32 = "Date range requires at least one of 'start' or 'end'.";
            throw new IllegalArgumentException($i$a$-require-DateRange$32.toString());
        }
        if (this.start != null && this.end != null && !(this.start.compareTo(this.end) < 0)) {
            boolean bl = false;
            String string = "Date range 'start' must be <= 'end'.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ DateRange(Instant instant, Instant instant2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            instant = null;
        }
        if ((n & 2) != 0) {
            instant2 = null;
        }
        if ((n & 4) != 0) {
            StringBuilder stringBuilder = new StringBuilder();
            Object object = instant;
            if (object == null) {
                object = "-\u221e";
            }
            StringBuilder stringBuilder2 = stringBuilder.append(object).append("<=x<");
            Object object2 = instant2;
            if (object2 == null) {
                object2 = "\u221e";
            }
            string = stringBuilder2.append(object2).toString();
        }
        this(instant, instant2, string);
    }

    @Nullable
    public final Instant getStart() {
        return this.start;
    }

    @Nullable
    public final Instant getEnd() {
        return this.end;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String toString() {
        return "DateRange(name='" + this.getName() + "', start=" + this.start + ", end=" + this.end + ')';
    }

    @NotNull
    public final Map<String, Object> toMap$kotlin_client() {
        Map map2;
        Map $this$toMap_u24lambda_u2d2 = map2 = (Map)new LinkedHashMap();
        boolean bl = false;
        $this$toMap_u24lambda_u2d2.put("name", this.getName());
        Instant instant = this.getStart();
        LangExtensionsKt.putIfNotNull($this$toMap_u24lambda_u2d2, "start", instant == null ? null : instant.toString());
        Instant instant2 = this.getEnd();
        LangExtensionsKt.putIfNotNull($this$toMap_u24lambda_u2d2, "end", instant2 == null ? null : instant2.toString());
        return map2;
    }

    public DateRange() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tJ\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lcom/couchbase/client/kotlin/search/DateRange$Companion;", "", "()V", "bounds", "Lcom/couchbase/client/kotlin/search/DateRange;", "start", "Ljava/time/Instant;", "end", "name", "", "lowerBound", "upperBound", "kotlin-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateRange lowerBound(@NotNull Instant start, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new DateRange(start, null, name);
        }

        public static /* synthetic */ DateRange lowerBound$default(Companion companion, Instant instant, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = instant + "<=x<\u221e}";
            }
            return companion.lowerBound(instant, string);
        }

        @NotNull
        public final DateRange upperBound(@NotNull Instant end, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new DateRange(null, end, name);
        }

        public static /* synthetic */ DateRange upperBound$default(Companion companion, Instant instant, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = "-\u221e<=x<" + instant + '}';
            }
            return companion.upperBound(instant, string);
        }

        @NotNull
        public final DateRange bounds(@NotNull Instant start, @NotNull Instant end, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new DateRange(start, end, name);
        }

        public static /* synthetic */ DateRange bounds$default(Companion companion, Instant instant, Instant instant2, String string, int n, Object object) {
            if ((n & 4) != 0) {
                string = instant + "<=x<" + instant2;
            }
            return companion.bounds(instant, instant2, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

