/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.Meter;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.encryption.CryptoManager;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.TimeoutConfig;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.kotlin.CommonOptions;
import com.couchbase.client.kotlin.codec.JacksonJsonSerializer;
import com.couchbase.client.kotlin.codec.JsonSerializer;
import com.couchbase.client.kotlin.codec.JsonTranscoder;
import com.couchbase.client.kotlin.codec.Transcoder;
import com.couchbase.client.kotlin.env.ClusterEnvironment;
import com.couchbase.client.kotlin.env.ClusterPropertyLoader;
import com.couchbase.client.kotlin.env.dsl.ClusterEnvironmentDslBuilder;
import com.couchbase.client.kotlin.internal.LangExtensionsKt;
import com.couchbase.client.kotlin.kv.Durability;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 82\u00020\u0001:\u000278B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0014J#\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0086@\u00f8\u0001\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0019\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a*\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0019\u0010\u001e\u001a\u00020\u001a*\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!J\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#*\u00020\u001cH\u0000\u00a2\u0006\u0002\b%J\u0019\u0010&\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a*\u00020\u001cH\u0000\u00a2\u0006\u0002\b'J\u0019\u0010(\u001a\n \u001b*\u0004\u0018\u00010)0)*\u00020\u001cH\u0000\u00a2\u0006\u0002\b*J\u0019\u0010+\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a*\u00020\u001cH\u0000\u00a2\u0006\u0002\b,J!\u0010-\u001a\n \u001b*\u0004\u0018\u00010.0.*\u00020\u001c2\u0006\u0010/\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b0J\u0019\u00101\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a*\u00020\u001cH\u0000\u00a2\u0006\u0002\b2J$\u00103\u001a\u00020\u0016*\u0002042\u0006\u0010\u001f\u001a\u00020 H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b5\u00106R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00069"}, d2={"Lcom/couchbase/client/kotlin/env/ClusterEnvironment;", "Lcom/couchbase/client/core/env/CoreEnvironment;", "builder", "Lcom/couchbase/client/kotlin/env/ClusterEnvironment$Builder;", "(Lcom/couchbase/client/kotlin/env/ClusterEnvironment$Builder;)V", "cryptoManager", "Lcom/couchbase/client/core/encryption/CryptoManager;", "getCryptoManager$kotlin_client", "()Lcom/couchbase/client/core/encryption/CryptoManager;", "jsonSerializer", "Lcom/couchbase/client/kotlin/codec/JsonSerializer;", "getJsonSerializer$kotlin_client", "()Lcom/couchbase/client/kotlin/codec/JsonSerializer;", "transcoder", "Lcom/couchbase/client/kotlin/codec/Transcoder;", "getTranscoder$kotlin_client", "()Lcom/couchbase/client/kotlin/codec/Transcoder;", "defaultAgentTitle", "", "shutdownSuspend", "", "timeout", "Lkotlin/time/Duration;", "shutdownSuspend-VtjQ1oo", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "actualAnalyticsTimeout", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "Lcom/couchbase/client/kotlin/CommonOptions;", "actualAnalyticsTimeout$kotlin_client", "actualKvTimeout", "durability", "Lcom/couchbase/client/kotlin/kv/Durability;", "actualKvTimeout$kotlin_client", "actualManagementTimeout", "", "", "actualManagementTimeout$kotlin_client", "actualQueryTimeout", "actualQueryTimeout$kotlin_client", "actualRetryStrategy", "Lcom/couchbase/client/core/retry/RetryStrategy;", "actualRetryStrategy$kotlin_client", "actualSearchTimeout", "actualSearchTimeout$kotlin_client", "actualSpan", "Lcom/couchbase/client/core/cnc/RequestSpan;", "name", "actualSpan$kotlin_client", "actualViewTimeout", "actualViewTimeout$kotlin_client", "kvTimeout", "Lcom/couchbase/client/core/env/TimeoutConfig;", "kvTimeout-3nIYWDw", "(Lcom/couchbase/client/core/env/TimeoutConfig;Lcom/couchbase/client/kotlin/kv/Durability;)J", "Builder", "Companion", "kotlin-client"})
public final class ClusterEnvironment
extends CoreEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonSerializer jsonSerializer;
    @NotNull
    private final Transcoder transcoder;
    @Nullable
    private final CryptoManager cryptoManager;

    private ClusterEnvironment(Builder builder2) {
        super((CoreEnvironment.Builder)builder2);
        Transcoder transcoder;
        this.cryptoManager = builder2.getCryptoManager$kotlin_client();
        JsonSerializer jsonSerializer = builder2.getJsonSerializer$kotlin_client();
        if (jsonSerializer == null) {
            jsonSerializer = this.jsonSerializer = (JsonSerializer)new JacksonJsonSerializer(ExtensionsKt.jsonMapper((Function1)1.INSTANCE));
        }
        if ((transcoder = builder2.getTranscoder$kotlin_client()) == null) {
            transcoder = new JsonTranscoder(this.jsonSerializer);
        }
        this.transcoder = transcoder;
    }

    @NotNull
    public final JsonSerializer getJsonSerializer$kotlin_client() {
        return this.jsonSerializer;
    }

    @NotNull
    public final Transcoder getTranscoder$kotlin_client() {
        return this.transcoder;
    }

    @Nullable
    public final CryptoManager getCryptoManager$kotlin_client() {
        return this.cryptoManager;
    }

    @NotNull
    protected String defaultAgentTitle() {
        return "kotlin";
    }

    @Nullable
    public final Object shutdownSuspend-VtjQ1oo(long timeout, @NotNull Continuation<? super Unit> $completion) {
        int n = Duration.getNanosecondsComponent-impl((long)timeout);
        java.time.Duration duration = java.time.Duration.ofSeconds(Duration.getInWholeSeconds-impl((long)timeout), n);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toJavaDuration-LRDsOJo");
        Mono mono = this.shutdownReactive(duration);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"shutdownReactive(timeout.toJavaDuration())");
        Object object = LangExtensionsKt.await((Mono<Void>)mono, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object shutdownSuspend-VtjQ1oo$default(ClusterEnvironment clusterEnvironment, long l, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            java.time.Duration duration = clusterEnvironment.timeoutConfig().disconnectTimeout();
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"fun shutdownSuspend(time\u2026Duration()).await()\n    }");
            l = Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration.getNano(), (DurationUnit)DurationUnit.NANOSECONDS));
        }
        return clusterEnvironment.shutdownSuspend-VtjQ1oo(l, (Continuation<? super Unit>)continuation);
    }

    public final RetryStrategy actualRetryStrategy$kotlin_client(@NotNull CommonOptions $this$actualRetryStrategy) {
        Intrinsics.checkNotNullParameter((Object)$this$actualRetryStrategy, (String)"<this>");
        RetryStrategy retryStrategy = $this$actualRetryStrategy.getRetryStrategy();
        if (retryStrategy == null) {
            retryStrategy = this.retryStrategy();
        }
        return retryStrategy;
    }

    public final RequestSpan actualSpan$kotlin_client(@NotNull CommonOptions $this$actualSpan, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$actualSpan, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.requestTracer().requestSpan(name, $this$actualSpan.getParentSpan());
    }

    public final java.time.Duration actualViewTimeout$kotlin_client(@NotNull CommonOptions $this$actualViewTimeout) {
        java.time.Duration duration;
        java.time.Duration duration2;
        Intrinsics.checkNotNullParameter((Object)$this$actualViewTimeout, (String)"<this>");
        Duration duration3 = $this$actualViewTimeout.getTimeout-FghU774();
        if (duration3 == null) {
            duration2 = null;
        } else {
            long l = duration3.unbox-impl();
            int n = Duration.getNanosecondsComponent-impl((long)l);
            java.time.Duration duration4 = java.time.Duration.ofSeconds(Duration.getInWholeSeconds-impl((long)l), n);
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"toJavaDuration-LRDsOJo");
            duration2 = duration = duration4;
        }
        if (duration2 == null) {
            duration = this.timeoutConfig().viewTimeout();
        }
        return duration;
    }

    @NotNull
    public final Comparable<?> actualManagementTimeout$kotlin_client(@NotNull CommonOptions $this$actualManagementTimeout) {
        Comparable comparable;
        java.time.Duration duration;
        java.time.Duration duration2;
        Intrinsics.checkNotNullParameter((Object)$this$actualManagementTimeout, (String)"<this>");
        Duration duration3 = $this$actualManagementTimeout.getTimeout-FghU774();
        if (duration3 == null) {
            duration2 = null;
        } else {
            long l = duration3.unbox-impl();
            int n = Duration.getNanosecondsComponent-impl((long)l);
            java.time.Duration duration4 = java.time.Duration.ofSeconds(Duration.getInWholeSeconds-impl((long)l), n);
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"toJavaDuration-LRDsOJo");
            duration2 = duration = duration4;
        }
        if (duration == null) {
            java.time.Duration duration5 = this.timeoutConfig().managementTimeout();
            Intrinsics.checkNotNullExpressionValue((Object)duration5, (String)"timeoutConfig().managementTimeout()");
            comparable = Duration.box-impl((long)Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration5.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration5.getNano(), (DurationUnit)DurationUnit.NANOSECONDS)));
        } else {
            comparable = duration;
        }
        return comparable;
    }

    public final java.time.Duration actualQueryTimeout$kotlin_client(@NotNull CommonOptions $this$actualQueryTimeout) {
        java.time.Duration duration;
        java.time.Duration duration2;
        Intrinsics.checkNotNullParameter((Object)$this$actualQueryTimeout, (String)"<this>");
        Duration duration3 = $this$actualQueryTimeout.getTimeout-FghU774();
        if (duration3 == null) {
            duration2 = null;
        } else {
            long l = duration3.unbox-impl();
            int n = Duration.getNanosecondsComponent-impl((long)l);
            java.time.Duration duration4 = java.time.Duration.ofSeconds(Duration.getInWholeSeconds-impl((long)l), n);
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"toJavaDuration-LRDsOJo");
            duration2 = duration = duration4;
        }
        if (duration2 == null) {
            duration = this.timeoutConfig().queryTimeout();
        }
        return duration;
    }

    public final java.time.Duration actualAnalyticsTimeout$kotlin_client(@NotNull CommonOptions $this$actualAnalyticsTimeout) {
        java.time.Duration duration;
        java.time.Duration duration2;
        Intrinsics.checkNotNullParameter((Object)$this$actualAnalyticsTimeout, (String)"<this>");
        Duration duration3 = $this$actualAnalyticsTimeout.getTimeout-FghU774();
        if (duration3 == null) {
            duration2 = null;
        } else {
            long l = duration3.unbox-impl();
            int n = Duration.getNanosecondsComponent-impl((long)l);
            java.time.Duration duration4 = java.time.Duration.ofSeconds(Duration.getInWholeSeconds-impl((long)l), n);
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"toJavaDuration-LRDsOJo");
            duration2 = duration = duration4;
        }
        if (duration2 == null) {
            duration = this.timeoutConfig().analyticsTimeout();
        }
        return duration;
    }

    @NotNull
    public final java.time.Duration actualKvTimeout$kotlin_client(@NotNull CommonOptions $this$actualKvTimeout, @NotNull Durability durability) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$actualKvTimeout, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)durability, (String)"durability");
        Duration duration = $this$actualKvTimeout.getTimeout-FghU774();
        if (duration == null) {
            TimeoutConfig timeoutConfig = this.timeoutConfig();
            Intrinsics.checkNotNullExpressionValue((Object)timeoutConfig, (String)"timeoutConfig()");
            l = this.kvTimeout-3nIYWDw(timeoutConfig, durability);
        } else {
            l = duration.unbox-impl();
        }
        long l2 = l;
        int n = Duration.getNanosecondsComponent-impl((long)l2);
        java.time.Duration duration2 = java.time.Duration.ofSeconds(Duration.getInWholeSeconds-impl((long)l2), n);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"toJavaDuration-LRDsOJo");
        return duration2;
    }

    public final java.time.Duration actualSearchTimeout$kotlin_client(@NotNull CommonOptions $this$actualSearchTimeout) {
        java.time.Duration duration;
        java.time.Duration duration2;
        Intrinsics.checkNotNullParameter((Object)$this$actualSearchTimeout, (String)"<this>");
        Duration duration3 = $this$actualSearchTimeout.getTimeout-FghU774();
        if (duration3 == null) {
            duration2 = null;
        } else {
            long l = duration3.unbox-impl();
            int n = Duration.getNanosecondsComponent-impl((long)l);
            java.time.Duration duration4 = java.time.Duration.ofSeconds(Duration.getInWholeSeconds-impl((long)l), n);
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"toJavaDuration-LRDsOJo");
            duration2 = duration = duration4;
        }
        if (duration2 == null) {
            duration = this.timeoutConfig().searchTimeout();
        }
        return duration;
    }

    private final long kvTimeout-3nIYWDw(TimeoutConfig $this$kvTimeout_u2d3nIYWDw, Durability durability) {
        java.time.Duration duration = durability.isPersistent$kotlin_client() ? $this$kvTimeout_u2d3nIYWDw.kvDurableTimeout() : $this$kvTimeout_u2d3nIYWDw.kvTimeout();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"if (durability.isPersist\u2026imeout() else kvTimeout()");
        return Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration.getNano(), (DurationUnit)DurationUnit.NANOSECONDS));
    }

    public /* synthetic */ ClusterEnvironment(Builder builder2, DefaultConstructorMarker $constructor_marker) {
        this(builder2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u001d\b\u0002\u0010\u0005\u001a\u0017\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/couchbase/client/kotlin/env/ClusterEnvironment$Companion;", "", "()V", "builder", "Lcom/couchbase/client/kotlin/env/ClusterEnvironment$Builder;", "configBlock", "Lkotlin/Function1;", "Lcom/couchbase/client/kotlin/env/dsl/ClusterEnvironmentDslBuilder;", "", "Lcom/couchbase/client/kotlin/env/dsl/ClusterEnvironmentConfigBlock;", "Lkotlin/ExtensionFunctionType;", "kotlin-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Builder builder(@NotNull Function1<? super ClusterEnvironmentDslBuilder, Unit> configBlock) {
            Intrinsics.checkNotNullParameter(configBlock, (String)"configBlock");
            ClusterEnvironmentDslBuilder builder2 = new ClusterEnvironmentDslBuilder();
            configBlock.invoke((Object)builder2);
            return builder2.toCore$kotlin_client();
        }

        public static /* synthetic */ Builder builder$default(Companion companion, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                function1 = builder.1.INSTANCE;
            }
            return companion.builder((Function1<? super ClusterEnvironmentDslBuilder, Unit>)function1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u001d\u001a\u00020\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0017J\u0010\u0010\t\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u0012\u0010\"\u001a\u00020\u00002\b\u0010\"\u001a\u0004\u0018\u00010#H\u0017J\u0012\u0010$\u001a\u00020\u00002\b\u0010$\u001a\u0004\u0018\u00010%H\u0017J\u0012\u0010&\u001a\u00020\u00002\b\u0010&\u001a\u0004\u0018\u00010'H\u0017J\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006("}, d2={"Lcom/couchbase/client/kotlin/env/ClusterEnvironment$Builder;", "Lcom/couchbase/client/core/env/CoreEnvironment$Builder;", "()V", "cryptoManager", "Lcom/couchbase/client/core/encryption/CryptoManager;", "getCryptoManager$kotlin_client", "()Lcom/couchbase/client/core/encryption/CryptoManager;", "setCryptoManager$kotlin_client", "(Lcom/couchbase/client/core/encryption/CryptoManager;)V", "jsonSerializer", "Lcom/couchbase/client/kotlin/codec/JsonSerializer;", "getJsonSerializer$kotlin_client", "()Lcom/couchbase/client/kotlin/codec/JsonSerializer;", "setJsonSerializer$kotlin_client", "(Lcom/couchbase/client/kotlin/codec/JsonSerializer;)V", "transcoder", "Lcom/couchbase/client/kotlin/codec/Transcoder;", "getTranscoder$kotlin_client", "()Lcom/couchbase/client/kotlin/codec/Transcoder;", "setTranscoder$kotlin_client", "(Lcom/couchbase/client/kotlin/codec/Transcoder;)V", "used", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getUsed$kotlin_client", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "setUsed$kotlin_client", "(Ljava/util/concurrent/atomic/AtomicBoolean;)V", "build", "Lcom/couchbase/client/kotlin/env/ClusterEnvironment;", "eventBus", "Lcom/couchbase/client/core/cnc/EventBus;", "load", "loader", "Lcom/couchbase/client/kotlin/env/ClusterPropertyLoader;", "meter", "Lcom/couchbase/client/core/cnc/Meter;", "requestTracer", "Lcom/couchbase/client/core/cnc/RequestTracer;", "scheduler", "Lreactor/core/scheduler/Scheduler;", "kotlin-client"})
    public static final class Builder
    extends CoreEnvironment.Builder<Builder> {
        @Nullable
        private JsonSerializer jsonSerializer;
        @Nullable
        private Transcoder transcoder;
        @Nullable
        private CryptoManager cryptoManager;
        @NotNull
        private AtomicBoolean used = new AtomicBoolean();

        @Nullable
        public final JsonSerializer getJsonSerializer$kotlin_client() {
            return this.jsonSerializer;
        }

        public final void setJsonSerializer$kotlin_client(@Nullable JsonSerializer jsonSerializer) {
            this.jsonSerializer = jsonSerializer;
        }

        @Nullable
        public final Transcoder getTranscoder$kotlin_client() {
            return this.transcoder;
        }

        public final void setTranscoder$kotlin_client(@Nullable Transcoder transcoder) {
            this.transcoder = transcoder;
        }

        @Nullable
        public final CryptoManager getCryptoManager$kotlin_client() {
            return this.cryptoManager;
        }

        public final void setCryptoManager$kotlin_client(@Nullable CryptoManager cryptoManager) {
            this.cryptoManager = cryptoManager;
        }

        @NotNull
        public final AtomicBoolean getUsed$kotlin_client() {
            return this.used;
        }

        public final void setUsed$kotlin_client(@NotNull AtomicBoolean atomicBoolean) {
            Intrinsics.checkNotNullParameter((Object)atomicBoolean, (String)"<set-?>");
            this.used = atomicBoolean;
        }

        @NotNull
        public final Builder load(@NotNull ClusterPropertyLoader loader) {
            Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
            loader.load(this);
            return this;
        }

        @NotNull
        public final Builder jsonSerializer(@Nullable JsonSerializer jsonSerializer) {
            this.jsonSerializer = jsonSerializer;
            return this;
        }

        @NotNull
        public final Builder transcoder(@Nullable Transcoder transcoder) {
            this.transcoder = transcoder;
            return this;
        }

        @NotNull
        public final Builder cryptoManager(@Nullable CryptoManager cryptoManager) {
            this.cryptoManager = cryptoManager;
            return this;
        }

        @Stability.Uncommitted
        @NotNull
        public Builder eventBus(@Nullable EventBus eventBus) {
            CoreEnvironment.Builder builder2 = super.eventBus(eventBus);
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"super.eventBus(eventBus)");
            return (Builder)builder2;
        }

        @Stability.Uncommitted
        @NotNull
        public Builder scheduler(@Nullable Scheduler scheduler) {
            CoreEnvironment.Builder builder2 = super.scheduler(scheduler);
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"super.scheduler(scheduler)");
            return (Builder)builder2;
        }

        @Stability.Uncommitted
        @NotNull
        public Builder requestTracer(@Nullable RequestTracer requestTracer) {
            CoreEnvironment.Builder builder2 = super.requestTracer(requestTracer);
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"super.requestTracer(requestTracer)");
            return (Builder)builder2;
        }

        @Stability.Uncommitted
        @NotNull
        public Builder meter(@Nullable Meter meter) {
            CoreEnvironment.Builder builder2 = super.meter(meter);
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"super.meter(meter)");
            return (Builder)builder2;
        }

        @NotNull
        public ClusterEnvironment build() {
            if (!this.used.compareAndSet(false, true)) {
                boolean bl = false;
                String string = "ClusterEnvironment.Builder.build() may only be called once.";
                throw new IllegalStateException(string.toString());
            }
            return new ClusterEnvironment(this, null);
        }
    }
}

