/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.codec;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufUtil;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.kotlin.internal.LangExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/couchbase/client/kotlin/codec/Content;", "", "bytes", "", "flags", "", "([BI)V", "getBytes", "()[B", "getFlags", "()I", "convertContentToString", "", "toString", "Companion", "kotlin-client"})
public final class Content {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] bytes;
    private final int flags;

    public Content(@NotNull byte[] bytes, int flags) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.bytes = bytes;
        this.flags = flags;
    }

    @NotNull
    public final byte[] getBytes() {
        return this.bytes;
    }

    public final int getFlags() {
        return this.flags;
    }

    @NotNull
    public String toString() {
        String type = CodecFlags.hasCommonFormat((int)this.flags, (int)CodecFlags.JSON_COMMON_FLAGS) ? "json" : (CodecFlags.hasCommonFormat((int)this.flags, (int)CodecFlags.BINARY_COMMON_FLAGS) ? "binary" : (CodecFlags.hasCommonFormat((int)this.flags, (int)CodecFlags.STRING_COMMON_FLAGS) ? "string" : (this.flags == 0 && !(this.bytes.length == 0) && (char)this.bytes[0] == '{' ? "json?" : "?")));
        return "Content(length=" + this.bytes.length + ", flags=" + this.flags + ", type=" + type + " value=" + this.convertContentToString() + ')';
    }

    private final String convertContentToString() {
        String string;
        boolean printable;
        if (this.bytes.length == 0) {
            return "";
        }
        boolean bl = printable = CodecFlags.hasCommonFormat((int)this.flags, (int)CodecFlags.JSON_COMMON_FLAGS) || CodecFlags.hasCommonFormat((int)this.flags, (int)CodecFlags.STRING_COMMON_FLAGS) || this.flags == 0 && (char)this.bytes[0] == '{';
        if (printable) {
            string = LangExtensionsKt.toStringUtf8(this.bytes);
        } else {
            String result = ByteBufUtil.prettyHexDump((ByteBuf)Unpooled.wrappedBuffer((byte[])this.bytes));
            string = '\n' + result + '\n';
        }
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Lcom/couchbase/client/kotlin/codec/Content$Companion;", "", "()V", "binary", "Lcom/couchbase/client/kotlin/codec/Content;", "value", "", "json", "", "serializedJavaObject", "string", "kotlin-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Content json(@NotNull byte[] value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return new Content(value2, CodecFlags.JSON_COMPAT_FLAGS);
        }

        @NotNull
        public final Content json(@NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            String string = value2;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            return this.json(byArray);
        }

        @NotNull
        public final Content binary(@NotNull byte[] value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return new Content(value2, CodecFlags.BINARY_COMPAT_FLAGS);
        }

        @NotNull
        public final Content string(@NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            String string = value2;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            return new Content(byArray, CodecFlags.STRING_COMPAT_FLAGS);
        }

        @NotNull
        public final Content serializedJavaObject(@NotNull byte[] value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return new Content(value2, CodecFlags.SERIALIZED_COMPAT_FLAGS);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

