/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.diagnostics.ClusterState;
import com.couchbase.client.core.diagnostics.WaitUntilReadyHelper;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.ConnectionStringPropertyLoader;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.PasswordAuthenticator;
import com.couchbase.client.core.env.PropertyLoader;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.ConnectionString;
import com.couchbase.client.core.util.ConnectionStringUtil;
import com.couchbase.client.kotlin.Bucket;
import com.couchbase.client.kotlin.Cluster;
import com.couchbase.client.kotlin.CommonOptions;
import com.couchbase.client.kotlin.analytics.AnalyticsFlowItem;
import com.couchbase.client.kotlin.analytics.AnalyticsParameters;
import com.couchbase.client.kotlin.analytics.AnalyticsPriority;
import com.couchbase.client.kotlin.analytics.AnalyticsScanConsistency;
import com.couchbase.client.kotlin.analytics.internal.AnalyticsExecutor;
import com.couchbase.client.kotlin.codec.JsonSerializer;
import com.couchbase.client.kotlin.env.ClusterEnvironment;
import com.couchbase.client.kotlin.env.ClusterEnvironmentKt;
import com.couchbase.client.kotlin.env.dsl.ClusterEnvironmentDslBuilder;
import com.couchbase.client.kotlin.internal.LangExtensionsKt;
import com.couchbase.client.kotlin.query.QueryFlowItem;
import com.couchbase.client.kotlin.query.QueryParameters;
import com.couchbase.client.kotlin.query.QueryProfile;
import com.couchbase.client.kotlin.query.QueryScanConsistency;
import com.couchbase.client.kotlin.query.internal.QueryExecutor;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Mono;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 K2\u00020\u0001:\u0001KB-\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJv\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u00102\b\b\u0002\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\b\b\u0002\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020\u00052\b\b\u0002\u0010(\u001a\u00020)2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u00102\u0016\b\u0002\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00010,J\u000e\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u0010J#\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u000202H\u0086@\u00f8\u0001\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b3\u00104J\u00c9\u0001\u00105\u001a\b\u0012\u0004\u0012\u0002060\u001c2\u0006\u0010\u001e\u001a\u00020\u00102\b\b\u0002\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u0002072\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\b\b\u0002\u0010%\u001a\u0002082\b\b\u0002\u0010'\u001a\u00020\u00052\b\b\u0002\u00109\u001a\u00020\u00052\b\b\u0002\u0010:\u001a\u00020\u00052\b\b\u0002\u0010;\u001a\u00020\u00052\b\b\u0002\u0010<\u001a\u00020=2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010?2\n\b\u0002\u0010@\u001a\u0004\u0018\u00010?2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010?2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010?2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u00102\u0016\b\u0002\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00010,\u00a2\u0006\u0002\u0010CJ;\u0010D\u001a\u00020\u00002\u0006\u00101\u001a\u0002022\u000e\b\u0002\u0010E\u001a\b\u0012\u0004\u0012\u00020F0\t2\b\b\u0002\u0010G\u001a\u00020HH\u0086@\u00f8\u0001\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bI\u0010JR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006L"}, d2={"Lcom/couchbase/client/kotlin/Cluster;", "", "environment", "Lcom/couchbase/client/kotlin/env/ClusterEnvironment;", "ownsEnvironment", "", "authenticator", "Lcom/couchbase/client/core/env/Authenticator;", "seedNodes", "", "Lcom/couchbase/client/core/env/SeedNode;", "(Lcom/couchbase/client/kotlin/env/ClusterEnvironment;ZLcom/couchbase/client/core/env/Authenticator;Ljava/util/Set;)V", "analyticsExecutor", "Lcom/couchbase/client/kotlin/analytics/internal/AnalyticsExecutor;", "bucketCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/couchbase/client/kotlin/Bucket;", "core", "Lcom/couchbase/client/core/Core;", "getCore$kotlin_client", "()Lcom/couchbase/client/core/Core;", "env", "getEnv$kotlin_client", "()Lcom/couchbase/client/kotlin/env/ClusterEnvironment;", "queryExecutor", "Lcom/couchbase/client/kotlin/query/internal/QueryExecutor;", "analyticsQuery", "Lkotlinx/coroutines/flow/Flow;", "Lcom/couchbase/client/kotlin/analytics/AnalyticsFlowItem;", "statement", "common", "Lcom/couchbase/client/kotlin/CommonOptions;", "parameters", "Lcom/couchbase/client/kotlin/analytics/AnalyticsParameters;", "serializer", "Lcom/couchbase/client/kotlin/codec/JsonSerializer;", "consistency", "Lcom/couchbase/client/kotlin/analytics/AnalyticsScanConsistency;", "readonly", "priority", "Lcom/couchbase/client/kotlin/analytics/AnalyticsPriority;", "clientContextId", "raw", "", "bucket", "name", "disconnect", "", "timeout", "Lkotlin/time/Duration;", "disconnect-VtjQ1oo", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "query", "Lcom/couchbase/client/kotlin/query/QueryFlowItem;", "Lcom/couchbase/client/kotlin/query/QueryParameters;", "Lcom/couchbase/client/kotlin/query/QueryScanConsistency;", "adhoc", "flexIndex", "metrics", "profile", "Lcom/couchbase/client/kotlin/query/QueryProfile;", "maxParallelism", "", "scanCap", "pipelineBatch", "pipelineCap", "(Ljava/lang/String;Lcom/couchbase/client/kotlin/CommonOptions;Lcom/couchbase/client/kotlin/query/QueryParameters;Lcom/couchbase/client/kotlin/codec/JsonSerializer;Lcom/couchbase/client/kotlin/query/QueryScanConsistency;ZZZZLcom/couchbase/client/kotlin/query/QueryProfile;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/util/Map;)Lkotlinx/coroutines/flow/Flow;", "waitUntilReady", "services", "Lcom/couchbase/client/core/service/ServiceType;", "desiredState", "Lcom/couchbase/client/core/diagnostics/ClusterState;", "waitUntilReady-rnQQ1Ag", "(JLjava/util/Set;Lcom/couchbase/client/core/diagnostics/ClusterState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "kotlin-client"})
public final class Cluster {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean ownsEnvironment;
    @NotNull
    private final Authenticator authenticator;
    @NotNull
    private final Core core;
    @NotNull
    private final ConcurrentHashMap<String, Bucket> bucketCache;
    @NotNull
    private final QueryExecutor queryExecutor;
    @NotNull
    private final AnalyticsExecutor analyticsExecutor;

    public Cluster(@NotNull ClusterEnvironment environment, boolean ownsEnvironment, @NotNull Authenticator authenticator, @NotNull Set<? extends SeedNode> seedNodes) {
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        Intrinsics.checkNotNullParameter((Object)authenticator, (String)"authenticator");
        Intrinsics.checkNotNullParameter(seedNodes, (String)"seedNodes");
        this.ownsEnvironment = ownsEnvironment;
        this.authenticator = authenticator;
        Core core = Core.create((CoreEnvironment)environment, (Authenticator)this.authenticator, seedNodes);
        Intrinsics.checkNotNullExpressionValue((Object)core, (String)"create(environment, authenticator, seedNodes)");
        this.core = core;
        this.bucketCache = new ConcurrentHashMap();
        this.queryExecutor = new QueryExecutor(this.core, null, 2, null);
        this.analyticsExecutor = new AnalyticsExecutor(this.core, null, 2, null);
        this.core.initGlobalConfig();
    }

    @NotNull
    public final Core getCore$kotlin_client() {
        return this.core;
    }

    @NotNull
    public final ClusterEnvironment getEnv$kotlin_client() {
        return ClusterEnvironmentKt.getEnv(this.core);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object waitUntilReady-rnQQ1Ag(long var1_1, @NotNull Set<? extends ServiceType> var3_2, @NotNull ClusterState var4_3, @NotNull Continuation<? super Cluster> var5_4) {
        if (!(var5_4 instanceof waitUntilReady.1)) ** GOTO lbl-1000
        var10_5 = var5_4;
        if ((var10_5.label & -2147483648) != 0) {
            var10_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_4){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ Cluster this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.waitUntilReady-rnQQ1Ag(0L, null, null, (Continuation<? super Cluster>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getCore$kotlin_client();
                var7_8 = Duration.getNanosecondsComponent-impl((long)timeout);
                var8_9 = java.time.Duration.ofSeconds(Duration.getInWholeSeconds-impl((long)timeout), var7_8);
                Intrinsics.checkNotNullExpressionValue((Object)var8_9, (String)"toJavaDuration-LRDsOJo");
                var6_10 = WaitUntilReadyHelper.waitUntilReady((Core)v0, var3_2, (java.time.Duration)var8_9, (ClusterState)desiredState, Optional.empty());
                Intrinsics.checkNotNullExpressionValue((Object)var6_10, (String)"waitUntilReady(core, ser\u2026dState, Optional.empty())");
                $continuation.L$0 = this;
                $continuation.label = 1;
                v1 = FutureKt.await((CompletionStage)var6_10, (Continuation)$continuation);
                if (v1 == var11_7) {
                    return var11_7;
                }
                ** GOTO lbl28
            }
            case 1: {
                this = (Cluster)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl28:
                // 2 sources

                return this;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object waitUntilReady-rnQQ1Ag$default(Cluster cluster2, long l, Set set, ClusterState clusterState, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 4) != 0) {
            clusterState = ClusterState.ONLINE;
        }
        return cluster2.waitUntilReady-rnQQ1Ag(l, set, clusterState, (Continuation<? super Cluster>)continuation);
    }

    @NotNull
    public final Bucket bucket(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Bucket bucket = this.bucketCache.computeIfAbsent(name, arg_0 -> Cluster.bucket$lambda-0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)bucket, (String)"bucketCache.computeIfAbs\u2026et(key, this, core)\n    }");
        return bucket;
    }

    @NotNull
    public final Flow<QueryFlowItem> query(@NotNull String statement, @NotNull CommonOptions common, @NotNull QueryParameters parameters, @Nullable JsonSerializer serializer, @NotNull QueryScanConsistency consistency, boolean readonly, boolean adhoc, boolean flexIndex, boolean metrics, @NotNull QueryProfile profile, @Nullable Integer maxParallelism, @Nullable Integer scanCap, @Nullable Integer pipelineBatch, @Nullable Integer pipelineCap, @Nullable String clientContextId, @NotNull Map<String, ? extends Object> raw) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)common, (String)"common");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)consistency, (String)"consistency");
        Intrinsics.checkNotNullParameter((Object)((Object)profile), (String)"profile");
        Intrinsics.checkNotNullParameter(raw, (String)"raw");
        return this.queryExecutor.query(statement, common, parameters, serializer, consistency, readonly, adhoc, flexIndex, metrics, profile, maxParallelism, scanCap, pipelineBatch, pipelineCap, clientContextId, raw);
    }

    public static /* synthetic */ Flow query$default(Cluster cluster2, String string, CommonOptions commonOptions, QueryParameters queryParameters, JsonSerializer jsonSerializer, QueryScanConsistency queryScanConsistency, boolean bl, boolean bl2, boolean bl3, boolean bl4, QueryProfile queryProfile, Integer n, Integer n2, Integer n3, Integer n4, String string2, Map map2, int n5, Object object) {
        if ((n5 & 2) != 0) {
            commonOptions = CommonOptions.Companion.getDefault();
        }
        if ((n5 & 4) != 0) {
            queryParameters = QueryParameters.None.INSTANCE;
        }
        if ((n5 & 8) != 0) {
            jsonSerializer = null;
        }
        if ((n5 & 0x10) != 0) {
            queryScanConsistency = QueryScanConsistency.Companion.notBounded();
        }
        if ((n5 & 0x20) != 0) {
            bl = false;
        }
        if ((n5 & 0x40) != 0) {
            bl2 = true;
        }
        if ((n5 & 0x80) != 0) {
            bl3 = false;
        }
        if ((n5 & 0x100) != 0) {
            bl4 = false;
        }
        if ((n5 & 0x200) != 0) {
            queryProfile = QueryProfile.OFF;
        }
        if ((n5 & 0x400) != 0) {
            n = null;
        }
        if ((n5 & 0x800) != 0) {
            n2 = null;
        }
        if ((n5 & 0x1000) != 0) {
            n3 = null;
        }
        if ((n5 & 0x2000) != 0) {
            n4 = null;
        }
        if ((n5 & 0x4000) != 0) {
            string2 = UUID.randomUUID().toString();
        }
        if ((n5 & 0x8000) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return cluster2.query(string, commonOptions, queryParameters, jsonSerializer, queryScanConsistency, bl, bl2, bl3, bl4, queryProfile, n, n2, n3, n4, string2, map2);
    }

    @NotNull
    public final Flow<AnalyticsFlowItem> analyticsQuery(@NotNull String statement, @NotNull CommonOptions common, @NotNull AnalyticsParameters parameters, @Nullable JsonSerializer serializer, @NotNull AnalyticsScanConsistency consistency, boolean readonly, @NotNull AnalyticsPriority priority, @Nullable String clientContextId, @NotNull Map<String, ? extends Object> raw) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)common, (String)"common");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)consistency, (String)"consistency");
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        Intrinsics.checkNotNullParameter(raw, (String)"raw");
        return this.analyticsExecutor.query(statement, common, parameters, serializer, consistency, readonly, priority, clientContextId, raw);
    }

    public static /* synthetic */ Flow analyticsQuery$default(Cluster cluster2, String string, CommonOptions commonOptions, AnalyticsParameters analyticsParameters, JsonSerializer jsonSerializer, AnalyticsScanConsistency analyticsScanConsistency, boolean bl, AnalyticsPriority analyticsPriority, String string2, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            commonOptions = CommonOptions.Companion.getDefault();
        }
        if ((n & 4) != 0) {
            analyticsParameters = AnalyticsParameters.None.INSTANCE;
        }
        if ((n & 8) != 0) {
            jsonSerializer = null;
        }
        if ((n & 0x10) != 0) {
            analyticsScanConsistency = AnalyticsScanConsistency.Companion.notBounded();
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            analyticsPriority = AnalyticsPriority.Companion.normal();
        }
        if ((n & 0x80) != 0) {
            string2 = UUID.randomUUID().toString();
        }
        if ((n & 0x100) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return cluster2.analyticsQuery(string, commonOptions, analyticsParameters, jsonSerializer, analyticsScanConsistency, bl, analyticsPriority, string2, map2);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object disconnect-VtjQ1oo(long var1_1, @NotNull Continuation<? super Unit> var3_2) {
        if (!(var3_2 instanceof disconnect.1)) ** GOTO lbl-1000
        var8_3 = var3_2;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_2){
                Object L$0;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ Cluster this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.disconnect-VtjQ1oo(0L, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getCore$kotlin_client();
                var5_6 = Duration.getNanosecondsComponent-impl((long)timeout);
                var6_7 = java.time.Duration.ofSeconds(Duration.getInWholeSeconds-impl((long)timeout), var5_6);
                Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"toJavaDuration-LRDsOJo");
                var4_8 = v0.shutdown(var6_7);
                Intrinsics.checkNotNullExpressionValue((Object)var4_8, (String)"core.shutdown(timeout.toJavaDuration())");
                $continuation.L$0 = this;
                $continuation.J$0 = timeout;
                $continuation.label = 1;
                v1 = LangExtensionsKt.await((Mono<Void>)var4_8, (Continuation<? super Void>)$continuation);
                if (v1 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                timeout = $continuation.J$0;
                this = (Cluster)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl30:
                // 2 sources

                if (!this.ownsEnvironment) break;
                v2 = this.getCore$kotlin_client().context().environment();
                var5_6 = Duration.getNanosecondsComponent-impl((long)timeout);
                var6_7 = java.time.Duration.ofSeconds(Duration.getInWholeSeconds-impl((long)timeout), var5_6);
                Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"toJavaDuration-LRDsOJo");
                var4_8 = v2.shutdownReactive(var6_7);
                Intrinsics.checkNotNullExpressionValue((Object)var4_8, (String)"core.context().environme\u2026timeout.toJavaDuration())");
                $continuation.L$0 = null;
                $continuation.label = 2;
                v3 = LangExtensionsKt.await((Mono<Void>)var4_8, (Continuation<? super Void>)$continuation);
                if (v3 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl46
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl46:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object disconnect-VtjQ1oo$default(Cluster cluster2, long l, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            java.time.Duration duration = cluster2.getCore$kotlin_client().context().environment().timeoutConfig().disconnectTimeout();
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"fun disconnect(\n        \u2026).await()\n        }\n    }");
            l = Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration.getNano(), (DurationUnit)DurationUnit.NANOSECONDS));
        }
        return cluster2.disconnect-VtjQ1oo(l, (Continuation<? super Unit>)continuation);
    }

    private static final Bucket bucket$lambda-0(Cluster this$0, String key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this$0.core.openBucket(key);
        return new Bucket(key, this$0, this$0.core);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ3\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u001b\u0010\u000b\u001a\u0017\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000f\u00a2\u0006\u0002\b\u0010J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\nJ;\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u001b\u0010\u000b\u001a\u0017\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000f\u00a2\u0006\u0002\b\u0010J\u001e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015J&\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015J(\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/couchbase/client/kotlin/Cluster$Companion;", "", "()V", "connect", "Lcom/couchbase/client/kotlin/Cluster;", "connectionString", "", "authenticator", "Lcom/couchbase/client/core/env/Authenticator;", "envBuilder", "Lcom/couchbase/client/kotlin/env/ClusterEnvironment$Builder;", "envConfigBlock", "Lkotlin/Function1;", "Lcom/couchbase/client/kotlin/env/dsl/ClusterEnvironmentDslBuilder;", "", "Lcom/couchbase/client/kotlin/env/dsl/ClusterEnvironmentConfigBlock;", "Lkotlin/ExtensionFunctionType;", "username", "password", "connectUsingSharedEnvironment", "env", "Lcom/couchbase/client/kotlin/env/ClusterEnvironment;", "doConnect", "ownsEnv", "", "kotlin-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Cluster connect(@NotNull String connectionString, @NotNull String username, @NotNull String password, @NotNull Function1<? super ClusterEnvironmentDslBuilder, Unit> envConfigBlock) {
            Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            Intrinsics.checkNotNullParameter(envConfigBlock, (String)"envConfigBlock");
            return this.connect(connectionString, username, password, ClusterEnvironment.Companion.builder(envConfigBlock));
        }

        @NotNull
        public final Cluster connect(@NotNull String connectionString, @NotNull String username, @NotNull String password, @NotNull ClusterEnvironment.Builder envBuilder) {
            Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            Intrinsics.checkNotNullParameter((Object)((Object)envBuilder), (String)"envBuilder");
            PasswordAuthenticator passwordAuthenticator = PasswordAuthenticator.create((String)username, (String)password);
            Intrinsics.checkNotNullExpressionValue((Object)passwordAuthenticator, (String)"create(username, password)");
            return this.connect(connectionString, (Authenticator)passwordAuthenticator, envBuilder);
        }

        public static /* synthetic */ Cluster connect$default(Companion companion, String string, String string2, String string3, ClusterEnvironment.Builder builder2, int n, Object object) {
            if ((n & 8) != 0) {
                builder2 = ClusterEnvironment.Companion.builder$default(ClusterEnvironment.Companion, null, 1, null);
            }
            return companion.connect(string, string2, string3, builder2);
        }

        @NotNull
        public final Cluster connect(@NotNull String connectionString, @NotNull Authenticator authenticator, @NotNull Function1<? super ClusterEnvironmentDslBuilder, Unit> envConfigBlock) {
            Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
            Intrinsics.checkNotNullParameter((Object)authenticator, (String)"authenticator");
            Intrinsics.checkNotNullParameter(envConfigBlock, (String)"envConfigBlock");
            return this.connect(connectionString, authenticator, ClusterEnvironment.Companion.builder(envConfigBlock));
        }

        @NotNull
        public final Cluster connect(@NotNull String connectionString, @NotNull Authenticator authenticator, @NotNull ClusterEnvironment.Builder envBuilder) {
            Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
            Intrinsics.checkNotNullParameter((Object)authenticator, (String)"authenticator");
            Intrinsics.checkNotNullParameter((Object)((Object)envBuilder), (String)"envBuilder");
            envBuilder.load((PropertyLoader)new ConnectionStringPropertyLoader(connectionString));
            return this.doConnect(connectionString, authenticator, envBuilder.build(), true);
        }

        public static /* synthetic */ Cluster connect$default(Companion companion, String string, Authenticator authenticator, ClusterEnvironment.Builder builder2, int n, Object object) {
            if ((n & 4) != 0) {
                builder2 = ClusterEnvironment.Companion.builder$default(ClusterEnvironment.Companion, null, 1, null);
            }
            return companion.connect(string, authenticator, builder2);
        }

        @NotNull
        public final Cluster connectUsingSharedEnvironment(@NotNull String connectionString, @NotNull String username, @NotNull String password, @NotNull ClusterEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            Intrinsics.checkNotNullParameter((Object)((Object)env), (String)"env");
            PasswordAuthenticator passwordAuthenticator = PasswordAuthenticator.create((String)username, (String)password);
            Intrinsics.checkNotNullExpressionValue((Object)passwordAuthenticator, (String)"create(username, password)");
            return this.connectUsingSharedEnvironment(connectionString, (Authenticator)passwordAuthenticator, env);
        }

        @NotNull
        public final Cluster connectUsingSharedEnvironment(@NotNull String connectionString, @NotNull Authenticator authenticator, @NotNull ClusterEnvironment env) {
            ConnectionString connectionString2;
            Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
            Intrinsics.checkNotNullParameter((Object)authenticator, (String)"authenticator");
            Intrinsics.checkNotNullParameter((Object)((Object)env), (String)"env");
            ConnectionString $this$connectUsingSharedEnvironment_u24lambda_u2d2 = connectionString2 = ConnectionString.create((String)connectionString);
            boolean bl = false;
            if (!($this$connectUsingSharedEnvironment_u24lambda_u2d2.scheme() != ConnectionString.Scheme.COUCHBASES || env.securityConfig().tlsEnabled())) {
                boolean $i$a$-require-Cluster$Companion$connectUsingSharedEnvironment$1$32 = false;
                String $i$a$-require-Cluster$Companion$connectUsingSharedEnvironment$1$32 = "Connection string scheme indicates a secure connection, but the shared cluster environment was not configured for TLS.";
                throw new IllegalArgumentException($i$a$-require-Cluster$Companion$connectUsingSharedEnvironment$1$32.toString());
            }
            if (!$this$connectUsingSharedEnvironment_u24lambda_u2d2.params().isEmpty()) {
                boolean bl2 = false;
                String string = "Can't use a shared cluster environment with a connection string that has parameters.";
                throw new IllegalArgumentException(string.toString());
            }
            return this.doConnect(connectionString, authenticator, env, false);
        }

        private final Cluster doConnect(String connectionString, Authenticator authenticator, ClusterEnvironment env, boolean ownsEnv) {
            Set seedNodes = ConnectionStringUtil.seedNodesFromConnectionString((String)connectionString, (boolean)env.ioConfig().dnsSrvEnabled(), (boolean)env.securityConfig().tlsEnabled(), (EventBus)env.eventBus());
            Intrinsics.checkNotNullExpressionValue((Object)seedNodes, (String)"seedNodes");
            return new Cluster(env, ownsEnv, authenticator, seedNodes);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

