/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.kv;

import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.core.msg.kv.SubDocumentField;
import com.couchbase.client.kotlin.internal.LangExtensionsKt;
import com.couchbase.client.kotlin.kv.LookupInResultKt;
import com.couchbase.client.kotlin.kv.MutateInResult;
import com.couchbase.client.kotlin.kv.MutateInSpec;
import com.couchbase.client.kotlin.kv.MutationResult;
import com.couchbase.client.kotlin.kv.SubdocLong;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u001aR\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000e\u001a\u00020\b*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/couchbase/client/kotlin/kv/MutateInResult;", "Lcom/couchbase/client/kotlin/kv/MutationResult;", "size", "", "fields", "", "Lcom/couchbase/client/core/msg/kv/SubDocumentField;", "cas", "", "mutationToken", "Lcom/couchbase/client/core/msg/kv/MutationToken;", "spec", "Lcom/couchbase/client/kotlin/kv/MutateInSpec;", "(ILjava/util/List;JLcom/couchbase/client/core/msg/kv/MutationToken;Lcom/couchbase/client/kotlin/kv/MutateInSpec;)V", "value", "Lcom/couchbase/client/kotlin/kv/SubdocLong;", "getValue", "(Lcom/couchbase/client/kotlin/kv/SubdocLong;)J", "checkSpec", "", "content", "", "subdoc", "content$kotlin_client", "get", "index", "get$kotlin_client", "kotlin-client"})
public final class MutateInResult
extends MutationResult {
    private final int size;
    @NotNull
    private final List<SubDocumentField> fields;
    @NotNull
    private final MutateInSpec spec;

    public MutateInResult(int size, @NotNull List<? extends SubDocumentField> fields, long cas, @Nullable MutationToken mutationToken, @NotNull MutateInSpec spec2) {
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Intrinsics.checkNotNullParameter((Object)spec2, (String)"spec");
        super(cas, mutationToken);
        this.size = size;
        this.fields = fields;
        this.spec = spec2;
    }

    public final long getValue(@NotNull SubdocLong $this$value) {
        Intrinsics.checkNotNullParameter((Object)$this$value, (String)"<this>");
        String string = LangExtensionsKt.toStringUtf8(this.content$kotlin_client($this$value));
        boolean bl = false;
        return Long.parseLong(string);
    }

    @NotNull
    public final SubDocumentField get$kotlin_client(int index) {
        LookupInResultKt.checkIndex(index, RangesKt.until((int)0, (int)this.size));
        SubDocumentField subDocumentField = this.fields.get(index);
        if (subDocumentField == null) {
            throw new NoSuchElementException(Intrinsics.stringPlus((String)"No subdoc value at index ", (Object)index));
        }
        SubDocumentField field = subDocumentField;
        field.error().map(get.1.INSTANCE);
        return field;
    }

    @NotNull
    public final byte[] content$kotlin_client(@NotNull SubdocLong subdoc) {
        Intrinsics.checkNotNullParameter((Object)subdoc, (String)"subdoc");
        this.checkSpec(subdoc.getSpec$kotlin_client());
        byte[] byArray = this.get$kotlin_client(subdoc.getIndex$kotlin_client()).value();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"get(subdoc.index).value()");
        return byArray;
    }

    private final void checkSpec(MutateInSpec spec2) {
        boolean bl = Intrinsics.areEqual((Object)spec2, (Object)this.spec);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Subdoc was not created from the same MutateInSpec as this result.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }
}

