/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.codec;

import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.kotlin.codec.Content;
import com.couchbase.client.kotlin.codec.Transcoder;
import com.couchbase.client.kotlin.codec.TypeRef;
import com.couchbase.client.kotlin.internal.LangExtensionsKt;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH\u0016\u00a2\u0006\u0002\u0010\tJ)\u0010\n\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u000b\u001a\u0002H\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/couchbase/client/kotlin/codec/RawJsonTranscoder;", "Lcom/couchbase/client/kotlin/codec/Transcoder;", "()V", "decode", "T", "content", "Lcom/couchbase/client/kotlin/codec/Content;", "type", "Lcom/couchbase/client/kotlin/codec/TypeRef;", "(Lcom/couchbase/client/kotlin/codec/Content;Lcom/couchbase/client/kotlin/codec/TypeRef;)Ljava/lang/Object;", "doEncode", "input", "(Ljava/lang/Object;Lcom/couchbase/client/kotlin/codec/TypeRef;)Lcom/couchbase/client/kotlin/codec/Content;", "kotlin-client"})
public final class RawJsonTranscoder
implements Transcoder {
    @NotNull
    public static final RawJsonTranscoder INSTANCE = new RawJsonTranscoder();

    private RawJsonTranscoder() {
    }

    @Override
    @NotNull
    public <T> Content doEncode(T input, @NotNull TypeRef<T> type) {
        Content content;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        T t = input;
        if (t instanceof byte[]) {
            content = Content.Companion.json((byte[])input);
        } else if (t instanceof String) {
            content = Content.Companion.json((String)input);
        } else {
            InvalidArgumentException invalidArgumentException = InvalidArgumentException.fromMessage((String)"Only ByteArray and String types are supported for the RawJsonTranscoder!");
            Intrinsics.checkNotNullExpressionValue((Object)invalidArgumentException, (String)"fromMessage(\n                \"Only ByteArray and String types are supported for the RawJsonTranscoder!\"\n            )");
            throw (Throwable)invalidArgumentException;
        }
        return content;
    }

    @Override
    public <T> T decode(@NotNull Content content, @NotNull TypeRef<T> type) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Type type2 = type.getType();
        if (Intrinsics.areEqual((Object)type2, byte[].class)) {
            object = content.getBytes();
        } else if (Intrinsics.areEqual((Object)type2, String.class)) {
            object = LangExtensionsKt.toStringUtf8(content.getBytes());
        } else {
            throw new DecodingFailureException("RawJsonTranscoder can only decode into either ByteArray or String!");
        }
        return (T)object;
    }

    @Override
    @NotNull
    public <T> Content encode(T input, @NotNull TypeRef<T> type) {
        return Transcoder.DefaultImpls.encode(this, input, type);
    }
}

