/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.result;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.result.CoreSearchRowLocation;
import com.couchbase.client.core.api.search.result.CoreSearchRowLocations;
import com.couchbase.client.java.search.result.SearchRowLocation;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Stability.Volatile
public class SearchRowLocations {
    private final CoreSearchRowLocations internal;
    private int size;

    @Stability.Internal
    public SearchRowLocations(CoreSearchRowLocations locations) {
        this.internal = locations;
    }

    private static List<SearchRowLocation> convert(List<CoreSearchRowLocation> locations) {
        return locations.stream().map(SearchRowLocation::new).collect(Collectors.toList());
    }

    public List<SearchRowLocation> get(String field) {
        return SearchRowLocations.convert(this.internal.get(field));
    }

    public List<SearchRowLocation> get(String field, String term) {
        return SearchRowLocations.convert(this.internal.get(field, term));
    }

    public List<SearchRowLocation> getAll() {
        return SearchRowLocations.convert(this.internal.getAll());
    }

    public List<String> fields() {
        return this.internal.fields();
    }

    public List<String> termsFor(String field) {
        return this.internal.termsFor(field);
    }

    public Set<String> terms() {
        return this.internal.terms();
    }

    public String toString() {
        return this.internal.toString();
    }
}

