/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.result;

import com.couchbase.client.core.api.search.result.CoreSearchResult;
import com.couchbase.client.core.api.search.result.CoreSearchRow;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.search.SearchMetaData;
import com.couchbase.client.java.search.result.SearchFacetResult;
import com.couchbase.client.java.search.result.SearchRow;
import com.couchbase.client.java.search.util.SearchFacetUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SearchResult {
    private final CoreSearchResult internal;
    private final JsonSerializer serializer;

    public SearchResult(CoreSearchResult internal, JsonSerializer serializer) {
        this.internal = internal;
        this.serializer = serializer;
    }

    public SearchMetaData metaData() {
        return new SearchMetaData(this.internal.metaData());
    }

    public List<SearchRow> rows() {
        return this.internal.rows().stream().map(row -> new SearchRow((CoreSearchRow)row, this.serializer)).collect(Collectors.toList());
    }

    public Map<String, SearchFacetResult> facets() {
        HashMap<String, SearchFacetResult> out = new HashMap<String, SearchFacetResult>();
        this.internal.facets().forEach((k, v) -> out.put((String)k, SearchFacetUtil.convert(v)));
        return out;
    }

    public String toString() {
        return this.internal.toString();
    }
}

