/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.queries;

import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.api.search.queries.CoreMatchOperator;
import com.couchbase.client.core.api.search.queries.CoreMatchQuery;
import com.couchbase.client.java.search.SearchQuery;
import com.couchbase.client.java.search.queries.MatchOperator;

public class MatchQuery
extends SearchQuery {
    private final String match;
    private String field;
    private String analyzer;
    private Integer prefixLength;
    private Integer fuzziness;
    private CoreMatchOperator operator;

    public MatchQuery(String match) {
        this.match = match;
    }

    @Override
    public MatchQuery boost(double boost) {
        super.boost(boost);
        return this;
    }

    public MatchQuery field(String field) {
        this.field = field;
        return this;
    }

    public MatchQuery analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public MatchQuery prefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    public MatchQuery fuzziness(int fuzziness) {
        this.fuzziness = fuzziness;
        return this;
    }

    public MatchQuery operator(MatchOperator operator) {
        this.operator = operator == MatchOperator.OR ? CoreMatchOperator.OR : CoreMatchOperator.AND;
        return this;
    }

    @Override
    public CoreSearchQuery toCore() {
        return new CoreMatchQuery(this.match, this.field, this.analyzer, this.prefixLength, this.fuzziness, this.operator, this.boost);
    }
}

