/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.TypeRef;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.query.QueryMetaData;
import java.util.List;
import java.util.stream.Collectors;

public class QueryResult {
    private final JsonSerializer serializer;
    private final CoreQueryResult internal;

    @Stability.Internal
    public QueryResult(CoreQueryResult internal, JsonSerializer serializer) {
        this.internal = internal;
        this.serializer = serializer;
    }

    public List<JsonObject> rowsAsObject() {
        return this.rowsAs(JsonObject.class);
    }

    public <T> List<T> rowsAs(Class<T> target) {
        return this.internal.rows().map(row -> this.serializer.deserialize(target, row.data())).collect(Collectors.toList());
    }

    public <T> List<T> rowsAs(TypeRef<T> target) {
        return this.internal.rows().map(row -> this.serializer.deserialize(target, row.data())).collect(Collectors.toList());
    }

    public QueryMetaData metaData() {
        return new QueryMetaData(this.internal.metaData());
    }
}

