/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.java.kv.CommonDurabilityOptions;
import com.couchbase.client.java.kv.Expiry;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;

public class IncrementOptions
extends CommonDurabilityOptions<IncrementOptions> {
    private long delta = 1L;
    private Optional<Long> initial = Optional.empty();
    private Expiry expiry = Expiry.none();

    public static IncrementOptions incrementOptions() {
        return new IncrementOptions();
    }

    private IncrementOptions() {
    }

    public IncrementOptions delta(long delta) {
        if (delta < 0L) {
            throw InvalidArgumentException.fromMessage((String)"The delta cannot be less than 0");
        }
        this.delta = delta;
        return this;
    }

    public IncrementOptions initial(long initial) {
        this.initial = Optional.of(initial);
        return this;
    }

    public IncrementOptions expiry(Duration expiry) {
        this.expiry = Expiry.relative(expiry);
        return this;
    }

    public IncrementOptions expiry(Instant expiry) {
        this.expiry = Expiry.absolute(expiry);
        return this;
    }

    @Stability.Internal
    public Built build() {
        return new Built();
    }

    public class Built
    extends CommonDurabilityOptions.BuiltCommonDurabilityOptions {
        Built() {
            super(IncrementOptions.this);
        }

        public Expiry expiry() {
            return IncrementOptions.this.expiry;
        }

        public Optional<Long> initial() {
            return IncrementOptions.this.initial;
        }

        public long delta() {
            return IncrementOptions.this.delta;
        }
    }
}

