/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.codec;

import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.java.codec.Transcoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SerializableTranscoder
implements Transcoder {
    public static SerializableTranscoder INSTANCE = new SerializableTranscoder();

    private SerializableTranscoder() {
    }

    @Override
    public Transcoder.EncodedValue encode(Object input) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bos);
            os.writeObject(input);
            byte[] serialized = bos.toByteArray();
            os.close();
            bos.close();
            return new Transcoder.EncodedValue(serialized, CodecFlags.SERIALIZED_COMPAT_FLAGS);
        }
        catch (Exception ex) {
            throw InvalidArgumentException.fromMessage((String)"Could not encode (serialize) the given object!", (Throwable)ex);
        }
    }

    @Override
    public <T> T decode(Class<T> target, byte[] input, int flags) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(input);
            ObjectInputStream is = new ObjectInputStream(bis);
            Object deserialized = is.readObject();
            is.close();
            bis.close();
            return (T)deserialized;
        }
        catch (Exception ex) {
            throw InvalidArgumentException.fromMessage((String)"Could not decode (deserialize) the given object!", (Throwable)ex);
        }
    }
}

