/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.view;

import com.couchbase.client.java.AsyncUtils;
import com.couchbase.client.java.manager.view.AsyncViewIndexManager;
import com.couchbase.client.java.manager.view.DesignDocument;
import com.couchbase.client.java.manager.view.DropDesignDocumentOptions;
import com.couchbase.client.java.manager.view.GetAllDesignDocumentsOptions;
import com.couchbase.client.java.manager.view.GetDesignDocumentOptions;
import com.couchbase.client.java.manager.view.PublishDesignDocumentOptions;
import com.couchbase.client.java.manager.view.UpsertDesignDocumentOptions;
import com.couchbase.client.java.view.DesignDocumentNamespace;
import java.util.List;
import java.util.Objects;

public class ViewIndexManager {
    private final AsyncViewIndexManager async;

    public ViewIndexManager(AsyncViewIndexManager async) {
        this.async = Objects.requireNonNull(async);
    }

    public AsyncViewIndexManager async() {
        return this.async;
    }

    public DesignDocument getDesignDocument(String name, DesignDocumentNamespace namespace) {
        return AsyncUtils.block(this.async.getDesignDocument(name, namespace));
    }

    public DesignDocument getDesignDocument(String name, DesignDocumentNamespace namespace, GetDesignDocumentOptions options) {
        return AsyncUtils.block(this.async.getDesignDocument(name, namespace, options));
    }

    public void upsertDesignDocument(DesignDocument designDocument, DesignDocumentNamespace namespace) {
        AsyncUtils.block(this.async.upsertDesignDocument(designDocument, namespace));
    }

    public void upsertDesignDocument(DesignDocument designDocument, DesignDocumentNamespace namespace, UpsertDesignDocumentOptions options) {
        AsyncUtils.block(this.async.upsertDesignDocument(designDocument, namespace, options));
    }

    public void publishDesignDocument(String name) {
        AsyncUtils.block(this.async.publishDesignDocument(name));
    }

    public void publishDesignDocument(String name, PublishDesignDocumentOptions options) {
        AsyncUtils.block(this.async.publishDesignDocument(name, options));
    }

    public void dropDesignDocument(String name, DesignDocumentNamespace namespace) {
        AsyncUtils.block(this.async.dropDesignDocument(name, namespace));
    }

    public void dropDesignDocument(String name, DesignDocumentNamespace namespace, DropDesignDocumentOptions options) {
        AsyncUtils.block(this.async.dropDesignDocument(name, namespace, options));
    }

    public List<DesignDocument> getAllDesignDocuments(DesignDocumentNamespace namespace) {
        return AsyncUtils.block(this.async.getAllDesignDocuments(namespace));
    }

    public List<DesignDocument> getAllDesignDocuments(DesignDocumentNamespace namespace, GetAllDesignDocumentsOptions options) {
        return AsyncUtils.block(this.async.getAllDesignDocuments(namespace, options));
    }
}

