/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption;

import com.couchbase.client.encryption.CryptoProvider;
import com.couchbase.client.encryption.KeyStoreProvider;
import com.couchbase.client.encryption.errors.CryptoProviderMissingPrivateKeyException;
import com.couchbase.client.encryption.errors.CryptoProviderMissingPublicKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public class RSACryptoProvider
implements CryptoProvider {
    private KeyStoreProvider keyStoreProvider;
    private final String CRYPTO_ALG = "RSA/ECB/OAEPWithSHA-1AndMGF1Padding";
    public static final String ALG_NAME = "RSA-2048-OAEP-SHA1";
    private String alias;

    public RSACryptoProvider(KeyStoreProvider provider) {
        this.keyStoreProvider = provider;
    }

    public KeyStoreProvider getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public void setKeyStoreProvider(KeyStoreProvider provider) {
        this.keyStoreProvider = provider;
    }

    public byte[] encrypt(byte[] data) throws Exception {
        if (this.keyStoreProvider.publicKeyName() == null) {
            throw new CryptoProviderMissingPublicKeyException("Cryptographic providers require a non-null, empty public and key identifier (kid) be configured for the alias: " + this.alias);
        }
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
        cipher.init(1, this.getPublicKey(this.keyStoreProvider.publicKeyName()));
        return cipher.doFinal(data);
    }

    public int getIVSize() {
        return 0;
    }

    public byte[] decrypt(byte[] encrypted) throws Exception {
        if (this.keyStoreProvider.privateKeyName() == null) {
            throw new CryptoProviderMissingPrivateKeyException("Asymmetric key cryptographic providers require a non-null, empty private key be configured for the alias: " + this.alias);
        }
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
        OAEPParameterSpec oaepParams = new OAEPParameterSpec("SHA-1", "MGF1", new MGF1ParameterSpec("SHA-1"), PSource.PSpecified.DEFAULT);
        cipher.init(2, (Key)this.getPrivateKey(this.keyStoreProvider.privateKeyName()), oaepParams);
        return cipher.doFinal(encrypted);
    }

    public byte[] getSignature(byte[] message) {
        return null;
    }

    public boolean verifySignature(byte[] message, byte[] signature) {
        return false;
    }

    private RSAPrivateKey getPrivateKey(String keyName) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(this.keyStoreProvider.getKey(keyName));
        return (RSAPrivateKey)keyFactory.generatePrivate(privateKeySpec);
    }

    private RSAPublicKey getPublicKey(String keyName) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(this.keyStoreProvider.getKey(keyName));
        return (RSAPublicKey)keyFactory.generatePublic(publicKeySpec);
    }

    public String getProviderAlgorithmName() {
        return ALG_NAME;
    }

    public String getProviderName() {
        return ALG_NAME;
    }

    public boolean checkAlgorithmNameMatch(String name) {
        return name.contentEquals(ALG_NAME) || name.contentEquals("RSA-2048");
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
}

