/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption;

import com.couchbase.client.encryption.KeyStoreProvider;
import java.io.InputStream;
import java.security.KeyStore;
import javax.crypto.SecretKey;

public class JceksKeyStoreProvider
implements KeyStoreProvider {
    private final KeyStore ks = KeyStore.getInstance("JCEKS");
    private String keyPassword;
    private String publicKeyName;
    private String privateKeyName;
    private String signingKeyName;

    public JceksKeyStoreProvider() throws Exception {
        this(null);
    }

    public JceksKeyStoreProvider(String keyPassword) throws Exception {
        this(null, null, keyPassword);
    }

    public JceksKeyStoreProvider(InputStream stream, char[] password, String keyPassword) throws Exception {
        this.ks.load(stream, password);
        this.keyPassword = keyPassword;
        System.setProperty("jceks.key.serialFilter", "javax.crypto.spec.SecretKeySpec");
    }

    private KeyStore.PasswordProtection getProtection(String keyName) {
        KeyStore.PasswordProtection protection = this.keyPassword == null ? new KeyStore.PasswordProtection(this.getHashedString(keyName).toCharArray()) : new KeyStore.PasswordProtection(this.keyPassword.toCharArray());
        return protection;
    }

    @Override
    public byte[] getKey(String keyName) throws Exception {
        KeyStore.SecretKeyEntry entry = (KeyStore.SecretKeyEntry)this.ks.getEntry(keyName, this.getProtection(keyName));
        return entry.getSecretKey().getEncoded();
    }

    @Override
    public void storeKey(String keyName, byte[] secretKey) throws Exception {
        SimpleSecretKey secretKeyEntry = new SimpleSecretKey(secretKey);
        this.ks.setEntry(keyName, new KeyStore.SecretKeyEntry(secretKeyEntry), this.getProtection(keyName));
    }

    @Override
    public String publicKeyName() {
        return this.publicKeyName;
    }

    @Override
    public void publicKeyName(String name) {
        this.publicKeyName = name;
    }

    @Override
    public String privateKeyName() {
        return this.privateKeyName;
    }

    @Override
    public void privateKeyName(String name) {
        this.privateKeyName = name;
    }

    @Override
    public String signingKeyName() {
        return this.signingKeyName;
    }

    @Override
    public void signingKeyName(String name) {
        this.signingKeyName = name;
    }

    private String getHashedString(String keyName) {
        int hash = 7;
        for (int i = 0; i < keyName.length(); ++i) {
            hash = hash * 31 + keyName.charAt(i);
        }
        return Integer.toString(hash);
    }

    private static class SimpleSecretKey
    implements SecretKey {
        private final byte[] secret;

        public SimpleSecretKey(byte[] secret) {
            this.secret = secret;
        }

        @Override
        public String getAlgorithm() {
            return "CUSTOM";
        }

        @Override
        public String getFormat() {
            return "RAW";
        }

        @Override
        public byte[] getEncoded() {
            return this.secret;
        }
    }
}

