/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class LangHelper {
    public static <T extends Throwable> void throwIfInstanceOf(Throwable t2, Class<T> clazz) throws T {
        Objects.requireNonNull(t2);
        if (clazz.isInstance(t2)) {
            throw (Throwable)clazz.cast(t2);
        }
    }

    public static String removeStart(String s2, String removeMe) {
        if (s2 == null || removeMe == null) {
            return s2;
        }
        return s2.startsWith(removeMe) ? s2.substring(removeMe.length()) : s2;
    }

    public static String nullToEmpty(String s2) {
        return s2 == null ? "" : s2;
    }

    public static <T> T defaultIfNull(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static <T> T defaultIfNull(T value, Supplier<? extends T> defaultValueSupplier) {
        Objects.requireNonNull(defaultValueSupplier);
        return value == null ? defaultValueSupplier.get() : value;
    }

    public static boolean isNullOrEmpty(String s2) {
        return s2 == null || s2.isEmpty();
    }

    public static <T> List<T> copyToUnmodifiableList(Collection<T> c) {
        return LangHelper.isNullOrEmpty(c) ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<T>(c));
    }

    public static boolean isNullOrEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static String substringBetween(String s2, String prefix, String suffix) {
        if (s2 == null || prefix == null || suffix == null) {
            return null;
        }
        int prefixIndex = s2.indexOf(prefix);
        if (prefixIndex == -1) {
            return null;
        }
        int suffixIndex = s2.indexOf(suffix, prefixIndex + prefix.length());
        if (suffixIndex == -1) {
            return null;
        }
        return s2.substring(prefixIndex + prefix.length(), suffixIndex);
    }
}

