/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption.internal;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jdk8Cleaner {
    private static final Logger log = LoggerFactory.getLogger(Jdk8Cleaner.class);
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private final Set<CleanableImpl> references = Collections.newSetFromMap(new ConcurrentHashMap());

    public static Jdk8Cleaner create(ThreadFactory factory) {
        return new Jdk8Cleaner(factory);
    }

    private Jdk8Cleaner(ThreadFactory factory) {
        Thread thread = factory.newThread(this::doRun);
        thread.start();
    }

    public Cleanable register(Object obj, Runnable cleaningAction) {
        CleanableImpl cleanable = new CleanableImpl(obj, this.queue, cleaningAction);
        this.references.add(cleanable);
        return cleanable;
    }

    private void doRun() {
        try {
            while (true) {
                CleanableImpl r = (CleanableImpl)this.queue.remove();
                this.references.remove(r);
                r.clean();
            }
        }
        catch (InterruptedException e) {
            log.info("Cleaner thread interrupted; exiting.");
            return;
        }
    }

    private static class CleanableImpl
    extends PhantomReference<Object>
    implements Cleanable {
        private final Runnable cleaningAction;
        private final AtomicBoolean alreadyCleaned = new AtomicBoolean();

        CleanableImpl(Object referent, ReferenceQueue<Object> q, Runnable cleaningAction) {
            super(referent, q);
            this.cleaningAction = Objects.requireNonNull(cleaningAction);
        }

        @Override
        public void clean() {
            if (this.alreadyCleaned.compareAndSet(false, true)) {
                try {
                    this.cleaningAction.run();
                }
                catch (Throwable t2) {
                    log.error("Cleaning action threw exception", t2);
                }
            }
        }
    }

    public static interface Cleanable {
        public void clean();
    }
}

