/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption.internal;

import com.couchbase.client.encryption.errors.InvalidCiphertextException;
import com.couchbase.client.encryption.errors.InvalidCryptoKeyException;
import com.couchbase.client.encryption.internal.CryptoFactory;
import com.couchbase.client.encryption.internal.LangHelper;
import com.couchbase.client.encryption.internal.ZeroizableSecretKey;
import com.couchbase.client.encryption.internal.Zeroizer;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;

public class AeadAes256CbcHmacSha512Cipher {
    private static final int AUTH_TAG_LEN = 32;
    private static final int IV_LEN = 16;
    private final SecureRandom secureRandom;
    private final CryptoFactory cryptoFactory;

    public AeadAes256CbcHmacSha512Cipher() {
        this(null, null);
    }

    public AeadAes256CbcHmacSha512Cipher(SecureRandom secureRandom, Provider securityProvider) {
        this.cryptoFactory = new CryptoFactory(securityProvider);
        this.secureRandom = LangHelper.defaultIfNull(secureRandom, SecureRandom::new);
        this.failFastIfMissingAlgorithms();
    }

    private void failFastIfMissingAlgorithms() {
        try {
            this.newHmacSha512();
            this.newAesCscPkcs7();
        }
        catch (Exception e) {
            throw new RuntimeException("Security provider does not support required crypto algorithm.", e);
        }
    }

    public byte[] encrypt(byte[] key, byte[] plaintext, byte[] associatedData) throws Exception {
        AeadAes256CbcHmacSha512Cipher.checkKeyLength(key);
        try (Zeroizer zeroizer = new Zeroizer();){
            byte[] macKey = zeroizer.add(Arrays.copyOfRange(key, 0, 32));
            byte[] encKey = zeroizer.add(Arrays.copyOfRange(key, 32, 64));
            byte[] enc = this.encryptAesCbcPkcs7(encKey, plaintext);
            byte[] associatedDataLengthInBits = AeadAes256CbcHmacSha512Cipher.longToBytes(AeadAes256CbcHmacSha512Cipher.lengthInBits(associatedData));
            byte[] mac = zeroizer.add(this.hmacSha512(macKey, associatedData, enc, associatedDataLengthInBits));
            byte[] authTag = AeadAes256CbcHmacSha512Cipher.truncate(mac, 32);
            byte[] byArray = AeadAes256CbcHmacSha512Cipher.concat(enc, authTag);
            return byArray;
        }
    }

    public byte[] decrypt(byte[] key, byte[] ciphertext, byte[] associatedData) throws Exception {
        AeadAes256CbcHmacSha512Cipher.checkKeyLength(key);
        try (Zeroizer zeroizer = new Zeroizer();){
            byte[] macKey = zeroizer.add(Arrays.copyOfRange(key, 0, 32));
            byte[] encKey = zeroizer.add(Arrays.copyOfRange(key, 32, 64));
            int authTagOffset = ciphertext.length - 32;
            byte[] enc = Arrays.copyOfRange(ciphertext, 0, authTagOffset);
            byte[] authTag = Arrays.copyOfRange(ciphertext, authTagOffset, authTagOffset + 32);
            byte[] associatedDataLengthInBits = AeadAes256CbcHmacSha512Cipher.longToBytes(AeadAes256CbcHmacSha512Cipher.lengthInBits(associatedData));
            byte[] computedMac = zeroizer.add(this.hmacSha512(macKey, associatedData, enc, associatedDataLengthInBits));
            byte[] computedAuthTag = AeadAes256CbcHmacSha512Cipher.truncate(computedMac, 32);
            if (!MessageDigest.isEqual(authTag, computedAuthTag)) {
                throw new InvalidCiphertextException("Failed to authenticate the ciphertext and associated data.");
            }
            byte[] byArray = this.decryptAesCbcPkcs7(encKey, enc);
            return byArray;
        }
    }

    private static void checkKeyLength(byte[] key) {
        if (key.length != 64) {
            throw new InvalidCryptoKeyException("Expected key to be 64 bytes but got " + key.length + " bytes.");
        }
    }

    private byte[] encryptAesCbcPkcs7(byte[] key, byte[] plaintext) throws GeneralSecurityException {
        byte[] iv = new byte[16];
        this.secureRandom.nextBytes(iv);
        Cipher cipher = this.newAesCscPkcs7();
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        try (ZeroizableSecretKey secretKey = new ZeroizableSecretKey(key, "AES");){
            cipher.init(1, (Key)secretKey, ivSpec);
            byte[] ciphertext = cipher.doFinal(plaintext);
            byte[] byArray = AeadAes256CbcHmacSha512Cipher.concat(iv, ciphertext);
            return byArray;
        }
    }

    private byte[] decryptAesCbcPkcs7(byte[] key, byte[] ciphertext) throws GeneralSecurityException {
        Cipher cipher = this.newAesCscPkcs7();
        IvParameterSpec iv = new IvParameterSpec(ciphertext, 0, 16);
        try (ZeroizableSecretKey secretKey = new ZeroizableSecretKey(key, "AES");){
            cipher.init(2, (Key)secretKey, iv);
            byte[] byArray = cipher.doFinal(ciphertext, 16, ciphertext.length - 16);
            return byArray;
        }
    }

    private byte[] hmacSha512(byte[] key, byte[] ... authenticateMe) throws GeneralSecurityException {
        Mac mac = this.newHmacSha512();
        try (ZeroizableSecretKey secretKey = new ZeroizableSecretKey(key, "HMAC");){
            mac.init(secretKey);
            for (byte[] bytes : authenticateMe) {
                mac.update(bytes);
            }
            byte[] byArray = mac.doFinal();
            return byArray;
        }
    }

    private Cipher newAesCscPkcs7() {
        return this.cryptoFactory.newCipher("AES/CBC/PKCS5Padding");
    }

    private Mac newHmacSha512() {
        return this.cryptoFactory.newMac("HmacSHA512");
    }

    private static long lengthInBits(byte[] bytes) {
        return (long)bytes.length * 8L;
    }

    private static byte[] concat(byte[] first, byte[] second) {
        byte[] result = new byte[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private static byte[] truncate(byte[] bytes, int length) {
        return Arrays.copyOfRange(bytes, 0, length);
    }

    private static byte[] longToBytes(long x) {
        return ByteBuffer.allocate(8).putLong(x).array();
    }
}

