/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption;

import com.couchbase.client.encryption.Keyring;
import com.couchbase.client.encryption.ListableKeyring;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreKeyring
implements ListableKeyring {
    private static final Logger log = LoggerFactory.getLogger(KeyStoreKeyring.class);
    private final Map<String, Keyring.Key> keyNameToKey;

    public KeyStoreKeyring(KeyStore keyStore, Function<String, String> keyNameToPassword) throws KeyStoreException {
        this.keyNameToKey = Collections.unmodifiableMap(this.getAllSecretKeys(keyStore, keyNameToPassword));
    }

    @Override
    public Optional<Keyring.Key> get(String keyId) {
        return Optional.ofNullable(this.keyNameToKey.get(keyId));
    }

    public Set<String> keyIds() {
        return this.keyNameToKey.keySet();
    }

    public Map<String, Keyring.Key> getAllSecretKeys(KeyStore keyStore, Function<String, String> keyNameToPassword) throws KeyStoreException {
        Objects.requireNonNull(keyNameToPassword);
        HashMap<String, Keyring.Key> aliasToKey = new HashMap<String, Keyring.Key>();
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            String password = keyNameToPassword.apply(alias);
            if (password == null) {
                log.debug("Ignoring key '{}' because the password is not known.", (Object)alias);
                continue;
            }
            try {
                KeyStore.Entry entry = keyStore.getEntry(alias, new KeyStore.PasswordProtection(password.toCharArray()));
                if (!(entry instanceof KeyStore.SecretKeyEntry)) {
                    log.debug("Ignoring key '{}' because the KeyStore entry type is not SecretKeyEntry; actual type is {}", (Object)alias, (Object)entry.getClass().getSimpleName());
                    continue;
                }
                byte[] keyBytes = ((KeyStore.SecretKeyEntry)entry).getSecretKey().getEncoded();
                aliasToKey.put(alias, Keyring.Key.create(alias, keyBytes));
            }
            catch (Exception e) {
                log.warn("Ignoring key '{}' because it could not be retrieved (wrong password?)", (Object)alias, (Object)e);
            }
        }
        return aliasToKey;
    }

    public static void setSecretKey(KeyStore keystore, String keyAlias, byte[] keyBytes, char[] keyPassword) throws KeyStoreException {
        String keyAlgorithm = "OID.1.3.9999.42";
        keystore.setEntry(keyAlias, new KeyStore.SecretKeyEntry(new SecretKeySpec(keyBytes, "OID.1.3.9999.42")), new KeyStore.PasswordProtection(keyPassword));
    }
}

