/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption;

import com.couchbase.client.encryption.RotatingKeyring;
import com.couchbase.client.encryption.errors.CryptoKeyNotFoundException;
import com.couchbase.client.encryption.internal.LangHelper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class FilesystemRotatingKeyring
extends RotatingKeyring {
    private final String filenameExtension;
    private final String primaryFilenameExtension;
    private final Path directory;

    public FilesystemRotatingKeyring(Path directory) {
        this(directory, "--", ".key", ".key.primary");
    }

    public FilesystemRotatingKeyring(Path directory, String versionDelimiter, String filenameExtension, String primaryFilenameExtension) {
        super(versionDelimiter);
        this.directory = Objects.requireNonNull(directory);
        this.filenameExtension = Objects.requireNonNull(filenameExtension);
        this.primaryFilenameExtension = Objects.requireNonNull(primaryFilenameExtension);
    }

    @Override
    protected String getPrimaryVersion(String baseName) {
        String string;
        block8: {
            Stream<Path> paths = Files.list(this.directory);
            try {
                string = paths.map(path -> LangHelper.substringBetween(path.getFileName().toString(), this.versionDelimiter, this.primaryFilenameExtension)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new CryptoKeyNotFoundException("Failed to locate primary version of key " + baseName));
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CryptoKeyNotFoundException("Failed to locate primary version of key " + baseName, e);
                }
            }
            paths.close();
        }
        return string;
    }

    @Override
    protected Optional<byte[]> getKeyBytes(RotatingKeyring.KeyNameAndVersion keyNameAndVersion) {
        Optional<byte[]> optional;
        block8: {
            String nameIfPrimary = keyNameAndVersion.format() + this.primaryFilenameExtension;
            String nameIfNotPrimary = keyNameAndVersion.format() + this.filenameExtension;
            Stream<Path> paths = Files.list(this.directory);
            try {
                optional = paths.filter(path -> {
                    String filename = path.getFileName().toString();
                    return filename.equals(nameIfNotPrimary) || filename.equals(nameIfPrimary);
                }).map(path -> {
                    try {
                        return Files.readAllBytes(path);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to read crypto key " + keyNameAndVersion.format(), e);
                    }
                }).findFirst();
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to locate crypto key " + keyNameAndVersion.format(), e);
                }
            }
            paths.close();
        }
        return optional;
    }
}

