/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption;

import com.couchbase.client.encryption.Keyring;
import com.couchbase.client.encryption.ListableKeyring;
import com.couchbase.client.encryption.internal.Zeroizer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemKeyring
implements ListableKeyring {
    private static final Logger log = LoggerFactory.getLogger(FilesystemKeyring.class);
    private final Path basedir;
    private final KeyFileFormat format;

    @Override
    public Collection<String> keyIds() {
        try {
            return Files.list(this.basedir).map(path -> path.toFile().getName()).filter(filename -> !filename.startsWith(".")).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FilesystemKeyring(String basedir, KeyFileFormat format) {
        this(Paths.get(basedir, new String[0]), format);
    }

    public FilesystemKeyring(Path basedir, KeyFileFormat format) {
        this.basedir = Objects.requireNonNull(basedir).toAbsolutePath();
        this.format = Objects.requireNonNull(format);
        this.keyIds();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Keyring.Key> get(String keyId) {
        Path keyFile = this.basedir.resolve(keyId);
        try (Zeroizer zeroizer = new Zeroizer();){
            byte[] fileBytes = zeroizer.add(Files.readAllBytes(keyFile));
            Optional<Keyring.Key> optional = Optional.of(Keyring.Key.create(keyId, this.format.decode(fileBytes)));
            return optional;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            log.debug("Failed to get key '{}'", (Object)keyId, (Object)e);
            return Optional.empty();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get key '" + keyId + "'", e);
        }
    }

    private static String removeWhitespace(String s2) {
        return s2.replaceAll("\\s", "");
    }

    static interface KeyFileFormat {
        public static final KeyFileFormat RAW = bytes -> bytes;
        public static final KeyFileFormat BASE64 = bytes -> Base64.getMimeDecoder().decode(bytes);

        public byte[] decode(byte[] var1);
    }
}

