/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption;

import com.couchbase.client.encryption.Keyring;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class EnvironmentVariableKeyring
implements Keyring {
    private final Function<String, String> keyNameToEnvironmentVariableName;

    public EnvironmentVariableKeyring() {
        this(keyName -> keyName.replaceAll("[.-]", "_"));
    }

    public EnvironmentVariableKeyring(Function<String, String> keyNameToEnvironmentVariableName) {
        this.keyNameToEnvironmentVariableName = Objects.requireNonNull(keyNameToEnvironmentVariableName);
    }

    @Override
    public Optional<Keyring.Key> get(String keyId) {
        String varName = this.keyNameToEnvironmentVariableName.apply(keyId);
        return Optional.ofNullable(System.getenv(varName)).map(value -> Keyring.Key.create(keyId, Base64.getMimeDecoder().decode((String)value)));
    }
}

