/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption;

import com.couchbase.client.core.encryption.CryptoManager;
import com.couchbase.client.encryption.Decrypter;
import com.couchbase.client.encryption.Encrypter;
import com.couchbase.client.encryption.EncryptionResult;
import com.couchbase.client.encryption.Keyring;
import com.couchbase.client.encryption.errors.DecrypterNotFoundException;
import com.couchbase.client.encryption.errors.DecryptionFailureException;
import com.couchbase.client.encryption.errors.EncrypterNotFoundException;
import com.couchbase.client.encryption.errors.EncryptionFailureException;
import com.couchbase.client.encryption.internal.LangHelper;
import com.couchbase.client.encryption.internal.LegacyAesDecrypter;
import com.couchbase.client.encryption.internal.LegacyRsaDecrypter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class DefaultCryptoManager
implements CryptoManager {
    private final String encryptedFieldNamePrefix;
    private final Map<String, Encrypter> aliasToEncrypter;
    private final Map<String, Decrypter> algorithmToDecrypter;

    private DefaultCryptoManager(Map<String, Decrypter> algorithmToDecrypter, Map<String, Encrypter> aliasToEncrypter, String encryptedFieldNamePrefix) {
        this.algorithmToDecrypter = Collections.unmodifiableMap(new HashMap<String, Decrypter>(algorithmToDecrypter));
        this.aliasToEncrypter = Collections.unmodifiableMap(new HashMap<String, Encrypter>(aliasToEncrypter));
        this.encryptedFieldNamePrefix = Objects.requireNonNull(encryptedFieldNamePrefix);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, Object> encrypt(byte[] plaintext, String encrypterAlias) {
        try {
            Encrypter encrypter = this.getEncrypterByAlias(encrypterAlias);
            EncryptionResult encrypted = encrypter.encrypt(plaintext);
            return encrypted.asMap();
        }
        catch (Exception e) {
            LangHelper.throwIfInstanceOf(e, EncryptionFailureException.class);
            throw new EncryptionFailureException("Encryption failed; " + e.getMessage(), e);
        }
    }

    public byte[] decrypt(Map<String, Object> encryptedNode) {
        try {
            EncryptionResult encrypted = EncryptionResult.fromMap(encryptedNode);
            return this.getDecrypter(encrypted).decrypt(encrypted);
        }
        catch (Exception e) {
            LangHelper.throwIfInstanceOf(e, DecryptionFailureException.class);
            throw new DecryptionFailureException("Decryption failed; " + e.getMessage(), e);
        }
    }

    public String mangle(String fieldName) {
        return this.encryptedFieldNamePrefix + fieldName;
    }

    public String demangle(String fieldName) {
        return LangHelper.removeStart(fieldName, this.encryptedFieldNamePrefix);
    }

    public boolean isMangled(String fieldName) {
        return fieldName.startsWith(this.encryptedFieldNamePrefix);
    }

    private Encrypter getEncrypterByAlias(String alias) {
        Encrypter encrypter = this.aliasToEncrypter.get(alias = LangHelper.defaultIfNull(alias, "__DEFAULT__"));
        if (encrypter != null) {
            return encrypter;
        }
        throw EncrypterNotFoundException.forAlias(alias);
    }

    private Decrypter getDecrypter(EncryptionResult encrypted) {
        String alg = encrypted.getAlgorithm();
        if (LangHelper.isNullOrEmpty(alg)) {
            throw new IllegalArgumentException("Encryption result is missing algorithm attribute.");
        }
        Decrypter decrypter = this.algorithmToDecrypter.get(alg);
        if (decrypter == null) {
            throw DecrypterNotFoundException.forAlgorithm(alg);
        }
        return decrypter;
    }

    public String toString() {
        return "DefaultCryptoManager{encryptedFieldNamePrefix='" + this.encryptedFieldNamePrefix + '\'' + ", aliasToEncrypter=" + this.aliasToEncrypter + ", algorithmToDecrypter=" + this.algorithmToDecrypter + '}';
    }

    public static class Builder {
        private String encryptedFieldNamePrefix = "encrypted$";
        private final Map<String, Decrypter> algorithmToDecrypter = new HashMap<String, Decrypter>();
        private final Map<String, Encrypter> aliasToEncrypter = new HashMap<String, Encrypter>();

        public Builder decrypter(Decrypter decrypter) {
            Decrypter previouslyRegistered = this.algorithmToDecrypter.putIfAbsent(decrypter.algorithm(), decrypter);
            if (previouslyRegistered != null) {
                throw new IllegalStateException("Algorithm '" + decrypter.algorithm() + "' is already associated with decrypter " + previouslyRegistered);
            }
            return this;
        }

        public Builder encrypter(String alias, Encrypter encrypter) {
            if (LangHelper.isNullOrEmpty(alias)) {
                throw new IllegalArgumentException("Encrypter alias cannot be null or empty");
            }
            Encrypter previouslyRegistered = this.aliasToEncrypter.putIfAbsent(alias, encrypter);
            if (previouslyRegistered != null) {
                throw new IllegalStateException("Encrypter alias '" + alias + "' is already associated with " + previouslyRegistered);
            }
            return this;
        }

        public Builder defaultEncrypter(Encrypter encrypter) {
            return this.encrypter("__DEFAULT__", encrypter);
        }

        public Builder legacyAesDecrypters(Keyring keyring, Function<String, String> encryptionKeyNameToSigningKeyName) {
            this.decrypter(LegacyAesDecrypter.aes128(keyring, encryptionKeyNameToSigningKeyName));
            this.decrypter(LegacyAesDecrypter.aes256(keyring, encryptionKeyNameToSigningKeyName));
            return this;
        }

        public Builder legacyRsaDecrypter(Keyring keyring, Function<String, String> publicKeyNameToPrivateKeyName) {
            return this.decrypter(new LegacyRsaDecrypter(keyring, publicKeyNameToPrivateKeyName));
        }

        public Builder encryptedFieldNamePrefix(String encryptedFieldNamePrefix) {
            if (LangHelper.isNullOrEmpty(encryptedFieldNamePrefix)) {
                throw new IllegalArgumentException("Encrypted field prefix cannot be null or empty");
            }
            this.encryptedFieldNamePrefix = encryptedFieldNamePrefix;
            return this;
        }

        public DefaultCryptoManager build() {
            return new DefaultCryptoManager(this.algorithmToDecrypter, this.aliasToEncrypter, this.encryptedFieldNamePrefix);
        }
    }
}

