/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption;

import com.couchbase.client.encryption.Decrypter;
import com.couchbase.client.encryption.Encrypter;
import com.couchbase.client.encryption.EncryptionResult;
import com.couchbase.client.encryption.Keyring;
import com.couchbase.client.encryption.internal.AeadAes256CbcHmacSha512Cipher;
import com.couchbase.client.encryption.internal.Zeroizer;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Optional;

public class AeadAes256CbcHmacSha512Provider {
    private static final String ALGORITHM = "AEAD_AES_256_CBC_HMAC_SHA512";
    private static final byte[] NO_ASSOCIATED_DATA = new byte[0];
    private final AeadAes256CbcHmacSha512Cipher cipher;
    private final Keyring keyring;

    public static Builder builder() {
        return new Builder();
    }

    private AeadAes256CbcHmacSha512Provider(AeadAes256CbcHmacSha512Cipher cipher, Keyring keyring) {
        this.cipher = Objects.requireNonNull(cipher);
        this.keyring = Objects.requireNonNull(keyring);
    }

    public Encrypter encrypterForKey(String keyName) {
        return plaintext -> {
            try (Zeroizer zeroizer = new Zeroizer();){
                Keyring.Key key = this.keyring.getOrThrow(keyName);
                EncryptionResult encryptionResult = EncryptionResult.forAlgorithm(ALGORITHM).put("kid", key.id()).put("ciphertext", this.cipher.encrypt(zeroizer.add(key.bytes()), plaintext, NO_ASSOCIATED_DATA));
                return encryptionResult;
            }
        };
    }

    public Decrypter decrypter() {
        return new Decrypter(){

            @Override
            public String algorithm() {
                return AeadAes256CbcHmacSha512Provider.ALGORITHM;
            }

            @Override
            public byte[] decrypt(EncryptionResult encrypted) throws Exception {
                try (Zeroizer zeroizer = new Zeroizer();){
                    Keyring.Key key = AeadAes256CbcHmacSha512Provider.this.keyring.getOrThrow(encrypted.getString("kid"));
                    byte[] byArray = AeadAes256CbcHmacSha512Provider.this.cipher.decrypt(zeroizer.add(key.bytes()), encrypted.getBytes("ciphertext"), NO_ASSOCIATED_DATA);
                    return byArray;
                }
            }
        };
    }

    public static class Builder {
        private Keyring keyring;
        private Optional<SecureRandom> secureRandom = Optional.empty();
        private Optional<Provider> securityProvider = Optional.empty();

        public Builder keyring(Keyring keyring) {
            this.keyring = Objects.requireNonNull(keyring);
            return this;
        }

        public Builder secureRandom(SecureRandom secureRandom) {
            this.secureRandom = Optional.ofNullable(secureRandom);
            return this;
        }

        public Builder securityProvider(Provider provider) {
            this.securityProvider = Optional.of(provider);
            return this;
        }

        public AeadAes256CbcHmacSha512Provider build() {
            if (this.keyring == null) {
                throw new IllegalStateException("Keyring not set.");
            }
            return new AeadAes256CbcHmacSha512Provider(new AeadAes256CbcHmacSha512Cipher(this.secureRandom.orElse(null), this.securityProvider.orElse(null)), this.keyring);
        }
    }
}

