package com.couchbase.client.encryption.deps.org.checkerframework.common.value.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import com.couchbase.client.encryption.deps.org.checkerframework.framework.qual.DefaultInUncheckedCodeFor;
import com.couchbase.client.encryption.deps.org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import com.couchbase.client.encryption.deps.org.checkerframework.framework.qual.SubtypeOf;
import com.couchbase.client.encryption.deps.org.checkerframework.framework.qual.TypeUseLocation;

/**
 * UnknownVal is a type annotation indicating that the expression's value is not known at compile
 * type.
 *
 * @checker_framework.manual #constant-value-checker Constant Value Checker
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
@SubtypeOf({})
@DefaultQualifierInHierarchy
@DefaultInUncheckedCodeFor(TypeUseLocation.PARAMETER)
public @interface UnknownVal {}
