package com.couchbase.client.encryption.deps.org.checkerframework.common.reflection.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import com.couchbase.client.encryption.deps.org.checkerframework.framework.qual.InvisibleQualifier;
import com.couchbase.client.encryption.deps.org.checkerframework.framework.qual.SubtypeOf;
import com.couchbase.client.encryption.deps.org.checkerframework.framework.qual.TargetLocations;
import com.couchbase.client.encryption.deps.org.checkerframework.framework.qual.TypeUseLocation;

/**
 * The bottom type in the ClassVal type system. Programmers should rarely write this type.
 *
 * @checker_framework.manual #methodval-and-classval-checkers ClassVal Checker
 * @checker_framework.manual #bottom-type the bottom type
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@TargetLocations({TypeUseLocation.EXPLICIT_LOWER_BOUND, TypeUseLocation.EXPLICIT_UPPER_BOUND})
@InvisibleQualifier
@SubtypeOf({ClassVal.class, ClassBound.class})
public @interface ClassValBottom {}
