/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption;

import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.encryption.Decrypter;
import com.couchbase.client.encryption.Encrypter;
import com.couchbase.client.encryption.EncryptionResult;
import com.couchbase.client.encryption.errors.InvalidCiphertextException;
import java.util.Objects;
import org.springframework.vault.VaultException;
import org.springframework.vault.core.VaultTransitOperations;
import org.springframework.vault.support.Ciphertext;
import org.springframework.vault.support.Plaintext;

public class SpringVaultTransitProvider {
    private static final String ALGORITHM = "HASHICORP_VAULT_TRANSIT";
    private final VaultTransitOperations transitOps;

    public SpringVaultTransitProvider(VaultTransitOperations vaultTransitOps) {
        this.transitOps = Objects.requireNonNull(vaultTransitOps);
    }

    public Decrypter decrypter() {
        return new Decrypter(){

            @Override
            public String algorithm() {
                return SpringVaultTransitProvider.ALGORITHM;
            }

            @Override
            public byte[] decrypt(EncryptionResult encrypted) throws Exception {
                try {
                    String keyName = encrypted.getString("kid");
                    String ciphertext = encrypted.getString("ciphertext");
                    return SpringVaultTransitProvider.this.transitOps.decrypt(keyName, Ciphertext.of((String)ciphertext)).getPlaintext();
                }
                catch (VaultException e) {
                    if (CbStrings.nullToEmpty((String)e.getMessage()).contains("invalid ciphertext")) {
                        throw new InvalidCiphertextException("Decryption failed.", e);
                    }
                    throw e;
                }
            }
        };
    }

    public Encrypter encrypterForKey(String keyName) {
        return plaintext -> {
            Ciphertext ciphertext = this.transitOps.encrypt(keyName, Plaintext.of((byte[])plaintext));
            return EncryptionResult.forAlgorithm(ALGORITHM).put("kid", keyName).put("ciphertext", ciphertext.getCiphertext());
        };
    }
}

