/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.columnar.client.java;

import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.TreeNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.util.Golang;
import com.couchbase.columnar.client.java.DataConversionException;
import com.couchbase.columnar.client.java.internal.JacksonTransformers;
import java.io.IOException;
import java.time.Duration;
import java.util.Optional;

public final class QueryMetrics {
    private final JsonNode rootNode;

    QueryMetrics(byte[] raw) {
        try {
            this.rootNode = JacksonTransformers.MAPPER.readTree(raw);
        }
        catch (IOException e) {
            throw new DataConversionException("Could not parse analytics metrics!", e);
        }
    }

    public Duration elapsedTime() {
        return this.decode(String.class, "elapsedTime").map(Golang::parseDuration).orElse(Duration.ZERO);
    }

    public Duration executionTime() {
        return this.decode(String.class, "executionTime").map(Golang::parseDuration).orElse(Duration.ZERO);
    }

    public long resultCount() {
        return this.decode(Long.class, "resultCount").orElse(0L);
    }

    public long resultSize() {
        return this.decode(Long.class, "resultSize").orElse(0L);
    }

    public long processedObjects() {
        return this.decode(Long.class, "processedObjects").orElse(0L);
    }

    private <T> Optional<T> decode(Class<T> target, String path) {
        try {
            JsonNode subNode = this.rootNode.path(path);
            if (subNode == null || subNode.isNull() || subNode.isMissingNode()) {
                return Optional.empty();
            }
            return Optional.ofNullable(JacksonTransformers.MAPPER.treeToValue((TreeNode)subNode, target));
        }
        catch (JsonProcessingException e) {
            throw new DataConversionException("Could not decode " + path + " in analytics metrics!", e);
        }
    }

    public String toString() {
        return "QueryMetrics{raw=" + RedactableArgument.redactUser((Object)Mapper.encodeAsString((Object)this.rootNode)) + "}";
    }
}

