/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.columnar.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.BuilderPropertySetter;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.InvalidPropertyException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.transaction.config.CoreTransactionsCleanupConfig;
import com.couchbase.client.core.transaction.config.CoreTransactionsConfig;
import com.couchbase.client.core.transaction.forwards.CoreTransactionsSupportedExtensions;
import com.couchbase.client.core.util.ConnectionString;
import com.couchbase.columnar.client.java.ClusterOptions;
import com.couchbase.columnar.client.java.Credential;
import com.couchbase.columnar.client.java.Database;
import com.couchbase.columnar.client.java.Environment;
import com.couchbase.columnar.client.java.QueryExecutor;
import com.couchbase.columnar.client.java.QueryMetadata;
import com.couchbase.columnar.client.java.QueryOptions;
import com.couchbase.columnar.client.java.QueryResult;
import com.couchbase.columnar.client.java.Queryable;
import com.couchbase.columnar.client.java.Row;
import com.couchbase.columnar.client.java.SecurityOptions;
import com.couchbase.columnar.client.java.TimeoutOptions;
import com.couchbase.columnar.client.java.internal.Certificates;
import java.io.Closeable;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.net.ssl.TrustManagerFactory;
import reactor.core.publisher.Mono;

public final class Cluster
implements Closeable,
Queryable {
    private final Environment environment;
    private final CoreCouchbaseOps couchbaseOps;
    final QueryExecutor queryExecutor;
    private final AtomicBoolean disconnected = new AtomicBoolean();

    public static Cluster newInstance(String connectionString, Credential credential) {
        return Cluster.newInstance(connectionString, credential, options -> {});
    }

    public static Cluster newInstance(String connectionString, Credential credential, Consumer<ClusterOptions> optionsCustomizer) {
        ConnectionString cs = ConnectionString.create((String)connectionString);
        if (cs.scheme() != ConnectionString.Scheme.COUCHBASES) {
            throw new IllegalArgumentException("Invalid connection string; must start with secure scheme \"couchbases://\" (note the final 's') but got: " + RedactableArgument.redactUser((Object)cs.original()));
        }
        Cluster.checkParameterNamesAreLowercase(cs);
        ClusterOptions builder = new ClusterOptions();
        optionsCustomizer.accept(builder);
        Cluster.applyConnectionStringParameters(builder, cs);
        ClusterOptions.Unmodifiable opts = builder.build();
        Environment.Builder envBuilder = (Environment.Builder)((Environment.Builder)((Environment.Builder)new Environment.Builder().transactionsConfig(Cluster.disableTransactionsCleanup())).deserializer(opts.deserializer()).ioConfig(it -> it.enableDnsSrv(opts.srv()).maxHttpConnections(Integer.MAX_VALUE))).securityConfig(it -> {
            TrustManagerFactory factory;
            SecurityOptions.Unmodifiable security = opts.security();
            it.enableTls(true);
            if (!security.cipherSuites().isEmpty()) {
                it.ciphers(security.cipherSuites());
            }
            if ((factory = security.trustSource().trustManagerFactory()) != null) {
                it.trustManagerFactory(factory);
            } else {
                it.trustCertificates(security.trustSource().certificates());
            }
        });
        TimeoutOptions.Unmodifiable timeouts = opts.timeout();
        envBuilder.timeoutConfig(it -> it.connectTimeout(timeouts.connectTimeout()).analyticsTimeout(timeouts.queryTimeout()));
        ((Environment.Builder)envBuilder.ioEnvironment(it -> it.enableNativeIo(false))).securityConfig(it -> it.enableNativeTls(false));
        Environment env = envBuilder.build();
        return new Cluster(cs, credential.toInternalAuthenticator(), env);
    }

    private static void applyConnectionStringParameters(ClusterOptions builder, ConnectionString cs) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(cs.params());
        boolean trustOnlyNonProdCertificates = Cluster.lastTrustParamIsNonProd(params);
        try {
            BuilderPropertySetter propertySetter = new BuilderPropertySetter("", Collections.emptyMap(), Cluster::lowerSnakeCaseToLowerCamelCase);
            propertySetter.set((Object)builder, params);
        }
        catch (InvalidPropertyException e) {
            throw new IllegalArgumentException(e.getMessage(), e.getCause());
        }
        if (trustOnlyNonProdCertificates) {
            builder.security(it -> it.trustOnlyCertificates(Certificates.getNonProdCertificates()));
        }
    }

    private static boolean lastTrustParamIsNonProd(LinkedHashMap<String, String> params) {
        String TRUST_ONLY_NON_PROD_PARAM = "security.trust_only_non_prod";
        boolean trustOnlyNonProdWasLast = params.keySet().stream().filter(it -> it.startsWith("security.trust_")).reduce((a, b) -> b).orElse("").equals("security.trust_only_non_prod");
        String trustOnlyNonProdValue = (String)params.remove("security.trust_only_non_prod");
        if (trustOnlyNonProdValue != null && !Set.of("", "true", "1").contains(trustOnlyNonProdValue)) {
            throw new IllegalArgumentException("Invalid value for connection string property 'security.trust_only_non_prod'; expected 'true', '1', or empty string, but got: '" + trustOnlyNonProdValue + "'");
        }
        return trustOnlyNonProdWasLast;
    }

    private static void checkParameterNamesAreLowercase(ConnectionString cs) {
        cs.params().keySet().stream().filter(Cluster::hasUppercase).findFirst().ifPresent(badName -> {
            throw new IllegalArgumentException("Invalid connection string parameter '" + badName + "'. Please use lower_snake_case in connection string parameter names.");
        });
    }

    private static boolean hasUppercase(String s) {
        return s.codePoints().anyMatch(Character::isUpperCase);
    }

    private static String lowerSnakeCaseToLowerCamelCase(String s) {
        StringBuilder sb = new StringBuilder();
        int[] codePoints = s.codePoints().toArray();
        boolean prevWasUnderscore = false;
        for (int i : codePoints) {
            if (i == 95) {
                prevWasUnderscore = true;
                continue;
            }
            if (prevWasUnderscore) {
                i = Character.toUpperCase(i);
            }
            sb.appendCodePoint(i);
            prevWasUnderscore = false;
        }
        return sb.toString();
    }

    private static CoreTransactionsConfig disableTransactionsCleanup() {
        return new CoreTransactionsConfig(CoreTransactionsConfig.DEFAULT_TRANSACTION_DURABILITY_LEVEL, CoreTransactionsConfig.DEFAULT_TRANSACTION_TIMEOUT, new CoreTransactionsCleanupConfig(false, false, CoreTransactionsCleanupConfig.DEFAULT_TRANSACTION_CLEANUP_WINDOW, Collections.emptySet()), null, null, null, 1024, Optional.empty(), Optional.empty(), CoreTransactionsSupportedExtensions.NONE);
    }

    private Cluster(ConnectionString connectionString, Authenticator authenticator, Environment environment) {
        this.environment = Objects.requireNonNull(environment);
        this.couchbaseOps = CoreCouchbaseOps.create((CoreEnvironment)environment, (Authenticator)authenticator, (ConnectionString)connectionString);
        Core core = this.couchbaseOps.asCore();
        core.initGlobalConfig();
        this.queryExecutor = new QueryExecutor(core, environment, connectionString);
    }

    @Override
    public void close() {
        Duration timeout = this.environment.timeoutConfig().disconnectTimeout();
        Cluster.disconnectInternal(this.disconnected, timeout, this.couchbaseOps, this.environment).block();
    }

    static Mono<Void> disconnectInternal(AtomicBoolean disconnected, Duration timeout, CoreCouchbaseOps couchbaseOps, CoreEnvironment environment) {
        return couchbaseOps.shutdown(timeout).then(environment.shutdownReactive(timeout)).then(Mono.fromRunnable(() -> disconnected.set(true)));
    }

    public Database database(String name) {
        return new Database(this, name);
    }

    @Override
    public QueryResult executeQuery(String statement, Consumer<QueryOptions> optionsCustomizer) {
        return this.queryExecutor.queryBuffered(statement, optionsCustomizer, null);
    }

    @Override
    public QueryMetadata executeStreamingQuery(String statement, Consumer<Row> rowAction, Consumer<QueryOptions> optionsCustomizer) {
        return this.queryExecutor.queryStreaming(statement, optionsCustomizer, null, rowAction);
    }
}

