/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.columnar.client.java;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.columnar.client.java.internal.Certificates;
import com.couchbase.columnar.client.java.internal.TrustSource;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.TrustManagerFactory;
import reactor.util.annotation.Nullable;

public final class SecurityOptions {
    private List<String> cipherSuites = Collections.emptyList();
    @Nullable
    private TrustSource trustSource = null;
    private boolean disableServerCertificateVerification = false;

    SecurityOptions() {
    }

    Unmodifiable build() {
        return new Unmodifiable(this);
    }

    public SecurityOptions cipherSuites(List<String> cipherSuites) {
        this.cipherSuites = CbCollections.listCopyOf(cipherSuites);
        return this;
    }

    public SecurityOptions trustOnlyCapella() {
        return this.trustOnlyCertificates(Certificates.getCapellaCertificates());
    }

    public SecurityOptions trustOnlyPemFile(Path pemFile) {
        return this.trustSource(TrustSource.from(pemFile));
    }

    public SecurityOptions trustOnlyPemString(String pemEncodedCertificates) {
        return this.trustSource(TrustSource.from(Certificates.parse(pemEncodedCertificates)));
    }

    public SecurityOptions trustOnlyCertificates(List<X509Certificate> certificates) {
        return this.trustSource(TrustSource.from(certificates));
    }

    public SecurityOptions trustOnlyJvm() {
        return this.trustSource(TrustSource.fromJvm());
    }

    public SecurityOptions trustOnlyFactory(TrustManagerFactory factory) {
        return this.trustSource(TrustSource.from(factory));
    }

    @Deprecated
    public SecurityOptions disableServerCertificateVerification(boolean disable) {
        this.disableServerCertificateVerification = disable;
        return this;
    }

    private SecurityOptions trustSource(TrustSource trustSource) {
        this.trustSource = Objects.requireNonNull(trustSource);
        return this;
    }

    static class Unmodifiable {
        private final List<String> cipherSuites;
        private final TrustSource trustSource;

        Unmodifiable(SecurityOptions builder) {
            this.cipherSuites = builder.cipherSuites;
            this.trustSource = builder.disableServerCertificateVerification ? TrustSource.insecure() : (builder.trustSource != null ? builder.trustSource : TrustSource.from(Certificates.getCapellaCertificates()));
        }

        public List<String> cipherSuites() {
            return this.cipherSuites;
        }

        @Stability.Internal
        TrustSource trustSource() {
            return this.trustSource;
        }

        public String toString() {
            return "SecuritySettings{cipherSuites=" + String.valueOf(this.cipherSuites) + ", trustSource=" + String.valueOf(this.trustSource) + "}";
        }
    }
}

